/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;

public class WifiApBlockProvider
extends ContentProvider {
    private static final String AUTHORITY = "android.net.wifi.WifiApBlockProvider";
    private static final String BSSID = "bssid";
    private static final String[] COLUMNS;
    public static final Uri CONTENT_URI;
    private static final String CREATE_BLOCKED_AP_TABLE = "CREATE TABLE blocked_ap(_id INTEGER PRIMARY KEY,ssid TEXT NOT NULL,bssid TEXT NOT NULL);";
    private static final String DATABASE_NAME = "blocked_ap.db";
    private static final String DATABASE_TABLE = "blocked_ap";
    private static final int DATABASE_TABLE_CODE = 1;
    private static final int DATABASE_VERSION = 2;
    private static final String ROWID = "_id";
    private static final String SSID = "ssid";
    private static final String TAG = "WifiApBlockProvider";
    private static final int URI_ROOT;
    private static final UriMatcher sUriMatcher;
    private SQLiteDatabase mDb;
    WifiApBlockDatabaseHelper mOpenHelper;

    static {
        CONTENT_URI = Uri.parse("content://android.net.wifi.WifiApBlockProvider/blocked_ap");
        COLUMNS = new String[]{ROWID, SSID, BSSID};
        sUriMatcher = new UriMatcher(-1);
        sUriMatcher.addURI(AUTHORITY, DATABASE_TABLE, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int delete(Uri uri, String string2, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        if (sQLiteDatabase == null) {
            return 0;
        }
        switch (sUriMatcher.match(uri)) {
            default: {
                throw new UnsupportedOperationException("Unknown delete URI " + uri.toString());
            }
            case 1: 
        }
        int n = sQLiteDatabase.delete(DATABASE_TABLE, string2, stringArray);
        if (n <= 0) return n;
        this.getContext().getContentResolver().notifyChange(uri, null, false);
        return n;
    }

    SQLiteDatabase getReadableDatabase() {
        return this.mOpenHelper.getReadableDatabase();
    }

    @Override
    public String getType(Uri uri) {
        return null;
    }

    SQLiteDatabase getWritableDatabase() {
        return this.mOpenHelper.getWritableDatabase();
    }

    @Override
    public Uri insert(Uri uri, ContentValues contentValues) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        if (sQLiteDatabase == null) {
            return null;
        }
        switch (sUriMatcher.match(uri)) {
            default: {
                throw new UnsupportedOperationException("Unknown insert URI " + uri.toString());
            }
            case 1: 
        }
        long l = sQLiteDatabase.insert(DATABASE_TABLE, null, contentValues);
        if (l < 0L) {
            return null;
        }
        Uri uri2 = ContentUris.withAppendedId(uri, l);
        this.getContext().getContentResolver().notifyChange(uri2, null, false);
        return uri2;
    }

    @Override
    public boolean onCreate() {
        this.mOpenHelper = new WifiApBlockDatabaseHelper(this.getContext());
        return true;
    }

    @Override
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        SQLiteDatabase sQLiteDatabase = this.getReadableDatabase();
        if (sQLiteDatabase == null) {
            return null;
        }
        switch (sUriMatcher.match(uri)) {
            default: {
                throw new UnsupportedOperationException("Unknown query URI " + uri.toString());
            }
            case 1: 
        }
        Cursor cursor = sQLiteDatabase.query(true, DATABASE_TABLE, stringArray, string2, stringArray2, null, null, string3, null);
        if (cursor.getCount() == 0) {
            cursor.close();
            return null;
        }
        cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        return cursor;
    }

    @Override
    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return 0;
    }

    private final class WifiApBlockDatabaseHelper
    extends SQLiteOpenHelper {
        public WifiApBlockDatabaseHelper(Context context) {
            super(context, WifiApBlockProvider.DATABASE_NAME, null, 2);
        }

        @Override
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL(WifiApBlockProvider.CREATE_BLOCKED_AP_TABLE);
        }

        @Override
        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS blocked_ap");
        }
    }
}

