/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.wifi.WifiApBlockProvider;
import android.util.Log;

public class WifiApBlock {
    private static final String BSSID = "bssid";
    private static final String[] COLUMNS = new String[]{"_id", "ssid", "bssid"};
    private static final String DATABASE_TABLE = "blocked_ap";
    private static final String ROWID = "_id";
    private static final String SSID = "ssid";
    private static final String TAG = "WifiApBlock";
    private static ContentResolver mContRes;
    private Context mContext;

    public WifiApBlock(Context context) {
        this.mContext = context;
        mContRes = this.mContext.getContentResolver();
    }

    private boolean deleteImpl(String string2, String[] stringArray) {
        return mContRes.delete(WifiApBlockProvider.CONTENT_URI, string2, stringArray) > 0;
    }

    private boolean isContainsBSSID(String string2) {
        return this.isContainsImpl("bssid= ?", new String[]{string2});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isContainsImpl(String string2, String[] stringArray) {
        Cursor cursor = mContRes.query(WifiApBlockProvider.CONTENT_URI, COLUMNS, string2, stringArray, null);
        boolean bl = cursor != null && cursor.getCount() != 0;
        if (cursor == null) return bl;
        cursor.close();
        return bl;
    }

    private boolean isContainsSSID(String string2) {
        return this.isContainsImpl("ssid= ?", new String[]{string2});
    }

    public boolean containsByBSSID(String string2) {
        return this.isContainsBSSID(string2);
    }

    public boolean containsBySSID(String string2) {
        return this.isContainsSSID(string2);
    }

    public boolean deleteByBSSID(String string2) {
        if (this.deleteImpl("bssid= ?", new String[]{string2})) {
            Log.i(TAG, "[True] deleteByBSSID() - BSID: " + string2);
            return true;
        }
        Log.i(TAG, "[False] deleteByBSSID() - BSSID: " + string2 + " cannot be found in db");
        return false;
    }

    public boolean deleteBySSID(String string2) {
        if (this.deleteImpl("ssid= ?", new String[]{string2})) {
            Log.i(TAG, "[True] deleteBySSID() - SSID: " + string2);
            return true;
        }
        Log.i(TAG, "[False] deleteBySSID() - SSID: " + string2 + " cannot be found in db");
        return false;
    }

    public boolean insert(String string2, String string3) {
        if (this.containsByBSSID(string2)) {
            Log.i(TAG, "[False] insert() - SSID: " + string2 + " exists in db already");
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put(SSID, string2);
        contentValues.put(BSSID, string3);
        mContRes.insert(WifiApBlockProvider.CONTENT_URI, contentValues);
        Log.i(TAG, "[True] insert() - SSID: " + string2 + ", BSSID: " + string3);
        return true;
    }
}

