/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.DhcpInfo;
import android.net.wifi.BatchedScanResult;
import android.net.wifi.BatchedScanSettings;
import android.net.wifi.ScanResult;
import android.net.wifi.ScanSettings;
import android.net.wifi.WifiActivityEnergyInfo;
import android.net.wifi.WifiChannel;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiConnectionStatistics;
import android.net.wifi.WifiInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Messenger;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.WorkSource;
import java.util.ArrayList;
import java.util.List;

public interface IWifiManager
extends IInterface {
    public void acquireMulticastLock(IBinder var1, String var2) throws RemoteException;

    public boolean acquireWifiLock(IBinder var1, int var2, String var3, WorkSource var4) throws RemoteException;

    public int addOrUpdateNetwork(WifiConfiguration var1) throws RemoteException;

    public void addToBlacklist(String var1) throws RemoteException;

    public void clearBlacklist() throws RemoteException;

    public void configureWlanRTCoex() throws RemoteException;

    public boolean disableNetwork(int var1) throws RemoteException;

    public void disconnect() throws RemoteException;

    public void enableAggressiveHandover(int var1) throws RemoteException;

    public boolean enableNetwork(int var1, boolean var2) throws RemoteException;

    public void enableTdls(String var1, boolean var2) throws RemoteException;

    public void enableTdlsWithMacAddress(String var1, boolean var2) throws RemoteException;

    public void enableVerboseLogging(int var1) throws RemoteException;

    public int getAggressiveHandover() throws RemoteException;

    public int getAllowScansWithTraffic() throws RemoteException;

    public List<BatchedScanResult> getBatchedScanResults(String var1) throws RemoteException;

    public List<WifiChannel> getChannelList() throws RemoteException;

    public String getConfigFile() throws RemoteException;

    public List<WifiConfiguration> getConfiguredNetworks() throws RemoteException;

    public WifiInfo getConnectionInfo() throws RemoteException;

    public WifiConnectionStatistics getConnectionStatistics() throws RemoteException;

    public DhcpInfo getDhcpInfo() throws RemoteException;

    public int getFrequencyBand() throws RemoteException;

    public List<WifiConfiguration> getPrivilegedConfiguredNetworks() throws RemoteException;

    public List<ScanResult> getScanResults(String var1) throws RemoteException;

    public int getSupportedFeatures() throws RemoteException;

    public int getVerboseLoggingLevel() throws RemoteException;

    public WifiConfiguration getWifiApConfiguration() throws RemoteException;

    public int getWifiApEnabledState() throws RemoteException;

    public int getWifiEnabledState() throws RemoteException;

    public int getWifiSafeChannelBitmap() throws RemoteException;

    public Messenger getWifiServiceMessenger() throws RemoteException;

    public String getWpsNfcConfigurationToken(int var1) throws RemoteException;

    public void initializeMulticastFiltering() throws RemoteException;

    public boolean isBatchedScanSupported() throws RemoteException;

    public boolean isDualBandSupported() throws RemoteException;

    public boolean isMulticastEnabled() throws RemoteException;

    public boolean isScanAlwaysAvailable() throws RemoteException;

    public boolean pingSupplicant() throws RemoteException;

    public void pollBatchedScan() throws RemoteException;

    public void reassociate() throws RemoteException;

    public void reconnect() throws RemoteException;

    public void releaseMulticastLock() throws RemoteException;

    public boolean releaseWifiLock(IBinder var1) throws RemoteException;

    public boolean removeNetwork(int var1) throws RemoteException;

    public WifiActivityEnergyInfo reportActivityInfo() throws RemoteException;

    public boolean requestBatchedScan(BatchedScanSettings var1, IBinder var2, WorkSource var3) throws RemoteException;

    public boolean saveConfiguration() throws RemoteException;

    public void setAllowScansWithTraffic(int var1) throws RemoteException;

    public void setCountryCode(String var1, boolean var2) throws RemoteException;

    public void setFrequencyBand(int var1, boolean var2) throws RemoteException;

    public void setRTCoexMode(int var1, int var2) throws RemoteException;

    public void setSafeChannel(int var1) throws RemoteException;

    public void setWifiApConfiguration(WifiConfiguration var1) throws RemoteException;

    public void setWifiApEnabled(WifiConfiguration var1, boolean var2) throws RemoteException;

    public void setWifiApEnabledWithBinder(IBinder var1, WifiConfiguration var2, boolean var3) throws RemoteException;

    public boolean setWifiEnabled(boolean var1) throws RemoteException;

    public void startScan(ScanSettings var1, WorkSource var2) throws RemoteException;

    public void startWifi() throws RemoteException;

    public void stopBatchedScan(BatchedScanSettings var1) throws RemoteException;

    public void stopWifi() throws RemoteException;

    public void updateWifiLockWorkSource(IBinder var1, WorkSource var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiManager {
        private static final String DESCRIPTOR = "android.net.wifi.IWifiManager";
        static final int TRANSACTION_acquireMulticastLock = 31;
        static final int TRANSACTION_acquireWifiLock = 26;
        static final int TRANSACTION_addOrUpdateNetwork = 5;
        static final int TRANSACTION_addToBlacklist = 40;
        static final int TRANSACTION_clearBlacklist = 41;
        static final int TRANSACTION_configureWlanRTCoex = 60;
        static final int TRANSACTION_disableNetwork = 8;
        static final int TRANSACTION_disconnect = 13;
        static final int TRANSACTION_enableAggressiveHandover = 55;
        static final int TRANSACTION_enableNetwork = 7;
        static final int TRANSACTION_enableTdls = 44;
        static final int TRANSACTION_enableTdlsWithMacAddress = 45;
        static final int TRANSACTION_enableVerboseLogging = 52;
        static final int TRANSACTION_getAggressiveHandover = 54;
        static final int TRANSACTION_getAllowScansWithTraffic = 56;
        static final int TRANSACTION_getBatchedScanResults = 48;
        static final int TRANSACTION_getChannelList = 10;
        static final int TRANSACTION_getConfigFile = 43;
        static final int TRANSACTION_getConfiguredNetworks = 3;
        static final int TRANSACTION_getConnectionInfo = 16;
        static final int TRANSACTION_getConnectionStatistics = 58;
        static final int TRANSACTION_getDhcpInfo = 24;
        static final int TRANSACTION_getFrequencyBand = 21;
        static final int TRANSACTION_getPrivilegedConfiguredNetworks = 4;
        static final int TRANSACTION_getScanResults = 12;
        static final int TRANSACTION_getSupportedFeatures = 1;
        static final int TRANSACTION_getVerboseLoggingLevel = 53;
        static final int TRANSACTION_getWifiApConfiguration = 36;
        static final int TRANSACTION_getWifiApEnabledState = 35;
        static final int TRANSACTION_getWifiEnabledState = 18;
        static final int TRANSACTION_getWifiSafeChannelBitmap = 62;
        static final int TRANSACTION_getWifiServiceMessenger = 42;
        static final int TRANSACTION_getWpsNfcConfigurationToken = 51;
        static final int TRANSACTION_initializeMulticastFiltering = 29;
        static final int TRANSACTION_isBatchedScanSupported = 49;
        static final int TRANSACTION_isDualBandSupported = 22;
        static final int TRANSACTION_isMulticastEnabled = 30;
        static final int TRANSACTION_isScanAlwaysAvailable = 25;
        static final int TRANSACTION_pingSupplicant = 9;
        static final int TRANSACTION_pollBatchedScan = 50;
        static final int TRANSACTION_reassociate = 15;
        static final int TRANSACTION_reconnect = 14;
        static final int TRANSACTION_releaseMulticastLock = 32;
        static final int TRANSACTION_releaseWifiLock = 28;
        static final int TRANSACTION_removeNetwork = 6;
        static final int TRANSACTION_reportActivityInfo = 2;
        static final int TRANSACTION_requestBatchedScan = 46;
        static final int TRANSACTION_saveConfiguration = 23;
        static final int TRANSACTION_setAllowScansWithTraffic = 57;
        static final int TRANSACTION_setCountryCode = 19;
        static final int TRANSACTION_setFrequencyBand = 20;
        static final int TRANSACTION_setRTCoexMode = 59;
        static final int TRANSACTION_setSafeChannel = 61;
        static final int TRANSACTION_setWifiApConfiguration = 37;
        static final int TRANSACTION_setWifiApEnabled = 33;
        static final int TRANSACTION_setWifiApEnabledWithBinder = 34;
        static final int TRANSACTION_setWifiEnabled = 17;
        static final int TRANSACTION_startScan = 11;
        static final int TRANSACTION_startWifi = 38;
        static final int TRANSACTION_stopBatchedScan = 47;
        static final int TRANSACTION_stopWifi = 39;
        static final int TRANSACTION_updateWifiLockWorkSource = 27;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWifiManager asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IWifiManager) {
                return (IWifiManager)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = this.getSupportedFeatures();
                    parcel2.writeNoException();
                    parcel2.writeInt(n3);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    WifiActivityEnergyInfo wifiActivityEnergyInfo = this.reportActivityInfo();
                    parcel2.writeNoException();
                    if (wifiActivityEnergyInfo != null) {
                        parcel2.writeInt(1);
                        wifiActivityEnergyInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<WifiConfiguration> list = this.getConfiguredNetworks();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<WifiConfiguration> list = this.getPrivilegedConfiguredNetworks();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    WifiConfiguration wifiConfiguration = parcel.readInt() != 0 ? WifiConfiguration.CREATOR.createFromParcel(parcel) : null;
                    int n4 = this.addOrUpdateNetwork(wifiConfiguration);
                    parcel2.writeNoException();
                    parcel2.writeInt(n4);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.removeNetwork(parcel.readInt());
                    parcel2.writeNoException();
                    int n5 = bl ? 1 : 0;
                    parcel2.writeInt(n5);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n6 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = this.enableNetwork(n6, bl);
                    parcel2.writeNoException();
                    int n7 = bl2 ? 1 : 0;
                    parcel2.writeInt(n7);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.disableNetwork(parcel.readInt());
                    parcel2.writeNoException();
                    int n8 = bl ? 1 : 0;
                    parcel2.writeInt(n8);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.pingSupplicant();
                    parcel2.writeNoException();
                    int n9 = bl ? 1 : 0;
                    parcel2.writeInt(n9);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<WifiChannel> list = this.getChannelList();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ScanSettings scanSettings = parcel.readInt() != 0 ? ScanSettings.CREATOR.createFromParcel(parcel) : null;
                    WorkSource workSource = parcel.readInt() != 0 ? WorkSource.CREATOR.createFromParcel(parcel) : null;
                    this.startScan(scanSettings, workSource);
                    parcel2.writeNoException();
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<ScanResult> list = this.getScanResults(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.disconnect();
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.reconnect();
                    parcel2.writeNoException();
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.reassociate();
                    parcel2.writeNoException();
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    WifiInfo wifiInfo = this.getConnectionInfo();
                    parcel2.writeNoException();
                    if (wifiInfo != null) {
                        parcel2.writeInt(1);
                        wifiInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    boolean bl3 = this.setWifiEnabled(bl);
                    parcel2.writeNoException();
                    int n10 = bl3 ? 1 : 0;
                    parcel2.writeInt(n10);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n11 = this.getWifiEnabledState();
                    parcel2.writeNoException();
                    parcel2.writeInt(n11);
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    this.setCountryCode(string2, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n12 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.setFrequencyBand(n12, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n13 = this.getFrequencyBand();
                    parcel2.writeNoException();
                    parcel2.writeInt(n13);
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isDualBandSupported();
                    parcel2.writeNoException();
                    int n14 = bl ? 1 : 0;
                    parcel2.writeInt(n14);
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.saveConfiguration();
                    parcel2.writeNoException();
                    int n15 = bl ? 1 : 0;
                    parcel2.writeInt(n15);
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    DhcpInfo dhcpInfo = this.getDhcpInfo();
                    parcel2.writeNoException();
                    if (dhcpInfo != null) {
                        parcel2.writeInt(1);
                        dhcpInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isScanAlwaysAvailable();
                    parcel2.writeNoException();
                    int n16 = bl ? 1 : 0;
                    parcel2.writeInt(n16);
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    int n17 = parcel.readInt();
                    String string3 = parcel.readString();
                    WorkSource workSource = parcel.readInt() != 0 ? WorkSource.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.acquireWifiLock(iBinder, n17, string3, workSource);
                    parcel2.writeNoException();
                    int n18 = bl ? 1 : 0;
                    parcel2.writeInt(n18);
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    WorkSource workSource = parcel.readInt() != 0 ? WorkSource.CREATOR.createFromParcel(parcel) : null;
                    this.updateWifiLockWorkSource(iBinder, workSource);
                    parcel2.writeNoException();
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.releaseWifiLock(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    int n19 = bl ? 1 : 0;
                    parcel2.writeInt(n19);
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.initializeMulticastFiltering();
                    parcel2.writeNoException();
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isMulticastEnabled();
                    parcel2.writeNoException();
                    int n20 = bl ? 1 : 0;
                    parcel2.writeInt(n20);
                    return true;
                }
                case 31: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.acquireMulticastLock(parcel.readStrongBinder(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 32: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.releaseMulticastLock();
                    parcel2.writeNoException();
                    return true;
                }
                case 33: {
                    parcel.enforceInterface(DESCRIPTOR);
                    WifiConfiguration wifiConfiguration = parcel.readInt() != 0 ? WifiConfiguration.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    this.setWifiApEnabled(wifiConfiguration, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 34: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    WifiConfiguration wifiConfiguration = parcel.readInt() != 0 ? WifiConfiguration.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    this.setWifiApEnabledWithBinder(iBinder, wifiConfiguration, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 35: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n21 = this.getWifiApEnabledState();
                    parcel2.writeNoException();
                    parcel2.writeInt(n21);
                    return true;
                }
                case 36: {
                    parcel.enforceInterface(DESCRIPTOR);
                    WifiConfiguration wifiConfiguration = this.getWifiApConfiguration();
                    parcel2.writeNoException();
                    if (wifiConfiguration != null) {
                        parcel2.writeInt(1);
                        wifiConfiguration.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 37: {
                    parcel.enforceInterface(DESCRIPTOR);
                    WifiConfiguration wifiConfiguration = parcel.readInt() != 0 ? WifiConfiguration.CREATOR.createFromParcel(parcel) : null;
                    this.setWifiApConfiguration(wifiConfiguration);
                    parcel2.writeNoException();
                    return true;
                }
                case 38: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.startWifi();
                    parcel2.writeNoException();
                    return true;
                }
                case 39: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.stopWifi();
                    parcel2.writeNoException();
                    return true;
                }
                case 40: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.addToBlacklist(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 41: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearBlacklist();
                    parcel2.writeNoException();
                    return true;
                }
                case 42: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Messenger messenger = this.getWifiServiceMessenger();
                    parcel2.writeNoException();
                    if (messenger != null) {
                        parcel2.writeInt(1);
                        messenger.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 43: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string4 = this.getConfigFile();
                    parcel2.writeNoException();
                    parcel2.writeString(string4);
                    return true;
                }
                case 44: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string5 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    this.enableTdls(string5, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 45: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string6 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    this.enableTdlsWithMacAddress(string6, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 46: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BatchedScanSettings batchedScanSettings = parcel.readInt() != 0 ? BatchedScanSettings.CREATOR.createFromParcel(parcel) : null;
                    IBinder iBinder = parcel.readStrongBinder();
                    WorkSource workSource = parcel.readInt() != 0 ? WorkSource.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.requestBatchedScan(batchedScanSettings, iBinder, workSource);
                    parcel2.writeNoException();
                    int n22 = bl ? 1 : 0;
                    parcel2.writeInt(n22);
                    return true;
                }
                case 47: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BatchedScanSettings batchedScanSettings = parcel.readInt() != 0 ? BatchedScanSettings.CREATOR.createFromParcel(parcel) : null;
                    this.stopBatchedScan(batchedScanSettings);
                    parcel2.writeNoException();
                    return true;
                }
                case 48: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<BatchedScanResult> list = this.getBatchedScanResults(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 49: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isBatchedScanSupported();
                    parcel2.writeNoException();
                    int n23 = bl ? 1 : 0;
                    parcel2.writeInt(n23);
                    return true;
                }
                case 50: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.pollBatchedScan();
                    parcel2.writeNoException();
                    return true;
                }
                case 51: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string7 = this.getWpsNfcConfigurationToken(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeString(string7);
                    return true;
                }
                case 52: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.enableVerboseLogging(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 53: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n24 = this.getVerboseLoggingLevel();
                    parcel2.writeNoException();
                    parcel2.writeInt(n24);
                    return true;
                }
                case 54: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n25 = this.getAggressiveHandover();
                    parcel2.writeNoException();
                    parcel2.writeInt(n25);
                    return true;
                }
                case 55: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.enableAggressiveHandover(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 56: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n26 = this.getAllowScansWithTraffic();
                    parcel2.writeNoException();
                    parcel2.writeInt(n26);
                    return true;
                }
                case 57: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setAllowScansWithTraffic(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 58: {
                    parcel.enforceInterface(DESCRIPTOR);
                    WifiConnectionStatistics wifiConnectionStatistics = this.getConnectionStatistics();
                    parcel2.writeNoException();
                    if (wifiConnectionStatistics != null) {
                        parcel2.writeInt(1);
                        wifiConnectionStatistics.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 59: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setRTCoexMode(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 60: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.configureWlanRTCoex();
                    parcel2.writeNoException();
                    return true;
                }
                case 61: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setSafeChannel(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 62: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            int n27 = this.getWifiSafeChannelBitmap();
            parcel2.writeNoException();
            parcel2.writeInt(n27);
            return true;
        }

        private static class Proxy
        implements IWifiManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public void acquireMulticastLock(IBinder iBinder, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    this.mRemote.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean acquireWifiLock(IBinder iBinder, int n, String string2, WorkSource workSource) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            parcel2.writeStrongBinder(iBinder);
                            parcel2.writeInt(n);
                            parcel2.writeString(string2);
                            if (workSource != null) {
                                parcel2.writeInt(1);
                                workSource.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(26, parcel2, parcel, 0);
                            parcel.readException();
                            int n2 = parcel.readInt();
                            if (n2 == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int addOrUpdateNetwork(WifiConfiguration wifiConfiguration) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (wifiConfiguration != null) {
                        parcel.writeInt(1);
                        wifiConfiguration.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void addToBlacklist(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(40, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void clearBlacklist() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(41, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void configureWlanRTCoex() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(60, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean disableNetwork(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void disconnect() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void enableAggressiveHandover(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(55, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean enableNetwork(int n, boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl2;
                block3: {
                    block2: {
                        bl2 = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            parcel2.writeInt(n);
                            boolean bl3 = bl ? bl2 : false;
                            parcel2.writeInt(bl3 ? 1 : 0);
                            this.mRemote.transact(7, parcel2, parcel, 0);
                            parcel.readException();
                            int n2 = parcel.readInt();
                            if (n2 == 0) break block2;
                            break block3;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl2 = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl2;
            }

            @Override
            public void enableTdls(String string2, boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(44, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void enableTdlsWithMacAddress(String string2, boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(45, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void enableVerboseLogging(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(52, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getAggressiveHandover() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(54, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getAllowScansWithTraffic() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(56, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<BatchedScanResult> getBatchedScanResults(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(48, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<BatchedScanResult> arrayList = parcel2.createTypedArrayList(BatchedScanResult.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<WifiChannel> getChannelList() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<WifiChannel> arrayList = parcel2.createTypedArrayList(WifiChannel.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getConfigFile() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(43, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<WifiConfiguration> getConfiguredNetworks() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<WifiConfiguration> arrayList = parcel2.createTypedArrayList(WifiConfiguration.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public WifiInfo getConnectionInfo() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    WifiInfo wifiInfo = parcel2.readInt() != 0 ? WifiInfo.CREATOR.createFromParcel(parcel2) : null;
                    return wifiInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public WifiConnectionStatistics getConnectionStatistics() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(58, parcel, parcel2, 0);
                    parcel2.readException();
                    WifiConnectionStatistics wifiConnectionStatistics = parcel2.readInt() != 0 ? WifiConnectionStatistics.CREATOR.createFromParcel(parcel2) : null;
                    return wifiConnectionStatistics;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public DhcpInfo getDhcpInfo() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    DhcpInfo dhcpInfo = parcel2.readInt() != 0 ? DhcpInfo.CREATOR.createFromParcel(parcel2) : null;
                    return dhcpInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getFrequencyBand() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public List<WifiConfiguration> getPrivilegedConfiguredNetworks() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<WifiConfiguration> arrayList = parcel2.createTypedArrayList(WifiConfiguration.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<ScanResult> getScanResults(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ScanResult> arrayList = parcel2.createTypedArrayList(ScanResult.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getSupportedFeatures() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getVerboseLoggingLevel() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(53, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public WifiConfiguration getWifiApConfiguration() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(36, parcel, parcel2, 0);
                    parcel2.readException();
                    WifiConfiguration wifiConfiguration = parcel2.readInt() != 0 ? WifiConfiguration.CREATOR.createFromParcel(parcel2) : null;
                    return wifiConfiguration;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getWifiApEnabledState() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(35, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getWifiEnabledState() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getWifiSafeChannelBitmap() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(62, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Messenger getWifiServiceMessenger() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(42, parcel, parcel2, 0);
                    parcel2.readException();
                    Messenger messenger = parcel2.readInt() != 0 ? Messenger.CREATOR.createFromParcel(parcel2) : null;
                    return messenger;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getWpsNfcConfigurationToken(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(51, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void initializeMulticastFiltering() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean isBatchedScanSupported() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(49, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isDualBandSupported() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isMulticastEnabled() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isScanAlwaysAvailable() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean pingSupplicant() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void pollBatchedScan() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(50, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void reassociate() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void reconnect() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void releaseMulticastLock() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean releaseWifiLock(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean removeNetwork(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public WifiActivityEnergyInfo reportActivityInfo() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    WifiActivityEnergyInfo wifiActivityEnergyInfo = parcel2.readInt() != 0 ? WifiActivityEnergyInfo.CREATOR.createFromParcel(parcel2) : null;
                    return wifiActivityEnergyInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean requestBatchedScan(BatchedScanSettings batchedScanSettings, IBinder iBinder, WorkSource workSource) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block9: {
                    block8: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (batchedScanSettings != null) {
                                parcel2.writeInt(1);
                                batchedScanSettings.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeStrongBinder(iBinder);
                            if (workSource != null) {
                                parcel2.writeInt(1);
                                workSource.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(46, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block8;
                            break block9;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            @Override
            public boolean saveConfiguration() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setAllowScansWithTraffic(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(57, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setCountryCode(String string2, boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(19, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setFrequencyBand(int n, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(20, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setRTCoexMode(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(59, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setSafeChannel(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(61, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setWifiApConfiguration(WifiConfiguration wifiConfiguration) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (wifiConfiguration != null) {
                        parcel.writeInt(1);
                        wifiConfiguration.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(37, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setWifiApEnabled(WifiConfiguration wifiConfiguration, boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                int n;
                block5: {
                    n = 1;
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    try {
                        parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                        if (wifiConfiguration != null) {
                            parcel2.writeInt(1);
                            wifiConfiguration.writeToParcel(parcel2, 0);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        parcel.recycle();
                        parcel2.recycle();
                        throw throwable;
                    }
                    {
                        parcel2.writeInt(0);
                    }
                }
                if (!bl) {
                    n = 0;
                }
                parcel2.writeInt(n);
                this.mRemote.transact(33, parcel2, parcel, 0);
                parcel.readException();
                parcel.recycle();
                parcel2.recycle();
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setWifiApEnabledWithBinder(IBinder iBinder, WifiConfiguration wifiConfiguration, boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                int n;
                block5: {
                    n = 1;
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    try {
                        parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                        parcel2.writeStrongBinder(iBinder);
                        if (wifiConfiguration != null) {
                            parcel2.writeInt(1);
                            wifiConfiguration.writeToParcel(parcel2, 0);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        parcel.recycle();
                        parcel2.recycle();
                        throw throwable;
                    }
                    {
                        parcel2.writeInt(0);
                    }
                }
                if (!bl) {
                    n = 0;
                }
                parcel2.writeInt(n);
                this.mRemote.transact(34, parcel2, parcel, 0);
                parcel.readException();
                parcel.recycle();
                parcel2.recycle();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setWifiEnabled(boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl2;
                block3: {
                    block2: {
                        bl2 = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            boolean bl3 = bl ? bl2 : false;
                            parcel2.writeInt(bl3 ? 1 : 0);
                            this.mRemote.transact(17, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block2;
                            break block3;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl2 = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void startScan(ScanSettings scanSettings, WorkSource workSource) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (scanSettings != null) {
                        parcel.writeInt(1);
                        scanSettings.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (workSource != null) {
                        parcel.writeInt(1);
                        workSource.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void startWifi() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(38, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void stopBatchedScan(BatchedScanSettings batchedScanSettings) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (batchedScanSettings != null) {
                        parcel.writeInt(1);
                        batchedScanSettings.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(47, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void stopWifi() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(39, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void updateWifiLockWorkSource(IBinder iBinder, WorkSource workSource) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    if (workSource != null) {
                        parcel.writeInt(1);
                        workSource.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

