/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.content.Context;
import android.net.nsd.INsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import java.util.concurrent.CountDownLatch;

public final class NsdManager {
    public static final String ACTION_NSD_STATE_CHANGED = "android.net.nsd.STATE_CHANGED";
    private static final int BASE = 393216;
    private static final int BUSY_LISTENER_KEY = -1;
    public static final int DISABLE = 393241;
    public static final int DISCOVER_SERVICES = 393217;
    public static final int DISCOVER_SERVICES_FAILED = 393219;
    public static final int DISCOVER_SERVICES_STARTED = 393218;
    public static final int ENABLE = 393240;
    public static final String EXTRA_NSD_STATE = "nsd_state";
    public static final int FAILURE_ALREADY_ACTIVE = 3;
    public static final int FAILURE_INTERNAL_ERROR = 0;
    public static final int FAILURE_MAX_LIMIT = 4;
    private static final int INVALID_LISTENER_KEY = 0;
    public static final int NATIVE_DAEMON_EVENT = 393242;
    public static final int NSD_STATE_DISABLED = 1;
    public static final int NSD_STATE_ENABLED = 2;
    public static final int PROTOCOL_DNS_SD = 1;
    public static final int REGISTER_SERVICE = 393225;
    public static final int REGISTER_SERVICE_FAILED = 393226;
    public static final int REGISTER_SERVICE_SUCCEEDED = 393227;
    public static final int RESOLVE_SERVICE = 393234;
    public static final int RESOLVE_SERVICE_FAILED = 393235;
    public static final int RESOLVE_SERVICE_SUCCEEDED = 393236;
    public static final int SERVICE_FOUND = 393220;
    public static final int SERVICE_LOST = 393221;
    public static final int STOP_DISCOVERY = 393222;
    public static final int STOP_DISCOVERY_FAILED = 393223;
    public static final int STOP_DISCOVERY_SUCCEEDED = 393224;
    private static final String TAG = "NsdManager";
    public static final int UNREGISTER_SERVICE = 393228;
    public static final int UNREGISTER_SERVICE_FAILED = 393229;
    public static final int UNREGISTER_SERVICE_SUCCEEDED = 393230;
    private final AsyncChannel mAsyncChannel;
    private final CountDownLatch mConnected;
    private Context mContext;
    private ServiceHandler mHandler;
    private int mListenerKey = 1;
    private final SparseArray mListenerMap = new SparseArray();
    private final Object mMapLock;
    INsdManager mService;
    private final SparseArray<NsdServiceInfo> mServiceMap = new SparseArray();

    public NsdManager(Context context, INsdManager iNsdManager) {
        this.mMapLock = new Object();
        this.mAsyncChannel = new AsyncChannel();
        this.mConnected = new CountDownLatch(1);
        this.mService = iNsdManager;
        this.mContext = context;
        this.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getListener(int n) {
        if (n == 0) {
            return null;
        }
        Object object = this.mMapLock;
        synchronized (object) {
            return this.mListenerMap.get(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getListenerKey(Object object) {
        Object object2 = this.mMapLock;
        synchronized (object2) {
            int n = this.mListenerMap.indexOfValue(object);
            if (n == -1) return 0;
            return this.mListenerMap.keyAt(n);
        }
    }

    private Messenger getMessenger() {
        try {
            Messenger messenger = this.mService.getMessenger();
            return messenger;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NsdServiceInfo getNsdService(int n) {
        Object object = this.mMapLock;
        synchronized (object) {
            return this.mServiceMap.get(n);
        }
    }

    private String getNsdServiceInfoType(NsdServiceInfo nsdServiceInfo) {
        if (nsdServiceInfo == null) {
            return "?";
        }
        return nsdServiceInfo.getServiceType();
    }

    private void init() {
        Messenger messenger = this.getMessenger();
        if (messenger == null) {
            throw new RuntimeException("Failed to initialize");
        }
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        this.mHandler = new ServiceHandler(handlerThread.getLooper());
        this.mAsyncChannel.connect(this.mContext, (Handler)this.mHandler, messenger);
        try {
            this.mConnected.await();
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e(TAG, "interrupted wait at init");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int putListener(Object object, NsdServiceInfo nsdServiceInfo) {
        if (object == null) {
            return 0;
        }
        Object object2 = this.mMapLock;
        synchronized (object2) {
            int n;
            if (this.mListenerMap.indexOfValue(object) != -1) {
                return -1;
            }
            do {
                n = this.mListenerKey;
                this.mListenerKey = n + 1;
            } while (n == 0);
            this.mListenerMap.put(n, object);
            this.mServiceMap.put(n, nsdServiceInfo);
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeListener(int n) {
        if (n == 0) {
            return;
        }
        Object object = this.mMapLock;
        synchronized (object) {
            this.mListenerMap.remove(n);
            this.mServiceMap.remove(n);
            return;
        }
    }

    public void discoverServices(String string2, int n, DiscoveryListener discoveryListener) {
        if (discoveryListener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException("Service type cannot be empty");
        }
        if (n != 1) {
            throw new IllegalArgumentException("Unsupported protocol");
        }
        NsdServiceInfo nsdServiceInfo = new NsdServiceInfo();
        nsdServiceInfo.setServiceType(string2);
        int n2 = this.putListener(discoveryListener, nsdServiceInfo);
        if (n2 == -1) {
            throw new IllegalArgumentException("listener already in use");
        }
        this.mAsyncChannel.sendMessage(393217, 0, n2, nsdServiceInfo);
    }

    public void registerService(NsdServiceInfo nsdServiceInfo, int n, RegistrationListener registrationListener) {
        if (TextUtils.isEmpty(nsdServiceInfo.getServiceName()) || TextUtils.isEmpty(nsdServiceInfo.getServiceType())) {
            throw new IllegalArgumentException("Service name or type cannot be empty");
        }
        if (nsdServiceInfo.getPort() <= 0) {
            throw new IllegalArgumentException("Invalid port number");
        }
        if (registrationListener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (n != 1) {
            throw new IllegalArgumentException("Unsupported protocol");
        }
        int n2 = this.putListener(registrationListener, nsdServiceInfo);
        if (n2 == -1) {
            throw new IllegalArgumentException("listener already in use");
        }
        this.mAsyncChannel.sendMessage(393225, 0, n2, nsdServiceInfo);
    }

    public void resolveService(NsdServiceInfo nsdServiceInfo, ResolveListener resolveListener) {
        if (TextUtils.isEmpty(nsdServiceInfo.getServiceName()) || TextUtils.isEmpty(nsdServiceInfo.getServiceType())) {
            throw new IllegalArgumentException("Service name or type cannot be empty");
        }
        if (resolveListener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        int n = this.putListener(resolveListener, nsdServiceInfo);
        if (n == -1) {
            throw new IllegalArgumentException("listener already in use");
        }
        this.mAsyncChannel.sendMessage(393234, 0, n, nsdServiceInfo);
    }

    public void setEnabled(boolean bl) {
        try {
            this.mService.setEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void stopServiceDiscovery(DiscoveryListener discoveryListener) {
        int n = this.getListenerKey(discoveryListener);
        if (n == 0) {
            throw new IllegalArgumentException("service discovery not active on listener");
        }
        if (discoveryListener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.mAsyncChannel.sendMessage(393222, 0, n);
    }

    public void unregisterService(RegistrationListener registrationListener) {
        int n = this.getListenerKey(registrationListener);
        if (n == 0) {
            throw new IllegalArgumentException("listener not registered");
        }
        if (registrationListener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.mAsyncChannel.sendMessage(393228, 0, n);
    }

    public static interface DiscoveryListener {
        public void onDiscoveryStarted(String var1);

        public void onDiscoveryStopped(String var1);

        public void onServiceFound(NsdServiceInfo var1);

        public void onServiceLost(NsdServiceInfo var1);

        public void onStartDiscoveryFailed(String var1, int var2);

        public void onStopDiscoveryFailed(String var1, int var2);
    }

    public static interface RegistrationListener {
        public void onRegistrationFailed(NsdServiceInfo var1, int var2);

        public void onServiceRegistered(NsdServiceInfo var1);

        public void onServiceUnregistered(NsdServiceInfo var1);

        public void onUnregistrationFailed(NsdServiceInfo var1, int var2);
    }

    public static interface ResolveListener {
        public void onResolveFailed(NsdServiceInfo var1, int var2);

        public void onServiceResolved(NsdServiceInfo var1);
    }

    private class ServiceHandler
    extends Handler {
        ServiceHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            Object object;
            switch (message.what) {
                default: {
                    object = NsdManager.this.getListener(message.arg2);
                    if (object != null) break;
                    Log.d(NsdManager.TAG, "Stale key " + message.arg2);
                    return;
                }
                case 69632: {
                    NsdManager.this.mAsyncChannel.sendMessage(69633);
                    return;
                }
                case 69634: {
                    NsdManager.this.mConnected.countDown();
                    return;
                }
                case 69636: {
                    Log.e(NsdManager.TAG, "Channel lost");
                    return;
                }
            }
            NsdServiceInfo nsdServiceInfo = NsdManager.this.getNsdService(message.arg2);
            switch (message.what) {
                default: {
                    Log.d(NsdManager.TAG, "Ignored " + message);
                    return;
                }
                case 393218: {
                    String string2 = NsdManager.this.getNsdServiceInfoType((NsdServiceInfo)message.obj);
                    ((DiscoveryListener)object).onDiscoveryStarted(string2);
                    return;
                }
                case 393219: {
                    NsdManager.this.removeListener(message.arg2);
                    ((DiscoveryListener)object).onStartDiscoveryFailed(NsdManager.this.getNsdServiceInfoType(nsdServiceInfo), message.arg1);
                    return;
                }
                case 393220: {
                    ((DiscoveryListener)object).onServiceFound((NsdServiceInfo)message.obj);
                    return;
                }
                case 393221: {
                    ((DiscoveryListener)object).onServiceLost((NsdServiceInfo)message.obj);
                    return;
                }
                case 393223: {
                    NsdManager.this.removeListener(message.arg2);
                    ((DiscoveryListener)object).onStopDiscoveryFailed(NsdManager.this.getNsdServiceInfoType(nsdServiceInfo), message.arg1);
                    return;
                }
                case 393224: {
                    NsdManager.this.removeListener(message.arg2);
                    ((DiscoveryListener)object).onDiscoveryStopped(NsdManager.this.getNsdServiceInfoType(nsdServiceInfo));
                    return;
                }
                case 393226: {
                    NsdManager.this.removeListener(message.arg2);
                    ((RegistrationListener)object).onRegistrationFailed(nsdServiceInfo, message.arg1);
                    return;
                }
                case 393227: {
                    ((RegistrationListener)object).onServiceRegistered((NsdServiceInfo)message.obj);
                    return;
                }
                case 393229: {
                    NsdManager.this.removeListener(message.arg2);
                    ((RegistrationListener)object).onUnregistrationFailed(nsdServiceInfo, message.arg1);
                    return;
                }
                case 393230: {
                    NsdManager.this.removeListener(message.arg2);
                    ((RegistrationListener)object).onServiceUnregistered(nsdServiceInfo);
                    return;
                }
                case 393235: {
                    NsdManager.this.removeListener(message.arg2);
                    ((ResolveListener)object).onResolveFailed(nsdServiceInfo, message.arg1);
                    return;
                }
                case 393236: 
            }
            NsdManager.this.removeListener(message.arg2);
            ((ResolveListener)object).onServiceResolved((NsdServiceInfo)message.obj);
        }
    }
}

