/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.ResponseCache;
import java.net.URI;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;

public final class HttpResponseCache
extends ResponseCache
implements Closeable {
    private final com.android.okhttp.HttpResponseCache delegate;

    private HttpResponseCache(com.android.okhttp.HttpResponseCache httpResponseCache) {
        this.delegate = httpResponseCache;
    }

    public static HttpResponseCache getInstalled() {
        ResponseCache responseCache = ResponseCache.getDefault();
        if (responseCache instanceof com.android.okhttp.HttpResponseCache) {
            return new HttpResponseCache((com.android.okhttp.HttpResponseCache)responseCache);
        }
        return null;
    }

    public static HttpResponseCache install(File file, long l) throws IOException {
        ResponseCache responseCache = ResponseCache.getDefault();
        if (responseCache instanceof com.android.okhttp.HttpResponseCache) {
            com.android.okhttp.HttpResponseCache httpResponseCache = (com.android.okhttp.HttpResponseCache)responseCache;
            if (httpResponseCache.getDirectory().equals(file) && httpResponseCache.getMaxSize() == l && !httpResponseCache.isClosed()) {
                return new HttpResponseCache(httpResponseCache);
            }
            httpResponseCache.close();
        }
        com.android.okhttp.HttpResponseCache httpResponseCache = new com.android.okhttp.HttpResponseCache(file, l);
        ResponseCache.setDefault((ResponseCache)httpResponseCache);
        return new HttpResponseCache(httpResponseCache);
    }

    @Override
    public void close() throws IOException {
        if (ResponseCache.getDefault() == this.delegate) {
            ResponseCache.setDefault(null);
        }
        this.delegate.close();
    }

    public void delete() throws IOException {
        if (ResponseCache.getDefault() == this.delegate) {
            ResponseCache.setDefault(null);
        }
        this.delegate.delete();
    }

    public void flush() {
        try {
            this.delegate.flush();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    @Override
    public CacheResponse get(URI uRI, String string2, Map<String, List<String>> map) throws IOException {
        return this.delegate.get(uRI, string2, map);
    }

    public int getHitCount() {
        return this.delegate.getHitCount();
    }

    public int getNetworkCount() {
        return this.delegate.getNetworkCount();
    }

    public int getRequestCount() {
        return this.delegate.getRequestCount();
    }

    public long maxSize() {
        return this.delegate.getMaxSize();
    }

    @Override
    public CacheRequest put(URI uRI, URLConnection uRLConnection) throws IOException {
        return this.delegate.put(uRI, uRLConnection);
    }

    public long size() {
        return this.delegate.getSize();
    }
}

