/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.Headers;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.http.HttpConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.HttpConnectionMetricsImpl;
import org.apache.http.impl.entity.EntitySerializer;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.io.ChunkedInputStream;
import org.apache.http.impl.io.ContentLengthInputStream;
import org.apache.http.impl.io.HttpRequestWriter;
import org.apache.http.impl.io.IdentityInputStream;
import org.apache.http.impl.io.SocketInputBuffer;
import org.apache.http.impl.io.SocketOutputBuffer;
import org.apache.http.io.HttpMessageWriter;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.CharArrayBuffer;

public class AndroidHttpClientConnection
implements HttpInetConnection,
HttpConnection {
    private final EntitySerializer entityserializer = new EntitySerializer(new StrictContentLengthStrategy());
    private SessionInputBuffer inbuffer = null;
    private int maxHeaderCount;
    private int maxLineLength;
    private HttpConnectionMetricsImpl metrics = null;
    private volatile boolean open;
    private SessionOutputBuffer outbuffer = null;
    private HttpMessageWriter requestWriter = null;
    private Socket socket = null;

    private void assertNotOpen() {
        if (this.open) {
            throw new IllegalStateException("Connection is already open");
        }
    }

    private void assertOpen() {
        if (!this.open) {
            throw new IllegalStateException("Connection is not open");
        }
    }

    private long determineLength(Headers headers) {
        long l = headers.getTransferEncoding();
        if (l < 0L) {
            return l;
        }
        long l2 = headers.getContentLength();
        if (l2 > -1L) {
            return l2;
        }
        return -1L;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void bind(Socket socket, HttpParams httpParams) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.assertNotOpen();
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(httpParams));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout(httpParams));
        int n = HttpConnectionParams.getLinger(httpParams);
        if (n >= 0) {
            boolean bl = n > 0;
            socket.setSoLinger(bl, n);
        }
        this.socket = socket;
        int n2 = HttpConnectionParams.getSocketBufferSize(httpParams);
        this.inbuffer = new SocketInputBuffer(socket, n2, httpParams);
        this.outbuffer = new SocketOutputBuffer(socket, n2, httpParams);
        this.maxHeaderCount = httpParams.getIntParameter("http.connection.max-header-count", -1);
        this.maxLineLength = httpParams.getIntParameter("http.connection.max-line-length", -1);
        this.requestWriter = new HttpRequestWriter(this.outbuffer, null, httpParams);
        this.metrics = new HttpConnectionMetricsImpl(this.inbuffer.getMetrics(), this.outbuffer.getMetrics());
        this.open = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.doFlush();
        try {
            try {
                this.socket.shutdownOutput();
            }
            catch (IOException iOException) {}
            try {
                this.socket.shutdownInput();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        this.socket.close();
    }

    protected void doFlush() throws IOException {
        this.outbuffer.flush();
    }

    public void flush() throws IOException {
        this.assertOpen();
        this.doFlush();
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.socket != null) {
            return this.socket.getLocalAddress();
        }
        return null;
    }

    @Override
    public int getLocalPort() {
        if (this.socket != null) {
            return this.socket.getLocalPort();
        }
        return -1;
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public InetAddress getRemoteAddress() {
        if (this.socket != null) {
            return this.socket.getInetAddress();
        }
        return null;
    }

    @Override
    public int getRemotePort() {
        if (this.socket != null) {
            return this.socket.getPort();
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getSocketTimeout() {
        int n = -1;
        if (this.socket == null) return n;
        try {
            int n2 = this.socket.getSoTimeout();
            return n2;
        }
        catch (SocketException socketException) {
            return n;
        }
    }

    @Override
    public boolean isOpen() {
        return this.open && this.socket != null && this.socket.isConnected();
    }

    @Override
    public boolean isStale() {
        this.assertOpen();
        try {
            this.inbuffer.isDataAvailable(1);
            return false;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public StatusLine parseResponseHeader(Headers headers) throws IOException, ParseException {
        this.assertOpen();
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(64);
        if (this.inbuffer.readLine(charArrayBuffer) == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        StatusLine statusLine = BasicLineParser.DEFAULT.parseStatusLine(charArrayBuffer, new ParserCursor(0, charArrayBuffer.length()));
        int n = statusLine.getStatusCode();
        CharArrayBuffer charArrayBuffer2 = null;
        int n2 = 0;
        do {
            if (charArrayBuffer == null) {
                charArrayBuffer = new CharArrayBuffer(64);
            } else {
                charArrayBuffer.clear();
            }
            if (this.inbuffer.readLine(charArrayBuffer) == -1 || charArrayBuffer.length() < 1) {
                if (charArrayBuffer2 != null) {
                    headers.parseHeader(charArrayBuffer2);
                }
                if (n >= 200) {
                    this.metrics.incrementResponseCount();
                }
                return statusLine;
            }
            char c = charArrayBuffer.charAt(0);
            if (c != ' ' && c != '\t' || charArrayBuffer2 == null) {
                if (charArrayBuffer2 != null) {
                    headers.parseHeader(charArrayBuffer2);
                }
                ++n2;
                charArrayBuffer2 = charArrayBuffer;
                charArrayBuffer = null;
                continue;
            }
            int n3 = 0;
            int n4 = charArrayBuffer.length();
            while (true) {
                char c2;
                if (n3 >= n4 || (c2 = charArrayBuffer.charAt(n3)) != ' ' && c2 != '\t') {
                    if (this.maxLineLength <= 0 || 1 + charArrayBuffer2.length() + charArrayBuffer.length() - n3 <= this.maxLineLength) break;
                    throw new IOException("Maximum line length limit exceeded");
                }
                ++n3;
            }
            charArrayBuffer2.append(' ');
            charArrayBuffer2.append(charArrayBuffer, n3, charArrayBuffer.length() - n3);
        } while (this.maxHeaderCount <= 0 || n2 < this.maxHeaderCount);
        throw new IOException("Maximum header count exceeded");
    }

    /*
     * Enabled aggressive block sorting
     */
    public HttpEntity receiveResponseEntity(Headers headers) {
        String string2;
        String string3;
        this.assertOpen();
        BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
        long l = this.determineLength(headers);
        if (l == -2L) {
            basicHttpEntity.setChunked(true);
            basicHttpEntity.setContentLength(-1L);
            basicHttpEntity.setContent(new ChunkedInputStream(this.inbuffer));
        } else if (l == -1L) {
            basicHttpEntity.setChunked(false);
            basicHttpEntity.setContentLength(-1L);
            basicHttpEntity.setContent(new IdentityInputStream(this.inbuffer));
        } else {
            basicHttpEntity.setChunked(false);
            basicHttpEntity.setContentLength(l);
            basicHttpEntity.setContent(new ContentLengthInputStream(this.inbuffer, l));
        }
        if ((string3 = headers.getContentType()) != null) {
            basicHttpEntity.setContentType(string3);
        }
        if ((string2 = headers.getContentEncoding()) != null) {
            basicHttpEntity.setContentEncoding(string2);
        }
        return basicHttpEntity;
    }

    public void sendRequestEntity(HttpEntityEnclosingRequest httpEntityEnclosingRequest) throws HttpException, IOException {
        if (httpEntityEnclosingRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        if (httpEntityEnclosingRequest.getEntity() == null) {
            return;
        }
        this.entityserializer.serialize(this.outbuffer, httpEntityEnclosingRequest, httpEntityEnclosingRequest.getEntity());
    }

    public void sendRequestHeader(HttpRequest httpRequest) throws HttpException, IOException {
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        this.requestWriter.write(httpRequest);
        this.metrics.incrementRequestCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setSocketTimeout(int n) {
        this.assertOpen();
        if (this.socket == null) return;
        try {
            this.socket.setSoTimeout(n);
            return;
        }
        catch (SocketException socketException) {
            return;
        }
    }

    @Override
    public void shutdown() throws IOException {
        this.open = false;
        Socket socket = this.socket;
        if (socket != null) {
            socket.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName()).append("[");
        if (this.isOpen()) {
            stringBuilder.append(this.getRemotePort());
        } else {
            stringBuilder.append("closed");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

