/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.app.ActivityThread;
import android.content.ContentResolver;
import android.content.Context;
import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import android.os.Binder;
import android.os.Build;
import android.os.Looper;
import android.util.Base64;
import android.util.Log;
import com.android.internal.http.HttpDateTime;
import com.asus.cta.CtaChecker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;

public final class AndroidHttpClient
implements HttpClient {
    public static long DEFAULT_SYNC_MIN_GZIP_BYTES = 0L;
    private static final int SOCKET_OPERATION_TIMEOUT = 60000;
    private static final String TAG = "AndroidHttpClient";
    private static final HttpRequestInterceptor sThreadCheckInterceptor;
    private static String[] textContentTypes;
    private volatile LoggingConfiguration curlConfiguration;
    private final HttpClient delegate;
    private RuntimeException mLeakedException = new IllegalStateException("AndroidHttpClient created and never closed");

    static {
        DEFAULT_SYNC_MIN_GZIP_BYTES = 256L;
        textContentTypes = new String[]{"text/", "application/xml", "application/json"};
        sThreadCheckInterceptor = new HttpRequestInterceptor(){

            @Override
            public void process(HttpRequest httpRequest, HttpContext httpContext) {
                if (Looper.myLooper() != null && Looper.myLooper() == Looper.getMainLooper()) {
                    throw new RuntimeException("This thread forbids HTTP requests");
                }
            }
        };
    }

    private AndroidHttpClient(ClientConnectionManager clientConnectionManager, HttpParams httpParams) {
        this.delegate = new DefaultHttpClient(clientConnectionManager, httpParams){

            @Override
            protected HttpContext createHttpContext() {
                BasicHttpContext basicHttpContext = new BasicHttpContext();
                basicHttpContext.setAttribute("http.authscheme-registry", this.getAuthSchemes());
                basicHttpContext.setAttribute("http.cookiespec-registry", this.getCookieSpecs());
                basicHttpContext.setAttribute("http.auth.credentials-provider", this.getCredentialsProvider());
                return basicHttpContext;
            }

            @Override
            protected BasicHttpProcessor createHttpProcessor() {
                BasicHttpProcessor basicHttpProcessor = super.createHttpProcessor();
                basicHttpProcessor.addRequestInterceptor(sThreadCheckInterceptor);
                basicHttpProcessor.addRequestInterceptor(new CurlLogger());
                return basicHttpProcessor;
            }
        };
    }

    public static AbstractHttpEntity getCompressedEntity(byte[] byArray, ContentResolver contentResolver) throws IOException {
        if ((long)byArray.length < AndroidHttpClient.getMinGzipSize(contentResolver)) {
            return new ByteArrayEntity(byArray);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        ((OutputStream)gZIPOutputStream).close();
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(byteArrayOutputStream.toByteArray());
        byteArrayEntity.setContentEncoding("gzip");
        return byteArrayEntity;
    }

    public static long getMinGzipSize(ContentResolver contentResolver) {
        return DEFAULT_SYNC_MIN_GZIP_BYTES;
    }

    public static InputStream getUngzippedContent(HttpEntity httpEntity) throws IOException {
        InputStream inputStream = httpEntity.getContent();
        if (inputStream == null) {
            return inputStream;
        }
        Header header = httpEntity.getContentEncoding();
        if (header == null) {
            return inputStream;
        }
        String string2 = header.getValue();
        if (string2 == null) {
            return inputStream;
        }
        if (string2.contains("gzip")) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isBinaryContent(HttpUriRequest httpUriRequest) {
        Header[] headerArray;
        Header[] headerArray2 = httpUriRequest.getHeaders("content-encoding");
        if (headerArray2 != null) {
            int n = headerArray2.length;
            for (int i = 0; i < n; ++i) {
                if ("gzip".equalsIgnoreCase(headerArray2[i].getValue())) return true;
            }
        }
        if ((headerArray = httpUriRequest.getHeaders("content-type")) == null) return true;
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            for (String string2 : textContentTypes) {
                if (!header.getValue().startsWith(string2)) continue;
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void modifyRequestToAcceptGzipResponse(HttpRequest httpRequest) {
        httpRequest.addHeader("Accept-Encoding", "gzip");
    }

    public static AndroidHttpClient newInstance(String string2) {
        return AndroidHttpClient.newInstance(string2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static AndroidHttpClient newInstance(String string2, Context context) {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled(basicHttpParams, false);
        HttpConnectionParams.setConnectionTimeout(basicHttpParams, 60000);
        HttpConnectionParams.setSoTimeout(basicHttpParams, 60000);
        HttpConnectionParams.setSocketBufferSize(basicHttpParams, 8192);
        HttpClientParams.setRedirecting(basicHttpParams, false);
        SSLSessionCache sSLSessionCache = context == null ? null : new SSLSessionCache(context);
        HttpProtocolParams.setUserAgent(basicHttpParams, string2);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", SSLCertificateSocketFactory.getHttpSocketFactory(60000, sSLSessionCache), 443));
        return new AndroidHttpClient(new ThreadSafeClientConnManager(basicHttpParams, schemeRegistry), basicHttpParams);
    }

    public static long parseDate(String string2) {
        return HttpDateTime.parse(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String toCurl(HttpUriRequest httpUriRequest, boolean bl) throws IOException {
        HttpRequest httpRequest;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("curl ");
        stringBuilder.append("-X ");
        stringBuilder.append(httpUriRequest.getMethod());
        stringBuilder.append(" ");
        for (Header header : httpUriRequest.getAllHeaders()) {
            if (!bl && (header.getName().equals("Authorization") || header.getName().equals("Cookie"))) continue;
            stringBuilder.append("--header \"");
            stringBuilder.append(header.toString().trim());
            stringBuilder.append("\" ");
        }
        URI uRI = httpUriRequest.getURI();
        if (httpUriRequest instanceof RequestWrapper && (httpRequest = ((RequestWrapper)httpUriRequest).getOriginal()) instanceof HttpUriRequest) {
            uRI = ((HttpUriRequest)httpRequest).getURI();
        }
        stringBuilder.append("\"");
        stringBuilder.append(uRI);
        stringBuilder.append("\"");
        if (!(httpUriRequest instanceof HttpEntityEnclosingRequest)) return stringBuilder.toString();
        HttpEntity httpEntity = ((HttpEntityEnclosingRequest)((Object)httpUriRequest)).getEntity();
        if (httpEntity == null) return stringBuilder.toString();
        if (!httpEntity.isRepeatable()) return stringBuilder.toString();
        if (httpEntity.getContentLength() >= 1024L) {
            stringBuilder.append(" [TOO MUCH DATA TO INCLUDE]");
            return stringBuilder.toString();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        httpEntity.writeTo(byteArrayOutputStream);
        if (AndroidHttpClient.isBinaryContent(httpUriRequest)) {
            String string2 = Base64.encodeToString(byteArrayOutputStream.toByteArray(), 2);
            stringBuilder.insert(0, "echo '" + string2 + "' | base64 -d > /tmp/$$.bin; ");
            stringBuilder.append(" --data-binary @/tmp/$$.bin");
            return stringBuilder.toString();
        }
        String string3 = byteArrayOutputStream.toString();
        stringBuilder.append(" --data-ascii \"").append(string3).append("\"");
        return stringBuilder.toString();
    }

    public void close() {
        if (this.mLeakedException != null) {
            this.getConnectionManager().shutdown();
            this.mLeakedException = null;
        }
    }

    public void disableCurlLogging() {
        this.curlConfiguration = null;
    }

    public void enableCurlLogging(String string2, int n) {
        if (string2 == null) {
            throw new NullPointerException("name");
        }
        if (n < 2 || n > 7) {
            throw new IllegalArgumentException("Level is out of range [2..7]");
        }
        this.curlConfiguration = new LoggingConfiguration(string2, n);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.delegate.execute(httpHost, httpRequest, responseHandler);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        return this.delegate.execute(httpHost, httpRequest, responseHandler, httpContext);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.delegate.execute(httpUriRequest, responseHandler);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        return this.delegate.execute(httpUriRequest, responseHandler, httpContext);
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest) throws IOException {
        if (Build.CTA && Binder.getCallingPid() != 1000 && httpRequest instanceof HttpEntityEnclosingRequest && ((HttpEntityEnclosingRequest)httpRequest).getEntity().getContentType().toString().contains("application/vnd.wap.mms-message")) {
            boolean bl = new CtaChecker(ActivityThread.currentApplication()).checkPermission(1, ActivityThread.currentPackageName());
            Log.d(TAG, "execute cta checker result=" + bl);
            if (!bl) {
                httpHost = null;
                httpRequest = null;
            }
        }
        return this.delegate.execute(httpHost, httpRequest);
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException {
        return this.delegate.execute(httpHost, httpRequest, httpContext);
    }

    @Override
    public HttpResponse execute(HttpUriRequest httpUriRequest) throws IOException {
        return this.delegate.execute(httpUriRequest);
    }

    @Override
    public HttpResponse execute(HttpUriRequest httpUriRequest, HttpContext httpContext) throws IOException {
        return this.delegate.execute(httpUriRequest, httpContext);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mLeakedException != null) {
            Log.e(TAG, "Leak found", this.mLeakedException);
            this.mLeakedException = null;
        }
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return this.delegate.getConnectionManager();
    }

    @Override
    public HttpParams getParams() {
        return this.delegate.getParams();
    }

    private class CurlLogger
    implements HttpRequestInterceptor {
        private CurlLogger() {
        }

        @Override
        public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
            LoggingConfiguration loggingConfiguration = AndroidHttpClient.this.curlConfiguration;
            if (loggingConfiguration != null && loggingConfiguration.isLoggable() && httpRequest instanceof HttpUriRequest) {
                loggingConfiguration.println(AndroidHttpClient.toCurl((HttpUriRequest)httpRequest, false));
            }
        }
    }

    private static class LoggingConfiguration {
        private final int level;
        private final String tag;

        private LoggingConfiguration(String string2, int n) {
            this.tag = string2;
            this.level = n;
        }

        private boolean isLoggable() {
            return Log.isLoggable(this.tag, this.level);
        }

        private void println(String string2) {
            Log.println(this.level, this.tag, string2);
        }
    }
}

