/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import android.net.dhcp.DhcpStateMachine;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;

class DhcpOfferPacket
extends DhcpPacket {
    private final InetAddress mSrcIp;

    DhcpOfferPacket(int n, boolean bl, InetAddress inetAddress, InetAddress inetAddress2, byte[] byArray) {
        super(n, Inet4Address.ANY, inetAddress2, Inet4Address.ANY, Inet4Address.ANY, byArray, bl);
        this.mSrcIp = inetAddress;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ByteBuffer buildPacket(int n, short s, short s2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1500);
        InetAddress inetAddress = this.mBroadcast ? Inet4Address.ALL : this.mYourIp;
        InetAddress inetAddress2 = this.mBroadcast ? Inet4Address.ANY : this.mSrcIp;
        this.fillInPacket(n, inetAddress, inetAddress2, s, s2, byteBuffer, (byte)2, this.mBroadcast);
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public void doNextOp(DhcpStateMachine dhcpStateMachine) {
        dhcpStateMachine.onOfferReceived(this.mBroadcast, this.mTransId, this.mClientMac, this.mYourIp, this.mServerIdentifier);
    }

    @Override
    void finishPacket(ByteBuffer byteBuffer) {
        this.addTlv(byteBuffer, (byte)53, (byte)2);
        this.addTlv(byteBuffer, (byte)54, this.mServerIdentifier);
        this.addTlv(byteBuffer, (byte)51, this.mLeaseTime);
        if (this.mLeaseTime != null) {
            this.addTlv(byteBuffer, (byte)58, this.mLeaseTime / 2);
        }
        this.addTlv(byteBuffer, (byte)1, this.mSubnetMask);
        this.addTlv(byteBuffer, (byte)3, this.mGateway);
        this.addTlv(byteBuffer, (byte)15, this.mDomainName);
        this.addTlv(byteBuffer, (byte)28, this.mBroadcastAddress);
        this.addTlv(byteBuffer, (byte)6, this.mDnsServers);
        this.addTlvEnd(byteBuffer);
    }

    @Override
    public String toString() {
        String string2 = super.toString();
        String string3 = ", DNS servers: ";
        if (this.mDnsServers != null) {
            for (InetAddress inetAddress : this.mDnsServers) {
                string3 = string3 + inetAddress + " ";
            }
        }
        return string2 + " OFFER, ip " + this.mYourIp + ", mask " + this.mSubnetMask + string3 + ", gateway " + this.mGateway + " lease time " + this.mLeaseTime + ", domain " + this.mDomainName;
    }
}

