/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import android.net.dhcp.DhcpStateMachine;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;

class DhcpNakPacket
extends DhcpPacket {
    DhcpNakPacket(int n, InetAddress inetAddress, InetAddress inetAddress2, InetAddress inetAddress3, InetAddress inetAddress4, byte[] byArray) {
        super(n, Inet4Address.ANY, Inet4Address.ANY, inetAddress3, inetAddress4, byArray, false);
    }

    @Override
    public ByteBuffer buildPacket(int n, short s, short s2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1500);
        this.fillInPacket(n, this.mClientIp, this.mYourIp, s, s2, byteBuffer, (byte)2, this.mBroadcast);
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public void doNextOp(DhcpStateMachine dhcpStateMachine) {
        dhcpStateMachine.onNakReceived();
    }

    @Override
    void finishPacket(ByteBuffer byteBuffer) {
        this.addTlv(byteBuffer, (byte)53, (byte)6);
        this.addTlv(byteBuffer, (byte)54, this.mServerIdentifier);
        this.addTlv(byteBuffer, (byte)56, this.mMessage);
        this.addTlvEnd(byteBuffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String toString() {
        String string2;
        String string3 = super.toString();
        StringBuilder stringBuilder = new StringBuilder().append(string3).append(" NAK, reason ");
        if (this.mMessage == null) {
            string2 = "(none)";
            return stringBuilder.append(string2).toString();
        }
        string2 = this.mMessage;
        return stringBuilder.append(string2).toString();
    }
}

