/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;
import java.util.regex.Pattern;

public class WifiKey
implements Parcelable {
    private static final Pattern BSSID_PATTERN;
    public static final Parcelable.Creator<WifiKey> CREATOR;
    private static final Pattern SSID_PATTERN;
    public final String bssid;
    public final String ssid;

    static {
        SSID_PATTERN = Pattern.compile("(\".*\")|(0x[\\p{XDigit}]+)");
        BSSID_PATTERN = Pattern.compile("([\\p{XDigit}]{2}:){5}[\\p{XDigit}]{2}");
        CREATOR = new Parcelable.Creator<WifiKey>(){

            @Override
            public WifiKey createFromParcel(Parcel parcel) {
                return new WifiKey(parcel);
            }

            public WifiKey[] newArray(int n) {
                return new WifiKey[n];
            }
        };
    }

    private WifiKey(Parcel parcel) {
        this.ssid = parcel.readString();
        this.bssid = parcel.readString();
    }

    public WifiKey(String string2, String string3) {
        if (!SSID_PATTERN.matcher(string2).matches()) {
            throw new IllegalArgumentException("Invalid ssid: " + string2);
        }
        if (!BSSID_PATTERN.matcher(string3).matches()) {
            throw new IllegalArgumentException("Invalid bssid: " + string3);
        }
        this.ssid = string2;
        this.bssid = string3;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                WifiKey wifiKey = (WifiKey)object;
                if (!Objects.equals(this.ssid, wifiKey.ssid) || !Objects.equals(this.bssid, wifiKey.bssid)) break block5;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.ssid, this.bssid};
        return Objects.hash(objectArray);
    }

    public String toString() {
        return "WifiKey[SSID=" + this.ssid + ",BSSID=" + this.bssid + "]";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.ssid);
        parcel.writeString(this.bssid);
    }
}

