/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.os.Parcel;
import android.os.Parcelable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public final class RouteInfo
implements Parcelable {
    public static final Parcelable.Creator<RouteInfo> CREATOR = new Parcelable.Creator<RouteInfo>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public RouteInfo createFromParcel(Parcel parcel) {
            InetAddress inetAddress;
            IpPrefix ipPrefix = (IpPrefix)parcel.readParcelable(null);
            byte[] byArray = parcel.createByteArray();
            try {
                InetAddress inetAddress2;
                inetAddress = inetAddress2 = InetAddress.getByAddress(byArray);
                return new RouteInfo(ipPrefix, inetAddress, parcel.readString(), parcel.readInt());
            }
            catch (UnknownHostException unknownHostException) {
                inetAddress = null;
                return new RouteInfo(ipPrefix, inetAddress, parcel.readString(), parcel.readInt());
            }
        }

        public RouteInfo[] newArray(int n) {
            return new RouteInfo[n];
        }
    };
    public static final int RTN_THROW = 9;
    public static final int RTN_UNICAST = 1;
    public static final int RTN_UNREACHABLE = 7;
    private final IpPrefix mDestination;
    private final InetAddress mGateway;
    private final boolean mHasGateway;
    private final String mInterface;
    private final boolean mIsHost;
    private final int mType;

    public RouteInfo(IpPrefix ipPrefix) {
        this(ipPrefix, null, null);
    }

    public RouteInfo(IpPrefix ipPrefix, int n) {
        this(ipPrefix, null, null, n);
    }

    public RouteInfo(IpPrefix ipPrefix, InetAddress inetAddress) {
        this(ipPrefix, inetAddress, null);
    }

    public RouteInfo(IpPrefix ipPrefix, InetAddress inetAddress, String string2) {
        this(ipPrefix, inetAddress, string2, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public RouteInfo(IpPrefix ipPrefix, InetAddress inetAddress, String string2, int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Unknown route type " + n);
            }
            case 1: 
            case 7: 
            case 9: 
        }
        if (ipPrefix == null) {
            if (inetAddress == null) {
                throw new IllegalArgumentException("Invalid arguments passed in: " + inetAddress + "," + ipPrefix);
            }
            ipPrefix = inetAddress instanceof Inet4Address ? new IpPrefix(Inet4Address.ANY, 0) : new IpPrefix(Inet6Address.ANY, 0);
        }
        if (inetAddress == null) {
            inetAddress = ipPrefix.getAddress() instanceof Inet4Address ? Inet4Address.ANY : Inet6Address.ANY;
        }
        boolean bl = inetAddress.isAnyLocalAddress();
        boolean bl2 = false;
        if (!bl) {
            bl2 = true;
        }
        this.mHasGateway = bl2;
        if (ipPrefix.getAddress() instanceof Inet4Address && !(inetAddress instanceof Inet4Address) || ipPrefix.getAddress() instanceof Inet6Address && !(inetAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException("address family mismatch in RouteInfo constructor");
        }
        this.mDestination = ipPrefix;
        this.mGateway = inetAddress;
        this.mInterface = string2;
        this.mType = n;
        this.mIsHost = this.isHost();
    }

    public RouteInfo(LinkAddress linkAddress) {
        this(linkAddress, null, null);
    }

    public RouteInfo(LinkAddress linkAddress, InetAddress inetAddress) {
        this(linkAddress, inetAddress, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public RouteInfo(LinkAddress linkAddress, InetAddress inetAddress, String string2) {
        IpPrefix ipPrefix = linkAddress == null ? null : new IpPrefix(linkAddress.getAddress(), linkAddress.getPrefixLength());
        this(ipPrefix, inetAddress, string2);
    }

    public RouteInfo(InetAddress inetAddress) {
        this((IpPrefix)null, inetAddress, null);
    }

    private boolean isHost() {
        return this.mDestination.getAddress() instanceof Inet4Address && this.mDestination.getPrefixLength() == 32 || this.mDestination.getAddress() instanceof Inet6Address && this.mDestination.getPrefixLength() == 128;
    }

    public static RouteInfo makeHostRoute(InetAddress inetAddress, String string2) {
        return RouteInfo.makeHostRoute(inetAddress, null, string2);
    }

    public static RouteInfo makeHostRoute(InetAddress inetAddress, InetAddress inetAddress2, String string2) {
        if (inetAddress == null) {
            return null;
        }
        if (inetAddress instanceof Inet4Address) {
            return new RouteInfo(new IpPrefix(inetAddress, 32), inetAddress2, string2);
        }
        return new RouteInfo(new IpPrefix(inetAddress, 128), inetAddress2, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RouteInfo selectBestRoute(Collection<RouteInfo> collection, InetAddress inetAddress) {
        if (collection == null) return null;
        if (inetAddress == null) {
            return null;
        }
        RouteInfo routeInfo = null;
        Iterator<RouteInfo> iterator = collection.iterator();
        while (iterator.hasNext()) {
            RouteInfo routeInfo2 = iterator.next();
            if (!NetworkUtils.addressTypeMatches(routeInfo2.mDestination.getAddress(), inetAddress) || routeInfo != null && routeInfo.mDestination.getPrefixLength() >= routeInfo2.mDestination.getPrefixLength() || !routeInfo2.matches(inetAddress)) continue;
            routeInfo = routeInfo2;
        }
        return routeInfo;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (!(object instanceof RouteInfo)) {
                    return false;
                }
                RouteInfo routeInfo = (RouteInfo)object;
                if (!Objects.equals(this.mDestination, routeInfo.getDestination()) || !Objects.equals(this.mGateway, routeInfo.getGateway()) || !Objects.equals(this.mInterface, routeInfo.getInterface()) || this.mType != routeInfo.getType()) break block5;
            }
            return true;
        }
        return false;
    }

    public IpPrefix getDestination() {
        return this.mDestination;
    }

    public LinkAddress getDestinationLinkAddress() {
        return new LinkAddress(this.mDestination.getAddress(), this.mDestination.getPrefixLength());
    }

    public InetAddress getGateway() {
        return this.mGateway;
    }

    public String getInterface() {
        return this.mInterface;
    }

    public int getType() {
        return this.mType;
    }

    public boolean hasGateway() {
        return this.mHasGateway;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n = 41 * this.mDestination.hashCode();
        int n2 = this.mGateway == null ? 0 : 47 * this.mGateway.hashCode();
        int n3 = n2 + n;
        String string2 = this.mInterface;
        int n4 = 0;
        if (string2 == null) {
            return n3 + n4 + 71 * this.mType;
        }
        n4 = 67 * this.mInterface.hashCode();
        return n3 + n4 + 71 * this.mType;
    }

    public boolean isDefaultRoute() {
        return this.mType == 1 && this.mDestination.getPrefixLength() == 0;
    }

    public boolean isHostRoute() {
        return this.mIsHost;
    }

    public boolean isIPv4Default() {
        return this.isDefaultRoute() && this.mDestination.getAddress() instanceof Inet4Address;
    }

    public boolean isIPv6Default() {
        return this.isDefaultRoute() && this.mDestination.getAddress() instanceof Inet6Address;
    }

    public boolean matches(InetAddress inetAddress) {
        if (inetAddress == null) {
            return false;
        }
        InetAddress inetAddress2 = NetworkUtils.getNetworkPart(inetAddress, this.mDestination.getPrefixLength());
        return this.mDestination.getAddress().equals(inetAddress2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        String string2 = "";
        if (this.mDestination != null) {
            string2 = this.mDestination.toString();
        }
        if (this.mType == 7) {
            return string2 + " unreachable";
        }
        if (this.mType == 9) {
            return string2 + " throw";
        }
        String string3 = string2 + " ->";
        if (this.mGateway != null) {
            string3 = string3 + " " + this.mGateway.getHostAddress();
        }
        if (this.mInterface != null) {
            string3 = string3 + " " + this.mInterface;
        }
        if (this.mType == 1) return string3;
        return string3 + " unknown type " + this.mType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable(this.mDestination, n);
        byte[] byArray = this.mGateway == null ? null : this.mGateway.getAddress();
        parcel.writeByteArray(byArray);
        parcel.writeString(this.mInterface);
        parcel.writeInt(this.mType);
    }
}

