/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.content.Intent;
import android.net.INetworkScoreCache;
import android.net.INetworkScoreService;
import android.net.NetworkKey;
import android.net.NetworkScorerAppManager;
import android.net.ScoredNetwork;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;

public class NetworkScoreManager {
    public static final String ACTION_CHANGE_ACTIVE = "android.net.scoring.CHANGE_ACTIVE";
    public static final String ACTION_CUSTOM_ENABLE = "android.net.scoring.CUSTOM_ENABLE";
    public static final String ACTION_SCORER_CHANGED = "android.net.scoring.SCORER_CHANGED";
    public static final String ACTION_SCORE_NETWORKS = "android.net.scoring.SCORE_NETWORKS";
    public static final String EXTRA_NETWORKS_TO_SCORE = "networksToScore";
    public static final String EXTRA_NEW_SCORER = "newScorer";
    public static final String EXTRA_PACKAGE_NAME = "packageName";
    private final Context mContext;
    private final INetworkScoreService mService;

    public NetworkScoreManager(Context context) {
        this.mContext = context;
        this.mService = INetworkScoreService.Stub.asInterface(ServiceManager.getService("network_score"));
    }

    public boolean clearScores() throws SecurityException {
        try {
            boolean bl = this.mService.clearScores();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void disableScoring() throws SecurityException {
        try {
            this.mService.disableScoring();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public String getActiveScorerPackage() {
        NetworkScorerAppManager.NetworkScorerAppData networkScorerAppData = NetworkScorerAppManager.getActiveScorer(this.mContext);
        if (networkScorerAppData == null) {
            return null;
        }
        return networkScorerAppData.mPackageName;
    }

    public void registerNetworkScoreCache(int n, INetworkScoreCache iNetworkScoreCache) {
        try {
            this.mService.registerNetworkScoreCache(n, iNetworkScoreCache);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean requestScores(NetworkKey[] networkKeyArray) throws SecurityException {
        String string2 = this.getActiveScorerPackage();
        if (string2 == null) {
            return false;
        }
        Intent intent = new Intent(ACTION_SCORE_NETWORKS);
        intent.setPackage(string2);
        intent.setFlags(0x4000000);
        intent.putExtra(EXTRA_NETWORKS_TO_SCORE, networkKeyArray);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.OWNER, "android.permission.SCORE_NETWORKS");
        return true;
    }

    public boolean setActiveScorer(String string2) throws SecurityException {
        try {
            boolean bl = this.mService.setActiveScorer(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean updateScores(ScoredNetwork[] scoredNetworkArray) throws SecurityException {
        try {
            boolean bl = this.mService.updateScores(scoredNetworkArray);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }
}

