/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.Credentials;
import android.net.LocalSocketAddress;
import android.net.LocalSocketImpl;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LocalSocket
implements Closeable {
    public static final int SOCKET_DGRAM = 1;
    public static final int SOCKET_SEQPACKET = 3;
    public static final int SOCKET_STREAM = 2;
    static final int SOCKET_UNKNOWN;
    private LocalSocketImpl impl;
    private volatile boolean implCreated;
    private boolean isBound;
    private boolean isConnected;
    private LocalSocketAddress localAddress;
    private final int sockType;

    public LocalSocket() {
        this(2);
    }

    public LocalSocket(int n) {
        this(new LocalSocketImpl(), n);
        this.isBound = false;
        this.isConnected = false;
    }

    LocalSocket(LocalSocketImpl localSocketImpl, int n) {
        this.impl = localSocketImpl;
        this.sockType = n;
        this.isConnected = false;
        this.isBound = false;
    }

    public LocalSocket(FileDescriptor fileDescriptor) throws IOException {
        this(new LocalSocketImpl(fileDescriptor), 0);
        this.isBound = true;
        this.isConnected = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void implCreateIfNeeded() throws IOException {
        if (this.implCreated) {
            return;
        }
        synchronized (this) {
            boolean bl = this.implCreated;
            if (!bl) {
                this.impl.create(this.sockType);
            }
            return;
            finally {
                this.implCreated = true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void bind(LocalSocketAddress localSocketAddress) throws IOException {
        this.implCreateIfNeeded();
        synchronized (this) {
            if (this.isBound) {
                throw new IOException("already bound");
            }
            this.localAddress = localSocketAddress;
            this.impl.bind(this.localAddress);
            this.isBound = true;
            return;
        }
    }

    @Override
    public void close() throws IOException {
        this.implCreateIfNeeded();
        this.impl.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(LocalSocketAddress localSocketAddress) throws IOException {
        synchronized (this) {
            if (this.isConnected) {
                throw new IOException("already connected");
            }
            this.implCreateIfNeeded();
            this.impl.connect(localSocketAddress, 0);
            this.isConnected = true;
            this.isBound = true;
            return;
        }
    }

    public void connect(LocalSocketAddress localSocketAddress, int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FileDescriptor[] getAncillaryFileDescriptors() throws IOException {
        return this.impl.getAncillaryFileDescriptors();
    }

    public FileDescriptor getFileDescriptor() {
        return this.impl.getFileDescriptor();
    }

    public InputStream getInputStream() throws IOException {
        this.implCreateIfNeeded();
        return this.impl.getInputStream();
    }

    public LocalSocketAddress getLocalSocketAddress() {
        return this.localAddress;
    }

    public OutputStream getOutputStream() throws IOException {
        this.implCreateIfNeeded();
        return this.impl.getOutputStream();
    }

    public Credentials getPeerCredentials() throws IOException {
        return this.impl.getPeerCredentials();
    }

    public int getReceiveBufferSize() throws IOException {
        return (Integer)this.impl.getOption(4098);
    }

    public LocalSocketAddress getRemoteSocketAddress() {
        throw new UnsupportedOperationException();
    }

    public int getSendBufferSize() throws IOException {
        return (Integer)this.impl.getOption(4097);
    }

    public int getSoTimeout() throws IOException {
        return (Integer)this.impl.getOption(4102);
    }

    public boolean isBound() {
        synchronized (this) {
            boolean bl = this.isBound;
            return bl;
        }
    }

    public boolean isClosed() {
        throw new UnsupportedOperationException();
    }

    public boolean isConnected() {
        synchronized (this) {
            boolean bl = this.isConnected;
            return bl;
        }
    }

    public boolean isInputShutdown() {
        throw new UnsupportedOperationException();
    }

    public boolean isOutputShutdown() {
        throw new UnsupportedOperationException();
    }

    public void setFileDescriptorsForSend(FileDescriptor[] fileDescriptorArray) {
        this.impl.setFileDescriptorsForSend(fileDescriptorArray);
    }

    public void setReceiveBufferSize(int n) throws IOException {
        this.impl.setOption(4098, n);
    }

    public void setSendBufferSize(int n) throws IOException {
        this.impl.setOption(4097, n);
    }

    public void setSoTimeout(int n) throws IOException {
        this.impl.setOption(4102, n);
    }

    public void shutdownInput() throws IOException {
        this.implCreateIfNeeded();
        this.impl.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.implCreateIfNeeded();
        this.impl.shutdownOutput();
    }

    public String toString() {
        return super.toString() + " impl:" + this.impl;
    }
}

