/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.system.OsConstants;
import android.util.Pair;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.UnknownHostException;

public class LinkAddress
implements Parcelable {
    public static final Parcelable.Creator<LinkAddress> CREATOR = new Parcelable.Creator<LinkAddress>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public LinkAddress createFromParcel(Parcel parcel) {
            InetAddress inetAddress;
            try {
                InetAddress inetAddress2;
                inetAddress = inetAddress2 = InetAddress.getByAddress(parcel.createByteArray());
                return new LinkAddress(inetAddress, parcel.readInt(), parcel.readInt(), parcel.readInt());
            }
            catch (UnknownHostException unknownHostException) {
                inetAddress = null;
                return new LinkAddress(inetAddress, parcel.readInt(), parcel.readInt(), parcel.readInt());
            }
        }

        public LinkAddress[] newArray(int n) {
            return new LinkAddress[n];
        }
    };
    private InetAddress address;
    private int flags;
    private int prefixLength;
    private int scope;

    public LinkAddress(String string2) {
        this(string2, 0, 0);
        this.scope = LinkAddress.scopeForUnicastAddress(this.address);
    }

    public LinkAddress(String string2, int n, int n2) {
        Pair<InetAddress, Integer> pair = NetworkUtils.parseIpAndMask(string2);
        this.init((InetAddress)pair.first, (Integer)pair.second, n, n2);
    }

    public LinkAddress(InetAddress inetAddress, int n) {
        this(inetAddress, n, 0, 0);
        this.scope = LinkAddress.scopeForUnicastAddress(inetAddress);
    }

    public LinkAddress(InetAddress inetAddress, int n, int n2, int n3) {
        this.init(inetAddress, n, n2, n3);
    }

    public LinkAddress(InterfaceAddress interfaceAddress) {
        this(interfaceAddress.getAddress(), interfaceAddress.getNetworkPrefixLength());
    }

    private void init(InetAddress inetAddress, int n, int n2, int n3) {
        if (inetAddress == null || inetAddress.isMulticastAddress() || n < 0 || inetAddress instanceof Inet4Address && n > 32 || n > 128) {
            throw new IllegalArgumentException("Bad LinkAddress params " + inetAddress + "/" + n);
        }
        this.address = inetAddress;
        this.prefixLength = n;
        this.flags = n2;
        this.scope = n3;
    }

    static int scopeForUnicastAddress(InetAddress inetAddress) {
        if (inetAddress.isAnyLocalAddress()) {
            return OsConstants.RT_SCOPE_HOST;
        }
        if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) {
            return OsConstants.RT_SCOPE_LINK;
        }
        if (!(inetAddress instanceof Inet4Address) && inetAddress.isSiteLocalAddress()) {
            return OsConstants.RT_SCOPE_SITE;
        }
        return OsConstants.RT_SCOPE_UNIVERSE;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof LinkAddress)) break block2;
                LinkAddress linkAddress = (LinkAddress)object;
                if (this.address.equals(linkAddress.address) && this.prefixLength == linkAddress.prefixLength && this.flags == linkAddress.flags && this.scope == linkAddress.scope) break block3;
            }
            return false;
        }
        return true;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getNetworkPrefixLength() {
        return this.getPrefixLength();
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public int getScope() {
        return this.scope;
    }

    public int hashCode() {
        return this.address.hashCode() + 11 * this.prefixLength + 19 * this.flags + 43 * this.scope;
    }

    public boolean isGlobalPreferred() {
        return this.scope == OsConstants.RT_SCOPE_UNIVERSE && (long)(this.flags & (OsConstants.IFA_F_DADFAILED | OsConstants.IFA_F_DEPRECATED | OsConstants.IFA_F_TENTATIVE)) == 0L;
    }

    public boolean isSameAddressAs(LinkAddress linkAddress) {
        return this.address.equals(linkAddress.address) && this.prefixLength == linkAddress.prefixLength;
    }

    public String toString() {
        return this.address.getHostAddress() + "/" + this.prefixLength;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeByteArray(this.address.getAddress());
        parcel.writeInt(this.prefixLength);
        parcel.writeInt(this.flags);
        parcel.writeInt(this.scope);
    }
}

