/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;

public class InterfaceConfiguration
implements Parcelable {
    public static final Parcelable.Creator<InterfaceConfiguration> CREATOR = new Parcelable.Creator<InterfaceConfiguration>(){

        @Override
        public InterfaceConfiguration createFromParcel(Parcel parcel) {
            InterfaceConfiguration interfaceConfiguration = new InterfaceConfiguration();
            InterfaceConfiguration.access$002(interfaceConfiguration, parcel.readString());
            if (parcel.readByte() == 1) {
                InterfaceConfiguration.access$102(interfaceConfiguration, (LinkAddress)parcel.readParcelable(null));
            }
            int n = parcel.readInt();
            for (int i = 0; i < n; ++i) {
                interfaceConfiguration.mFlags.add(parcel.readString());
            }
            return interfaceConfiguration;
        }

        public InterfaceConfiguration[] newArray(int n) {
            return new InterfaceConfiguration[n];
        }
    };
    private static final String FLAG_DOWN = "down";
    private static final String FLAG_UP = "up";
    private LinkAddress mAddr;
    private HashSet<String> mFlags = Sets.newHashSet();
    private String mHwAddr;

    static /* synthetic */ String access$002(InterfaceConfiguration interfaceConfiguration, String string2) {
        interfaceConfiguration.mHwAddr = string2;
        return string2;
    }

    static /* synthetic */ LinkAddress access$102(InterfaceConfiguration interfaceConfiguration, LinkAddress linkAddress) {
        interfaceConfiguration.mAddr = linkAddress;
        return linkAddress;
    }

    private static void validateFlag(String string2) {
        if (string2.indexOf(32) >= 0) {
            throw new IllegalArgumentException("flag contains space: " + string2);
        }
    }

    public void clearFlag(String string2) {
        InterfaceConfiguration.validateFlag(string2);
        this.mFlags.remove(string2);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public Iterable<String> getFlags() {
        return this.mFlags;
    }

    public String getHardwareAddress() {
        return this.mHwAddr;
    }

    public LinkAddress getLinkAddress() {
        return this.mAddr;
    }

    public boolean hasFlag(String string2) {
        InterfaceConfiguration.validateFlag(string2);
        return this.mFlags.contains(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isActive() {
        try {
            boolean bl = this.hasFlag(FLAG_UP);
            boolean bl2 = false;
            if (!bl) return bl2;
            byte[] byArray = this.mAddr.getAddress().getAddress();
            int n = byArray.length;
            int n2 = 0;
            while (true) {
                bl2 = false;
                if (n2 >= n) return bl2;
                byte by = byArray[n2];
                if (by != 0) {
                    return true;
                }
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public void setFlag(String string2) {
        InterfaceConfiguration.validateFlag(string2);
        this.mFlags.add(string2);
    }

    public void setHardwareAddress(String string2) {
        this.mHwAddr = string2;
    }

    public void setInterfaceDown() {
        this.mFlags.remove(FLAG_UP);
        this.mFlags.add(FLAG_DOWN);
    }

    public void setInterfaceUp() {
        this.mFlags.remove(FLAG_DOWN);
        this.mFlags.add(FLAG_UP);
    }

    public void setLinkAddress(LinkAddress linkAddress) {
        this.mAddr = linkAddress;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("mHwAddr=").append(this.mHwAddr);
        stringBuilder.append(" mAddr=").append(String.valueOf(this.mAddr));
        stringBuilder.append(" mFlags=").append(this.getFlags());
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mHwAddr);
        if (this.mAddr != null) {
            parcel.writeByte((byte)1);
            parcel.writeParcelable(this.mAddr, n);
        } else {
            parcel.writeByte((byte)0);
        }
        parcel.writeInt(this.mFlags.size());
        Iterator<String> iterator = this.mFlags.iterator();
        while (iterator.hasNext()) {
            parcel.writeString(iterator.next());
        }
        return;
    }
}

