/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Log;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public final class DnsPinger
extends Handler {
    private static final int ACTION_CANCEL_ALL_PINGS = 327683;
    private static final int ACTION_LISTEN_FOR_RESPONSE = 327682;
    private static final int ACTION_PING_DNS = 327681;
    private static final int BASE = 327680;
    private static final boolean DBG = false;
    public static final int DNS_PING_RESULT = 327680;
    private static final int DNS_PORT = 53;
    private static final int RECEIVE_POLL_INTERVAL_MS = 200;
    public static final int SOCKET_EXCEPTION = -2;
    private static final int SOCKET_TIMEOUT_MS = 1;
    public static final int TIMEOUT = -1;
    private static final byte[] mDnsQuery;
    private static final AtomicInteger sCounter;
    private static final Random sRandom;
    private String TAG;
    private List<ActivePing> mActivePings;
    private final int mConnectionType;
    private ConnectivityManager mConnectivityManager = null;
    private final Context mContext;
    private AtomicInteger mCurrentToken = new AtomicInteger();
    private final ArrayList<InetAddress> mDefaultDns;
    private int mEventCounter;
    private final Handler mTarget;

    static {
        sRandom = new Random();
        sCounter = new AtomicInteger();
        mDnsQuery = new byte[]{0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 3, 119, 119, 119, 6, 103, 111, 111, 103, 108, 101, 3, 99, 111, 109, 0, 0, 1, 0, 1};
    }

    public DnsPinger(Context context, String string2, Looper looper, Handler handler, int n) {
        super(looper);
        this.mActivePings = new ArrayList<ActivePing>();
        this.TAG = string2;
        this.mContext = context;
        this.mTarget = handler;
        this.mConnectionType = n;
        if (!ConnectivityManager.isNetworkTypeValid(n)) {
            throw new IllegalArgumentException("Invalid connectionType in constructor: " + n);
        }
        this.mDefaultDns = new ArrayList();
        this.mDefaultDns.add(this.getDefaultDns());
        this.mEventCounter = 0;
    }

    private LinkProperties getCurrentLinkProperties() {
        if (this.mConnectivityManager == null) {
            this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        }
        return this.mConnectivityManager.getLinkProperties(this.mConnectionType);
    }

    private InetAddress getDefaultDns() {
        String string2 = Settings.Global.getString(this.mContext.getContentResolver(), "default_dns_server");
        if (string2 == null || string2.length() == 0) {
            string2 = this.mContext.getResources().getString(17039404);
        }
        try {
            InetAddress inetAddress = NetworkUtils.numericToInetAddress(string2);
            return inetAddress;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.loge("getDefaultDns::malformed default dns address");
            return null;
        }
    }

    private void log(String string2) {
        Log.d(this.TAG, string2);
    }

    private void loge(String string2) {
        Log.e(this.TAG, string2);
    }

    private void sendResponse(int n, int n2, int n3) {
        this.mTarget.sendMessage(this.obtainMessage(327680, n, n3));
    }

    public void cancelPings() {
        this.mCurrentToken.incrementAndGet();
        this.obtainMessage(327683).sendToTarget();
    }

    public List<InetAddress> getDnsList() {
        LinkProperties linkProperties = this.getCurrentLinkProperties();
        if (linkProperties == null) {
            this.loge("getCurLinkProperties:: LP for type" + this.mConnectionType + " is null!");
            return this.mDefaultDns;
        }
        List<InetAddress> list = linkProperties.getDnsServers();
        if (list == null || list.size() == 0) {
            this.loge("getDns::LinkProps has null dns - returning default");
            return this.mDefaultDns;
        }
        return new ArrayList<InetAddress>(list);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message var1_1) {
        switch (var1_1.what) lbl-1000:
        // 4 sources

        {
            default: {
                return;
            }
            case 327681: {
                var12_2 = (DnsArg)var1_1.obj;
                if (var12_2.seq != this.mCurrentToken.get()) ** GOTO lbl-1000
                var13_3 = new ActivePing();
                var15_4 = var12_2.dns;
                var13_3.internalId = var1_1.arg1;
                var13_3.timeout = var1_1.arg2;
                var13_3.socket = new DatagramSocket();
                var13_3.socket.setSoTimeout(1);
                var13_3.socket.setNetworkInterface(NetworkInterface.getByName(this.getCurrentLinkProperties().getInterfaceName()));
                {
                    catch (IOException var14_7) {
                        this.sendResponse(var1_1.arg1, -9999, -2);
                        return;
                    }
lbl20:
                    // 1 sources

                    while (true) {
                        var13_3.packetId = (short)DnsPinger.sRandom.nextInt();
                        var17_5 = (byte[])DnsPinger.mDnsQuery.clone();
                        var17_5[0] = (byte)(var13_3.packetId >> 8);
                        var17_5[1] = (byte)var13_3.packetId;
                        var18_6 = new DatagramPacket(var17_5, var17_5.length, var15_4, 53);
                        var13_3.socket.send(var18_6);
                        this.mActivePings.add(var13_3);
                        this.mEventCounter = 1 + this.mEventCounter;
                        this.sendMessageDelayed(this.obtainMessage(327682, this.mEventCounter, 0), 200L);
                        return;
                    }
                    catch (Exception var16_8) {}
                    {
                        this.loge("sendDnsPing::Error binding to socket " + var16_8);
                    }
                }
                {
                    ** continue;
                }
            }
            case 327682: {
                if (var1_1.arg1 != this.mEventCounter) ** GOTO lbl-1000
                for (ActivePing var7_10 : this.mActivePings) {
                    try {
                        var10_13 = new byte[2];
                        var11_14 = new DatagramPacket(var10_13, 2);
                        var7_10.socket.receive(var11_14);
                        if (var10_13[0] != (byte)(var7_10.packetId >> 8) || var10_13[1] != (byte)var7_10.packetId) continue;
                        var7_10.result = (int)(SystemClock.elapsedRealtime() - var7_10.start);
                    }
                    catch (SocketTimeoutException var9_12) {
                    }
                    catch (Exception var8_11) {
                        var7_10.result = -2;
                    }
                }
                var4_15 = this.mActivePings.iterator();
                while (var4_15.hasNext()) {
                    var6_16 = var4_15.next();
                    if (var6_16.result != null) {
                        this.sendResponse(var6_16.internalId, var6_16.packetId, var6_16.result);
                        var6_16.socket.close();
                        var4_15.remove();
                        continue;
                    }
                    if (SystemClock.elapsedRealtime() <= var6_16.start + (long)var6_16.timeout) continue;
                    this.sendResponse(var6_16.internalId, var6_16.packetId, -1);
                    var6_16.socket.close();
                    var4_15.remove();
                }
                if (this.mActivePings.isEmpty()) ** GOTO lbl-1000
                this.sendMessageDelayed(this.obtainMessage(327682, this.mEventCounter, 0), 200L);
                return;
            }
            case 327683: 
        }
        var2_17 = this.mActivePings.iterator();
        while (true) {
            if (!var2_17.hasNext()) {
                this.mActivePings.clear();
                return;
            }
            var2_17.next().socket.close();
        }
    }

    public int pingDnsAsync(InetAddress inetAddress, int n, int n2) {
        int n3 = sCounter.incrementAndGet();
        this.sendMessageDelayed(this.obtainMessage(327681, n3, n, new DnsArg(inetAddress, this.mCurrentToken.get())), n2);
        return n3;
    }

    private class ActivePing {
        int internalId;
        short packetId;
        Integer result;
        DatagramSocket socket;
        long start = SystemClock.elapsedRealtime();
        int timeout;

        private ActivePing() {
        }
    }

    private class DnsArg {
        InetAddress dns;
        int seq;

        DnsArg(InetAddress inetAddress, int n) {
            this.dns = inetAddress;
            this.seq = n;
        }
    }
}

