/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.net.StaticIpConfiguration;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Objects;

public class DhcpResults
extends StaticIpConfiguration {
    public static final Parcelable.Creator<DhcpResults> CREATOR = new Parcelable.Creator<DhcpResults>(){

        @Override
        public DhcpResults createFromParcel(Parcel parcel) {
            DhcpResults dhcpResults = new DhcpResults();
            DhcpResults.readFromParcel(dhcpResults, parcel);
            return dhcpResults;
        }

        public DhcpResults[] newArray(int n) {
            return new DhcpResults[n];
        }
    };
    private static final String TAG = "DhcpResults";
    public int leaseDuration;
    public InetAddress serverAddress;
    public String vendorInfo;

    public DhcpResults() {
    }

    public DhcpResults(DhcpResults dhcpResults) {
        super(dhcpResults);
        if (dhcpResults != null) {
            this.serverAddress = dhcpResults.serverAddress;
            this.vendorInfo = dhcpResults.vendorInfo;
            this.leaseDuration = dhcpResults.leaseDuration;
        }
    }

    public DhcpResults(StaticIpConfiguration staticIpConfiguration) {
        super(staticIpConfiguration);
    }

    private static void readFromParcel(DhcpResults dhcpResults, Parcel parcel) {
        StaticIpConfiguration.readFromParcel(dhcpResults, parcel);
        dhcpResults.leaseDuration = parcel.readInt();
        dhcpResults.serverAddress = NetworkUtils.unparcelInetAddress(parcel);
        dhcpResults.vendorInfo = parcel.readString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addDns(String string2) {
        if (TextUtils.isEmpty(string2)) return false;
        try {
            this.dnsServers.add(NetworkUtils.numericToInetAddress(string2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e(TAG, "addDns failed with addrString " + string2);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.vendorInfo = null;
        this.leaseDuration = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (!(object instanceof DhcpResults)) {
                    return false;
                }
                DhcpResults dhcpResults = (DhcpResults)object;
                if (!super.equals((StaticIpConfiguration)object) || !Objects.equals(this.serverAddress, dhcpResults.serverAddress) || !Objects.equals(this.vendorInfo, dhcpResults.vendorInfo) || this.leaseDuration != dhcpResults.leaseDuration) break block5;
            }
            return true;
        }
        return false;
    }

    public boolean hasMeteredHint() {
        if (this.vendorInfo != null) {
            return this.vendorInfo.contains("ANDROID_METERED");
        }
        return false;
    }

    public void setDomains(String string2) {
    }

    public boolean setGateway(String string2) {
        try {
            this.gateway = NetworkUtils.numericToInetAddress(string2);
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e(TAG, "setGateway failed with addrString " + string2);
            return true;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean setIpAddress(String var1_1, int var2_2) {
        try {
            this.ipAddress = new LinkAddress((Inet4Address)NetworkUtils.numericToInetAddress(var1_1), var2_2);
            return false;
        }
        catch (ClassCastException var5_3) lbl-1000:
        // 2 sources

        {
            while (true) {
                Log.e("DhcpResults", "setIpAddress failed with addrString " + var1_1 + "/" + var2_2);
                return true;
            }
        }
        catch (IllegalArgumentException var3_4) {
            ** continue;
        }
    }

    public void setLeaseDuration(int n) {
        this.leaseDuration = n;
    }

    public boolean setServerAddress(String string2) {
        try {
            this.serverAddress = NetworkUtils.numericToInetAddress(string2);
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e(TAG, "setServerAddress failed with addrString " + string2);
            return true;
        }
    }

    public void setVendorInfo(String string2) {
        this.vendorInfo = string2;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" DHCP server ").append(this.serverAddress);
        stringBuffer.append(" Vendor info ").append(this.vendorInfo);
        stringBuffer.append(" lease ").append(this.leaseDuration).append(" seconds");
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateFromDhcpRequest(DhcpResults dhcpResults) {
        block5: {
            block4: {
                if (dhcpResults == null) break block4;
                if (this.gateway == null) {
                    this.gateway = dhcpResults.gateway;
                }
                if (this.dnsServers.size() == 0) break block5;
            }
            return;
        }
        this.dnsServers.addAll(dhcpResults.dnsServers);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeInt(this.leaseDuration);
        NetworkUtils.parcelInetAddress(parcel, this.serverAddress, n);
        parcel.writeString(this.vendorInfo);
    }
}

