/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.mtp.MtpDeviceInfo;
import android.mtp.MtpObjectInfo;
import android.mtp.MtpStorageInfo;

public final class MtpDevice {
    private static final String TAG = "MtpDevice";
    private final UsbDevice mDevice;
    private long mNativeContext;

    static {
        System.loadLibrary("media_jni");
    }

    public MtpDevice(UsbDevice usbDevice) {
        this.mDevice = usbDevice;
    }

    private native void native_close();

    private native boolean native_delete_object(int var1);

    private native MtpDeviceInfo native_get_device_info();

    private native byte[] native_get_object(int var1, int var2);

    private native int[] native_get_object_handles(int var1, int var2, int var3);

    private native MtpObjectInfo native_get_object_info(int var1);

    private native long native_get_parent(int var1);

    private native long native_get_storage_id(int var1);

    private native int[] native_get_storage_ids();

    private native MtpStorageInfo native_get_storage_info(int var1);

    private native byte[] native_get_thumbnail(int var1);

    private native boolean native_import_file(int var1, String var2);

    private native boolean native_open(String var1, int var2);

    public void close() {
        this.native_close();
    }

    public boolean deleteObject(int n) {
        return this.native_delete_object(n);
    }

    protected void finalize() throws Throwable {
        try {
            this.native_close();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getDeviceId() {
        return this.mDevice.getDeviceId();
    }

    public MtpDeviceInfo getDeviceInfo() {
        return this.native_get_device_info();
    }

    public String getDeviceName() {
        return this.mDevice.getDeviceName();
    }

    public byte[] getObject(int n, int n2) {
        return this.native_get_object(n, n2);
    }

    public int[] getObjectHandles(int n, int n2, int n3) {
        return this.native_get_object_handles(n, n2, n3);
    }

    public MtpObjectInfo getObjectInfo(int n) {
        return this.native_get_object_info(n);
    }

    public long getParent(int n) {
        return this.native_get_parent(n);
    }

    public long getStorageId(int n) {
        return this.native_get_storage_id(n);
    }

    public int[] getStorageIds() {
        return this.native_get_storage_ids();
    }

    public MtpStorageInfo getStorageInfo(int n) {
        return this.native_get_storage_info(n);
    }

    public byte[] getThumbnail(int n) {
        return this.native_get_thumbnail(n);
    }

    public boolean importFile(int n, String string2) {
        return this.native_import_file(n, string2);
    }

    public boolean open(UsbDeviceConnection usbDeviceConnection) {
        boolean bl = this.native_open(this.mDevice.getDeviceName(), usbDeviceConnection.getFileDescriptor());
        if (!bl) {
            usbDeviceConnection.close();
        }
        return bl;
    }

    public String toString() {
        return this.mDevice.getDeviceName();
    }
}

