/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.media.tv.ITvInputService;
import android.media.tv.ITvInputServiceCallback;
import android.media.tv.ITvInputSession;
import android.media.tv.ITvInputSessionCallback;
import android.media.tv.ITvInputSessionWrapper;
import android.media.tv.TvContentRating;
import android.media.tv.TvInputHardwareInfo;
import android.media.tv.TvInputInfo;
import android.media.tv.TvInputManager;
import android.media.tv.TvTrackInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.WindowManager;
import com.android.internal.os.SomeArgs;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class TvInputService
extends Service {
    private static final boolean DEBUG = false;
    public static final String SERVICE_INTERFACE = "android.media.tv.TvInputService";
    public static final String SERVICE_META_DATA = "android.media.tv.input";
    private static final String TAG = "TvInputService";
    private final RemoteCallbackList<ITvInputServiceCallback> mCallbacks;
    private final Handler mServiceHandler = new ServiceHandler();
    private TvInputManager mTvInputManager;

    public TvInputService() {
        this.mCallbacks = new RemoteCallbackList();
    }

    public static boolean isNavigationKey(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 61: 
            case 62: 
            case 66: 
            case 92: 
            case 93: 
            case 122: 
            case 123: 
        }
        return true;
    }

    private boolean isPassthroughInput(String string2) {
        TvInputInfo tvInputInfo;
        if (this.mTvInputManager == null) {
            this.mTvInputManager = (TvInputManager)this.getSystemService("tv_input");
        }
        return (tvInputInfo = this.mTvInputManager.getTvInputInfo(string2)) != null && tvInputInfo.isPassthroughInput();
    }

    public final int getRegisteredCallbackCount() {
        return this.mCallbacks.getRegisteredCallbackCount();
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return new ITvInputService.Stub(){

            @Override
            public void createSession(InputChannel inputChannel, ITvInputSessionCallback iTvInputSessionCallback, String string2) {
                if (inputChannel == null) {
                    Log.w(TvInputService.TAG, "Creating session without input channel");
                }
                if (iTvInputSessionCallback == null) {
                    return;
                }
                SomeArgs someArgs = SomeArgs.obtain();
                someArgs.arg1 = inputChannel;
                someArgs.arg2 = iTvInputSessionCallback;
                someArgs.arg3 = string2;
                TvInputService.this.mServiceHandler.obtainMessage(1, someArgs).sendToTarget();
            }

            @Override
            public void notifyHardwareAdded(TvInputHardwareInfo tvInputHardwareInfo) {
                TvInputService.this.mServiceHandler.obtainMessage(3, tvInputHardwareInfo).sendToTarget();
            }

            @Override
            public void notifyHardwareRemoved(TvInputHardwareInfo tvInputHardwareInfo) {
                TvInputService.this.mServiceHandler.obtainMessage(4, tvInputHardwareInfo).sendToTarget();
            }

            @Override
            public void notifyHdmiDeviceAdded(HdmiDeviceInfo hdmiDeviceInfo) {
                TvInputService.this.mServiceHandler.obtainMessage(5, hdmiDeviceInfo).sendToTarget();
            }

            @Override
            public void notifyHdmiDeviceRemoved(HdmiDeviceInfo hdmiDeviceInfo) {
                TvInputService.this.mServiceHandler.obtainMessage(6, hdmiDeviceInfo).sendToTarget();
            }

            @Override
            public void registerCallback(ITvInputServiceCallback iTvInputServiceCallback) {
                if (iTvInputServiceCallback != null) {
                    TvInputService.this.mCallbacks.register(iTvInputServiceCallback);
                }
            }

            @Override
            public void unregisterCallback(ITvInputServiceCallback iTvInputServiceCallback) {
                if (iTvInputServiceCallback != null) {
                    TvInputService.this.mCallbacks.unregister(iTvInputServiceCallback);
                }
            }
        };
    }

    public abstract Session onCreateSession(String var1);

    public TvInputInfo onHardwareAdded(TvInputHardwareInfo tvInputHardwareInfo) {
        return null;
    }

    public String onHardwareRemoved(TvInputHardwareInfo tvInputHardwareInfo) {
        return null;
    }

    public TvInputInfo onHdmiDeviceAdded(HdmiDeviceInfo hdmiDeviceInfo) {
        return null;
    }

    public String onHdmiDeviceRemoved(HdmiDeviceInfo hdmiDeviceInfo) {
        return null;
    }

    public static abstract class HardwareSession
    extends Session {
        private TvInputManager.Session mHardwareSession;
        private final TvInputManager.SessionCallback mHardwareSessionCallback = new TvInputManager.SessionCallback(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onSessionCreated(TvInputManager.Session session) {
                HardwareSession.access$702(HardwareSession.this, session);
                SomeArgs someArgs = SomeArgs.obtain();
                if (session != null) {
                    someArgs.arg1 = HardwareSession.this.mProxySession;
                    someArgs.arg2 = HardwareSession.this.mProxySessionCallback;
                    someArgs.arg3 = session.getToken();
                } else {
                    someArgs.arg1 = null;
                    someArgs.arg2 = HardwareSession.this.mProxySessionCallback;
                    someArgs.arg3 = null;
                    HardwareSession.this.onRelease();
                }
                HardwareSession.this.mServiceHandler.obtainMessage(2, someArgs).sendToTarget();
            }

            @Override
            public void onVideoAvailable(TvInputManager.Session session) {
                if (HardwareSession.this.mHardwareSession == session) {
                    HardwareSession.this.onHardwareVideoAvailable();
                }
            }

            @Override
            public void onVideoUnavailable(TvInputManager.Session session, int n) {
                if (HardwareSession.this.mHardwareSession == session) {
                    HardwareSession.this.onHardwareVideoUnavailable(n);
                }
            }
        };
        private ITvInputSession mProxySession;
        private ITvInputSessionCallback mProxySessionCallback;
        private Handler mServiceHandler;

        public HardwareSession(Context context) {
            super(context);
        }

        static /* synthetic */ Handler access$1002(HardwareSession hardwareSession, Handler handler) {
            hardwareSession.mServiceHandler = handler;
            return handler;
        }

        static /* synthetic */ TvInputManager.Session access$702(HardwareSession hardwareSession, TvInputManager.Session session) {
            hardwareSession.mHardwareSession = session;
            return session;
        }

        static /* synthetic */ ITvInputSession access$802(HardwareSession hardwareSession, ITvInputSession iTvInputSession) {
            hardwareSession.mProxySession = iTvInputSession;
            return iTvInputSession;
        }

        static /* synthetic */ ITvInputSessionCallback access$902(HardwareSession hardwareSession, ITvInputSessionCallback iTvInputSessionCallback) {
            hardwareSession.mProxySessionCallback = iTvInputSessionCallback;
            return iTvInputSessionCallback;
        }

        public abstract String getHardwareInputId();

        public void onHardwareVideoAvailable() {
        }

        public void onHardwareVideoUnavailable(int n) {
        }

        @Override
        public final boolean onSetSurface(Surface surface) {
            Log.e(TvInputService.TAG, "onSetSurface() should not be called in HardwareProxySession.");
            return false;
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private final class ServiceHandler
    extends Handler {
        private static final int DO_ADD_HARDWARE_TV_INPUT = 3;
        private static final int DO_ADD_HDMI_TV_INPUT = 5;
        private static final int DO_CREATE_SESSION = 1;
        private static final int DO_NOTIFY_SESSION_CREATED = 2;
        private static final int DO_REMOVE_HARDWARE_TV_INPUT = 4;
        private static final int DO_REMOVE_HDMI_TV_INPUT = 6;

        private ServiceHandler() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void broadcastAddHardwareTvInput(int n, TvInputInfo tvInputInfo) {
            int n2 = TvInputService.this.mCallbacks.beginBroadcast();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    TvInputService.this.mCallbacks.finishBroadcast();
                    return;
                }
                try {
                    ((ITvInputServiceCallback)TvInputService.this.mCallbacks.getBroadcastItem(n3)).addHardwareTvInput(n, tvInputInfo);
                }
                catch (RemoteException remoteException) {
                    Log.e(TvInputService.TAG, "Error while broadcasting.", remoteException);
                }
                ++n3;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void broadcastAddHdmiTvInput(int n, TvInputInfo tvInputInfo) {
            int n2 = TvInputService.this.mCallbacks.beginBroadcast();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    TvInputService.this.mCallbacks.finishBroadcast();
                    return;
                }
                try {
                    ((ITvInputServiceCallback)TvInputService.this.mCallbacks.getBroadcastItem(n3)).addHdmiTvInput(n, tvInputInfo);
                }
                catch (RemoteException remoteException) {
                    Log.e(TvInputService.TAG, "Error while broadcasting.", remoteException);
                }
                ++n3;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void broadcastRemoveTvInput(String string2) {
            int n = TvInputService.this.mCallbacks.beginBroadcast();
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    TvInputService.this.mCallbacks.finishBroadcast();
                    return;
                }
                try {
                    ((ITvInputServiceCallback)TvInputService.this.mCallbacks.getBroadcastItem(n2)).removeTvInput(string2);
                }
                catch (RemoteException remoteException) {
                    Log.e(TvInputService.TAG, "Error while broadcasting.", remoteException);
                }
                ++n2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    Log.w(TvInputService.TAG, "Unhandled message code: " + message.what);
                    return;
                }
                case 1: {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    InputChannel inputChannel = (InputChannel)someArgs.arg1;
                    ITvInputSessionCallback iTvInputSessionCallback = (ITvInputSessionCallback)someArgs.arg2;
                    String string2 = (String)someArgs.arg3;
                    someArgs.recycle();
                    Session session = TvInputService.this.onCreateSession(string2);
                    if (session == null) {
                        try {
                            iTvInputSessionCallback.onSessionCreated(null, null);
                            return;
                        }
                        catch (RemoteException remoteException) {
                            Log.e(TvInputService.TAG, "error in onSessionCreated");
                            return;
                        }
                    }
                    session.setSessionCallback(iTvInputSessionCallback);
                    ITvInputSessionWrapper iTvInputSessionWrapper = new ITvInputSessionWrapper(TvInputService.this, session, inputChannel);
                    if (!(session instanceof HardwareSession)) {
                        SomeArgs someArgs2 = SomeArgs.obtain();
                        someArgs2.arg1 = iTvInputSessionWrapper;
                        someArgs2.arg2 = iTvInputSessionCallback;
                        someArgs2.arg3 = null;
                        TvInputService.this.mServiceHandler.obtainMessage(2, someArgs2).sendToTarget();
                        return;
                    }
                    HardwareSession hardwareSession = (HardwareSession)session;
                    String string3 = hardwareSession.getHardwareInputId();
                    if (!TextUtils.isEmpty(string3) && TvInputService.this.isPassthroughInput(string3)) {
                        HardwareSession.access$802(hardwareSession, iTvInputSessionWrapper);
                        HardwareSession.access$902(hardwareSession, iTvInputSessionCallback);
                        HardwareSession.access$1002(hardwareSession, TvInputService.this.mServiceHandler);
                        ((TvInputManager)TvInputService.this.getSystemService("tv_input")).createSession(string3, hardwareSession.mHardwareSessionCallback, TvInputService.this.mServiceHandler);
                        return;
                    }
                    if (TextUtils.isEmpty(string3)) {
                        Log.w(TvInputService.TAG, "Hardware input id is not setup yet.");
                    } else {
                        Log.w(TvInputService.TAG, "Invalid hardware input id : " + string3);
                    }
                    session.onRelease();
                    try {
                        iTvInputSessionCallback.onSessionCreated(null, null);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.e(TvInputService.TAG, "error in onSessionCreated");
                        return;
                    }
                }
                case 2: {
                    SomeArgs someArgs = (SomeArgs)message.obj;
                    ITvInputSession iTvInputSession = (ITvInputSession)someArgs.arg1;
                    ITvInputSessionCallback iTvInputSessionCallback = (ITvInputSessionCallback)someArgs.arg2;
                    IBinder iBinder = (IBinder)someArgs.arg3;
                    try {
                        iTvInputSessionCallback.onSessionCreated(iTvInputSession, iBinder);
                    }
                    catch (RemoteException remoteException) {
                        Log.e(TvInputService.TAG, "error in onSessionCreated");
                    }
                    someArgs.recycle();
                    return;
                }
                case 3: {
                    TvInputHardwareInfo tvInputHardwareInfo = (TvInputHardwareInfo)message.obj;
                    TvInputInfo tvInputInfo = TvInputService.this.onHardwareAdded(tvInputHardwareInfo);
                    if (tvInputInfo == null) return;
                    this.broadcastAddHardwareTvInput(tvInputHardwareInfo.getDeviceId(), tvInputInfo);
                    return;
                }
                case 4: {
                    TvInputHardwareInfo tvInputHardwareInfo = (TvInputHardwareInfo)message.obj;
                    String string4 = TvInputService.this.onHardwareRemoved(tvInputHardwareInfo);
                    if (string4 == null) return;
                    this.broadcastRemoveTvInput(string4);
                    return;
                }
                case 5: {
                    HdmiDeviceInfo hdmiDeviceInfo = (HdmiDeviceInfo)message.obj;
                    TvInputInfo tvInputInfo = TvInputService.this.onHdmiDeviceAdded(hdmiDeviceInfo);
                    if (tvInputInfo == null) return;
                    this.broadcastAddHdmiTvInput(hdmiDeviceInfo.getId(), tvInputInfo);
                    return;
                }
                case 6: {
                    HdmiDeviceInfo hdmiDeviceInfo = (HdmiDeviceInfo)message.obj;
                    String string5 = TvInputService.this.onHdmiDeviceRemoved(hdmiDeviceInfo);
                    if (string5 == null) return;
                    this.broadcastRemoveTvInput(string5);
                    return;
                }
            }
        }
    }

    public static abstract class Session
    implements KeyEvent.Callback {
        private final KeyEvent.DispatcherState mDispatcherState = new KeyEvent.DispatcherState();
        final Handler mHandler;
        private Rect mOverlayFrame;
        private View mOverlayView;
        private boolean mOverlayViewEnabled;
        private ITvInputSessionCallback mSessionCallback;
        private Surface mSurface;
        private final WindowManager mWindowManager;
        private WindowManager.LayoutParams mWindowParams;
        private IBinder mWindowToken;

        public Session(Context context) {
            this.mWindowManager = (WindowManager)context.getSystemService("window");
            this.mHandler = new Handler(context.getMainLooper());
        }

        static /* synthetic */ boolean access$302(Session session, boolean bl) {
            session.mOverlayViewEnabled = bl;
            return bl;
        }

        private final void runOnMainThread(Runnable runnable) {
            if (this.mHandler.getLooper().isCurrentThread() && this.mSessionCallback != null) {
                runnable.run();
                return;
            }
            this.mHandler.post(runnable);
        }

        private void setSessionCallback(ITvInputSessionCallback iTvInputSessionCallback) {
            this.mSessionCallback = iTvInputSessionCallback;
        }

        void appPrivateCommand(String string2, Bundle bundle) {
            this.onAppPrivateCommand(string2, bundle);
        }

        /*
         * Enabled aggressive block sorting
         */
        void createOverlayView(IBinder iBinder, Rect rect) {
            block5: {
                block4: {
                    if (this.mOverlayView != null) {
                        this.mWindowManager.removeView(this.mOverlayView);
                        this.mOverlayView = null;
                    }
                    this.mWindowToken = iBinder;
                    this.mOverlayFrame = rect;
                    this.onOverlayViewSizeChanged(rect.right - rect.left, rect.bottom - rect.top);
                    if (!this.mOverlayViewEnabled) break block4;
                    this.mOverlayView = this.onCreateOverlayView();
                    if (this.mOverlayView != null) break block5;
                }
                return;
            }
            WindowManager.LayoutParams layoutParams = this.mWindowParams = new WindowManager.LayoutParams(rect.right - rect.left, rect.bottom - rect.top, rect.left, rect.top, 1004, 536, -2);
            layoutParams.privateFlags = 0x40 | layoutParams.privateFlags;
            this.mWindowParams.gravity = 0x800033;
            this.mWindowParams.token = iBinder;
            this.mWindowManager.addView(this.mOverlayView, this.mWindowParams);
        }

        /*
         * Enabled aggressive block sorting
         */
        int dispatchInputEvent(InputEvent inputEvent, InputEventReceiver inputEventReceiver) {
            boolean bl;
            if (inputEvent instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)inputEvent;
                bl = TvInputService.isNavigationKey(keyEvent.getKeyCode());
                if (keyEvent.dispatch(this, this.mDispatcherState, this)) {
                    return 1;
                }
            } else {
                boolean bl2 = inputEvent instanceof MotionEvent;
                bl = false;
                if (bl2) {
                    MotionEvent motionEvent = (MotionEvent)inputEvent;
                    int n = motionEvent.getSource();
                    if (motionEvent.isTouchEvent()) {
                        boolean bl3 = this.onTouchEvent(motionEvent);
                        bl = false;
                        if (bl3) return 1;
                    } else if ((n & 4) != 0) {
                        boolean bl4 = this.onTrackballEvent(motionEvent);
                        bl = false;
                        if (bl4) {
                            return 1;
                        }
                    } else {
                        boolean bl5 = this.onGenericMotionEvent(motionEvent);
                        bl = false;
                        if (bl5) {
                            return 1;
                        }
                    }
                }
            }
            if (this.mOverlayView == null || !this.mOverlayView.isAttachedToWindow()) {
                return 0;
            }
            if (!this.mOverlayView.hasWindowFocus()) {
                this.mOverlayView.getViewRootImpl().windowFocusChanged(true, true);
            }
            if (bl && this.mOverlayView.hasFocusable()) {
                this.mOverlayView.getViewRootImpl().dispatchInputEvent(inputEvent);
                return 1;
            }
            this.mOverlayView.getViewRootImpl().dispatchInputEvent(inputEvent, inputEventReceiver);
            return -1;
        }

        void dispatchSurfaceChanged(int n, int n2, int n3) {
            this.onSurfaceChanged(n, n2, n3);
        }

        public void layoutSurface(final int n, final int n2, final int n3, final int n4) {
            if (n > n3 || n2 > n4) {
                throw new IllegalArgumentException("Invalid parameter");
            }
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onLayoutSurface(n, n2, n3, n4);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.w(TvInputService.TAG, "error in layoutSurface");
                        return;
                    }
                }
            });
        }

        public void notifyChannelRetuned(final Uri uri) {
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onChannelRetuned(uri);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.w(TvInputService.TAG, "error in notifyChannelRetuned");
                        return;
                    }
                }
            });
        }

        public void notifyContentAllowed() {
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onContentAllowed();
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.w(TvInputService.TAG, "error in notifyContentAllowed");
                        return;
                    }
                }
            });
        }

        public void notifyContentBlocked(final TvContentRating tvContentRating) {
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onContentBlocked(tvContentRating.flattenToString());
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.w(TvInputService.TAG, "error in notifyContentBlocked");
                        return;
                    }
                }
            });
        }

        public void notifySessionEvent(final String string2, final Bundle bundle) {
            if (string2 == null) {
                throw new IllegalArgumentException("eventType should not be null.");
            }
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onSessionEvent(string2, bundle);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.w(TvInputService.TAG, "error in sending event (event=" + string2 + ")");
                        return;
                    }
                }
            });
        }

        public void notifyTrackSelected(final int n, final String string2) {
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onTrackSelected(n, string2);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.w(TvInputService.TAG, "error in notifyTrackSelected");
                        return;
                    }
                }
            });
        }

        public void notifyTracksChanged(final List<TvTrackInfo> list) {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator<TvTrackInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().getId();
                if (hashSet.contains(string2)) {
                    throw new IllegalArgumentException("redundant track ID: " + string2);
                }
                hashSet.add(string2);
            }
            hashSet.clear();
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onTracksChanged(list);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.w(TvInputService.TAG, "error in notifyTracksChanged");
                        return;
                    }
                }
            });
        }

        public void notifyVideoAvailable() {
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onVideoAvailable();
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.w(TvInputService.TAG, "error in notifyVideoAvailable");
                        return;
                    }
                }
            });
        }

        public void notifyVideoUnavailable(final int n) {
            if (n < 0 || n > 3) {
                throw new IllegalArgumentException("Unknown reason: " + n);
            }
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.mSessionCallback.onVideoUnavailable(n);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.w(TvInputService.TAG, "error in notifyVideoUnavailable");
                        return;
                    }
                }
            });
        }

        public void onAppPrivateCommand(String string2, Bundle bundle) {
        }

        public View onCreateOverlayView() {
            return null;
        }

        public boolean onGenericMotionEvent(MotionEvent motionEvent) {
            return false;
        }

        @Override
        public boolean onKeyDown(int n, KeyEvent keyEvent) {
            return false;
        }

        @Override
        public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
            return false;
        }

        @Override
        public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
            return false;
        }

        @Override
        public boolean onKeyUp(int n, KeyEvent keyEvent) {
            return false;
        }

        public void onOverlayViewSizeChanged(int n, int n2) {
        }

        public abstract void onRelease();

        public boolean onSelectTrack(int n, String string2) {
            return false;
        }

        public abstract void onSetCaptionEnabled(boolean var1);

        public void onSetMain(boolean bl) {
        }

        public abstract void onSetStreamVolume(float var1);

        public abstract boolean onSetSurface(Surface var1);

        public void onSurfaceChanged(int n, int n2, int n3) {
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            return false;
        }

        public boolean onTrackballEvent(MotionEvent motionEvent) {
            return false;
        }

        public abstract boolean onTune(Uri var1);

        public boolean onTune(Uri uri, Bundle bundle) {
            return this.onTune(uri);
        }

        public void onUnblockContent(TvContentRating tvContentRating) {
        }

        void relayoutOverlayView(Rect rect) {
            if (this.mOverlayFrame == null || this.mOverlayFrame.width() != rect.width() || this.mOverlayFrame.height() != rect.height()) {
                this.onOverlayViewSizeChanged(rect.right - rect.left, rect.bottom - rect.top);
            }
            this.mOverlayFrame = rect;
            if (!this.mOverlayViewEnabled || this.mOverlayView == null) {
                return;
            }
            this.mWindowParams.x = rect.left;
            this.mWindowParams.y = rect.top;
            this.mWindowParams.width = rect.right - rect.left;
            this.mWindowParams.height = rect.bottom - rect.top;
            this.mWindowManager.updateViewLayout(this.mOverlayView, this.mWindowParams);
        }

        void release() {
            this.removeOverlayView(true);
            this.onRelease();
            if (this.mSurface != null) {
                this.mSurface.release();
                this.mSurface = null;
            }
        }

        void removeOverlayView(boolean bl) {
            if (bl) {
                this.mWindowToken = null;
                this.mOverlayFrame = null;
            }
            if (this.mOverlayView != null) {
                this.mWindowManager.removeView(this.mOverlayView);
                this.mOverlayView = null;
                this.mWindowParams = null;
            }
        }

        void selectTrack(int n, String string2) {
            this.onSelectTrack(n, string2);
        }

        void setCaptionEnabled(boolean bl) {
            this.onSetCaptionEnabled(bl);
        }

        void setMain(boolean bl) {
            this.onSetMain(bl);
        }

        public void setOverlayViewEnabled(final boolean bl) {
            this.mHandler.post(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void run() {
                    block5: {
                        block4: {
                            if (bl == Session.this.mOverlayViewEnabled) break block4;
                            Session.access$302(Session.this, bl);
                            if (!bl) {
                                Session.this.removeOverlayView(false);
                                return;
                            }
                            if (Session.this.mWindowToken != null) break block5;
                        }
                        return;
                    }
                    Session.this.createOverlayView(Session.this.mWindowToken, Session.this.mOverlayFrame);
                }
            });
        }

        void setStreamVolume(float f) {
            this.onSetStreamVolume(f);
        }

        void setSurface(Surface surface) {
            this.onSetSurface(surface);
            if (this.mSurface != null) {
                this.mSurface.release();
            }
            this.mSurface = surface;
        }

        void tune(Uri uri, Bundle bundle) {
            this.onTune(uri, bundle);
        }

        void unblockContent(String string2) {
            this.onUnblockContent(TvContentRating.unflattenFromString(string2));
        }
    }
}

