/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.media.tv.TvInputHardwareInfo;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;

public final class TvInputInfo
implements Parcelable {
    public static final Parcelable.Creator<TvInputInfo> CREATOR;
    private static final boolean DEBUG = false;
    private static final String DELIMITER_INFO_IN_ID = "/";
    public static final String EXTRA_INPUT_ID = "android.media.tv.extra.INPUT_ID";
    private static final int LENGTH_HDMI_DEVICE_ID = 2;
    private static final int LENGTH_HDMI_PHYSICAL_ADDRESS = 4;
    private static final String PREFIX_HARDWARE_DEVICE = "HW";
    private static final String PREFIX_HDMI_DEVICE = "HDMI";
    private static final String TAG = "TvInputInfo";
    public static final int TYPE_COMPONENT = 1004;
    public static final int TYPE_COMPOSITE = 1001;
    public static final int TYPE_DISPLAY_PORT = 1008;
    public static final int TYPE_DVI = 1006;
    public static final int TYPE_HDMI = 1007;
    public static final int TYPE_OTHER = 1000;
    public static final int TYPE_SCART = 1003;
    public static final int TYPE_SVIDEO = 1002;
    public static final int TYPE_TUNER = 0;
    public static final int TYPE_VGA = 1005;
    private static final String XML_START_TAG_NAME = "tv-input";
    private static SparseIntArray sHardwareTypeToTvInputType;
    private HdmiDeviceInfo mHdmiDeviceInfo;
    private Uri mIconUri;
    private final String mId;
    private boolean mIsConnectedToHdmiSwitch;
    private String mLabel;
    private final String mParentId;
    private final ResolveInfo mService;
    private String mSettingsActivity;
    private String mSetupActivity;
    private int mType = 0;

    static {
        sHardwareTypeToTvInputType = new SparseIntArray();
        sHardwareTypeToTvInputType.put(1, 1000);
        sHardwareTypeToTvInputType.put(2, 0);
        sHardwareTypeToTvInputType.put(3, 1001);
        sHardwareTypeToTvInputType.put(4, 1002);
        sHardwareTypeToTvInputType.put(5, 1003);
        sHardwareTypeToTvInputType.put(6, 1004);
        sHardwareTypeToTvInputType.put(7, 1005);
        sHardwareTypeToTvInputType.put(8, 1006);
        sHardwareTypeToTvInputType.put(9, 1007);
        sHardwareTypeToTvInputType.put(10, 1008);
        CREATOR = new Parcelable.Creator<TvInputInfo>(){

            @Override
            public TvInputInfo createFromParcel(Parcel parcel) {
                return new TvInputInfo(parcel);
            }

            public TvInputInfo[] newArray(int n) {
                return new TvInputInfo[n];
            }
        };
    }

    private TvInputInfo(ResolveInfo resolveInfo, String string2, String string3, int n) {
        this.mService = resolveInfo;
        this.mId = string2;
        this.mParentId = string3;
        this.mType = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private TvInputInfo(Parcel parcel) {
        this.mId = parcel.readString();
        this.mParentId = parcel.readString();
        this.mService = ResolveInfo.CREATOR.createFromParcel(parcel);
        this.mSetupActivity = parcel.readString();
        this.mSettingsActivity = parcel.readString();
        this.mType = parcel.readInt();
        this.mHdmiDeviceInfo = (HdmiDeviceInfo)parcel.readParcelable(null);
        this.mIconUri = (Uri)parcel.readParcelable(null);
        this.mLabel = parcel.readString();
        boolean bl = parcel.readByte() == 1;
        this.mIsConnectedToHdmiSwitch = bl;
    }

    public static TvInputInfo createTvInputInfo(Context context, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        return TvInputInfo.createTvInputInfo(context, resolveInfo, TvInputInfo.generateInputIdForComponentName(new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name)), null, 0, null, null, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static TvInputInfo createTvInputInfo(Context context, ResolveInfo resolveInfo, HdmiDeviceInfo hdmiDeviceInfo, String string2, String string3, Uri uri) throws XmlPullParserException, IOException {
        boolean bl = (0xFFF & hdmiDeviceInfo.getPhysicalAddress()) != 0;
        TvInputInfo tvInputInfo = TvInputInfo.createTvInputInfo(context, resolveInfo, TvInputInfo.generateInputIdForHdmiDevice(new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name), hdmiDeviceInfo), string2, 1007, string3, uri, bl);
        tvInputInfo.mHdmiDeviceInfo = hdmiDeviceInfo;
        return tvInputInfo;
    }

    public static TvInputInfo createTvInputInfo(Context context, ResolveInfo resolveInfo, TvInputHardwareInfo tvInputHardwareInfo, String string2, Uri uri) throws XmlPullParserException, IOException {
        int n = sHardwareTypeToTvInputType.get(tvInputHardwareInfo.getType(), 0);
        return TvInputInfo.createTvInputInfo(context, resolveInfo, TvInputInfo.generateInputIdForHardware(new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name), tvInputHardwareInfo), null, n, string2, uri, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TvInputInfo createTvInputInfo(Context context, ResolveInfo resolveInfo, String string2, String string3, int n, String string4, Uri uri, boolean bl) throws XmlPullParserException, IOException {
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        PackageManager packageManager = context.getPackageManager();
        XmlResourceParser xmlResourceParser = null;
        try {
            int n2;
            try {
                xmlResourceParser = serviceInfo.loadXmlMetaData(packageManager, "android.media.tv.input");
                if (xmlResourceParser == null) {
                    throw new XmlPullParserException("No android.media.tv.input meta-data for " + serviceInfo.name);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                throw new XmlPullParserException("Unable to create context for: " + serviceInfo.packageName);
            }
            Resources resources = packageManager.getResourcesForApplication(serviceInfo.applicationInfo);
            AttributeSet attributeSet = Xml.asAttributeSet(xmlResourceParser);
            while ((n2 = xmlResourceParser.next()) != 1 && n2 != 2) {
            }
            if (!XML_START_TAG_NAME.equals(xmlResourceParser.getName())) {
                throw new XmlPullParserException("Meta-data does not start with tv-input-service tag in " + serviceInfo.name);
            }
            TvInputInfo tvInputInfo = new TvInputInfo(resolveInfo, string2, string3, n);
            TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.TvInputService);
            tvInputInfo.mSetupActivity = typedArray.getString(1);
            tvInputInfo.mSettingsActivity = typedArray.getString(0);
            typedArray.recycle();
            tvInputInfo.mLabel = string4;
            tvInputInfo.mIconUri = uri;
            tvInputInfo.mIsConnectedToHdmiSwitch = bl;
            return tvInputInfo;
        }
        finally {
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
        }
    }

    private static final String generateInputIdForComponentName(ComponentName componentName) {
        return componentName.flattenToShortString();
    }

    private static final String generateInputIdForHardware(ComponentName componentName, TvInputHardwareInfo tvInputHardwareInfo) {
        StringBuilder stringBuilder = new StringBuilder().append(componentName.flattenToShortString());
        Object[] objectArray = new Object[]{DELIMITER_INFO_IN_ID, PREFIX_HARDWARE_DEVICE, tvInputHardwareInfo.getDeviceId()};
        return stringBuilder.append(String.format("%s%s%d", objectArray)).toString();
    }

    private static final String generateInputIdForHdmiDevice(ComponentName componentName, HdmiDeviceInfo hdmiDeviceInfo) {
        Object[] objectArray = new Object[]{DELIMITER_INFO_IN_ID, PREFIX_HDMI_DEVICE, 4, 2};
        String string2 = String.format("%s%s%%0%sX%%0%sX", objectArray);
        StringBuilder stringBuilder = new StringBuilder().append(componentName.flattenToShortString());
        Object[] objectArray2 = new Object[]{hdmiDeviceInfo.getPhysicalAddress(), hdmiDeviceInfo.getId()};
        return stringBuilder.append(String.format(string2, objectArray2)).toString();
    }

    private Drawable loadServiceIcon(Context context) {
        if (this.mService.serviceInfo.icon == 0 && this.mService.serviceInfo.applicationInfo.icon == 0) {
            return null;
        }
        return this.mService.serviceInfo.loadIcon(context.getPackageManager());
    }

    public Intent createSettingsIntent() {
        if (!TextUtils.isEmpty(this.mSettingsActivity)) {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(this.mService.serviceInfo.packageName, this.mSettingsActivity);
            intent.putExtra(EXTRA_INPUT_ID, this.getId());
            return intent;
        }
        return null;
    }

    public Intent createSetupIntent() {
        if (!TextUtils.isEmpty(this.mSetupActivity)) {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(this.mService.serviceInfo.packageName, this.mSetupActivity);
            intent.putExtra(EXTRA_INPUT_ID, this.getId());
            return intent;
        }
        return null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TvInputInfo)) {
            return false;
        }
        TvInputInfo tvInputInfo = (TvInputInfo)object;
        return this.mId.equals(tvInputInfo.mId);
    }

    public ComponentName getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    public HdmiDeviceInfo getHdmiDeviceInfo() {
        if (this.mType == 1007) {
            return this.mHdmiDeviceInfo;
        }
        return null;
    }

    public String getId() {
        return this.mId;
    }

    public String getParentId() {
        return this.mParentId;
    }

    public ServiceInfo getServiceInfo() {
        return this.mService.serviceInfo;
    }

    public int getType() {
        return this.mType;
    }

    public int hashCode() {
        return this.mId.hashCode();
    }

    public boolean isConnectedToHdmiSwitch() {
        return this.mIsConnectedToHdmiSwitch;
    }

    public boolean isHidden(Context context) {
        return TvInputSettings.isHidden(context, this.mId, UserHandle.myUserId());
    }

    public boolean isPassthroughInput() {
        return this.mType != 0;
    }

    public CharSequence loadCustomLabel(Context context) {
        return TvInputSettings.getCustomLabel(context, this.mId, UserHandle.myUserId());
    }

    /*
     * Exception decompiling
     */
    public Drawable loadIcon(Context var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [8 : 119->124)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CharSequence loadLabel(Context context) {
        if (TextUtils.isEmpty(this.mLabel)) {
            return this.mService.loadLabel(context.getPackageManager());
        }
        return this.mLabel;
    }

    public String toString() {
        return "TvInputInfo{id=" + this.mId + ", pkg=" + this.mService.serviceInfo.packageName + ", service=" + this.mService.serviceInfo.name + "}";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mId);
        parcel.writeString(this.mParentId);
        this.mService.writeToParcel(parcel, n);
        parcel.writeString(this.mSetupActivity);
        parcel.writeString(this.mSettingsActivity);
        parcel.writeInt(this.mType);
        parcel.writeParcelable(this.mHdmiDeviceInfo, n);
        parcel.writeParcelable(this.mIconUri, n);
        parcel.writeString(this.mLabel);
        byte by = this.mIsConnectedToHdmiSwitch ? (byte)1 : 0;
        parcel.writeByte(by);
    }

    public static final class TvInputSettings {
        private static final String CUSTOM_NAME_SEPARATOR = ",";
        private static final String TV_INPUT_SEPARATOR = ":";

        private TvInputSettings() {
        }

        private static void ensureValidField(String string2) {
            if (TextUtils.isEmpty(string2)) {
                throw new IllegalArgumentException(string2 + " should not empty ");
            }
        }

        private static String getCustomLabel(Context context, String string2, int n) {
            return TvInputSettings.getCustomLabels(context, n).get(string2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static Map<String, String> getCustomLabels(Context context, int n) {
            String string2 = Settings.Secure.getStringForUser(context.getContentResolver(), "tv_input_custom_labels", n);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (!TextUtils.isEmpty(string2)) {
                String[] stringArray = string2.split(TV_INPUT_SEPARATOR);
                int n2 = stringArray.length;
                for (int i = 0; i < n2; ++i) {
                    String[] stringArray2 = stringArray[i].split(CUSTOM_NAME_SEPARATOR);
                    hashMap.put(Uri.decode(stringArray2[0]), Uri.decode(stringArray2[1]));
                }
            }
            return hashMap;
        }

        /*
         * Enabled aggressive block sorting
         */
        public static Set<String> getHiddenTvInputIds(Context context, int n) {
            String string2 = Settings.Secure.getStringForUser(context.getContentResolver(), "tv_input_hidden_inputs", n);
            HashSet<String> hashSet = new HashSet<String>();
            if (!TextUtils.isEmpty(string2)) {
                String[] stringArray = string2.split(TV_INPUT_SEPARATOR);
                int n2 = stringArray.length;
                for (int i = 0; i < n2; ++i) {
                    hashSet.add(Uri.decode(stringArray[i]));
                }
            }
            return hashSet;
        }

        private static boolean isHidden(Context context, String string2, int n) {
            return TvInputSettings.getHiddenTvInputIds(context, n).contains(string2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static void putCustomLabels(Context context, Map<String, String> map, int n) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    Settings.Secure.putStringForUser(context.getContentResolver(), "tv_input_custom_labels", stringBuilder.toString(), n);
                    return;
                }
                Map.Entry<String, String> entry = iterator.next();
                TvInputSettings.ensureValidField(entry.getKey());
                TvInputSettings.ensureValidField(entry.getValue());
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(TV_INPUT_SEPARATOR);
                }
                stringBuilder.append(Uri.encode(entry.getKey()));
                stringBuilder.append(CUSTOM_NAME_SEPARATOR);
                stringBuilder.append(Uri.encode(entry.getValue()));
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public static void putHiddenTvInputs(Context context, Set<String> set, int n) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            Iterator<String> iterator = set.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    Settings.Secure.putStringForUser(context.getContentResolver(), "tv_input_hidden_inputs", stringBuilder.toString(), n);
                    return;
                }
                String string2 = iterator.next();
                TvInputSettings.ensureValidField(string2);
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(TV_INPUT_SEPARATOR);
                }
                stringBuilder.append(Uri.encode(string2));
            }
        }
    }
}

