/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.text.TextUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class TvContentRating {
    private static final String DELIMITER = "/";
    private final String mDomain;
    private final int mHashCode;
    private final String mRating;
    private final String mRatingSystem;
    private final String[] mSubRatings;

    /*
     * Enabled aggressive block sorting
     */
    private TvContentRating(String string2, String string3, String string4, String[] stringArray) {
        this.mDomain = string2;
        this.mRatingSystem = string3;
        this.mRating = string4;
        if (stringArray == null || stringArray.length == 0) {
            this.mSubRatings = null;
        } else {
            Arrays.sort(stringArray);
            this.mSubRatings = stringArray;
        }
        Object[] objectArray = new Object[]{this.mDomain, this.mRating};
        this.mHashCode = 31 * Objects.hash(objectArray) + Arrays.hashCode(this.mSubRatings);
    }

    public static TvContentRating createRating(String string2, String string3, String string4, String ... stringArray) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException("domain cannot be empty");
        }
        if (TextUtils.isEmpty(string3)) {
            throw new IllegalArgumentException("ratingSystem cannot be empty");
        }
        if (TextUtils.isEmpty(string4)) {
            throw new IllegalArgumentException("rating cannot be empty");
        }
        return new TvContentRating(string2, string3, string4, stringArray);
    }

    public static TvContentRating unflattenFromString(String string2) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException("ratingString cannot be empty");
        }
        String[] stringArray = string2.split(DELIMITER);
        if (stringArray.length < 3) {
            throw new IllegalArgumentException("Invalid rating string: " + string2);
        }
        if (stringArray.length > 3) {
            String[] stringArray2 = new String[-3 + stringArray.length];
            System.arraycopy(stringArray, 3, stringArray2, 0, stringArray2.length);
            return new TvContentRating(stringArray[0], stringArray[1], stringArray[2], stringArray2);
        }
        return new TvContentRating(stringArray[0], stringArray[1], stringArray[2], null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean contains(TvContentRating tvContentRating) {
        List<String> list;
        List<String> list2;
        block7: {
            block6: {
                if (tvContentRating == null) {
                    throw new IllegalArgumentException("rating cannot be null");
                }
                if (!tvContentRating.getMainRating().equals(this.mRating) || !tvContentRating.getDomain().equals(this.mDomain) || !tvContentRating.getRatingSystem().equals(this.mRatingSystem) || !tvContentRating.getMainRating().equals(this.mRating)) break block6;
                list2 = this.getSubRatings();
                list = tvContentRating.getSubRatings();
                if (list2 == null && list == null) {
                    return true;
                }
                if (list2 != null || list == null) break block7;
            }
            return false;
        }
        if (list2 != null && list == null) {
            return true;
        }
        return list2.containsAll(list);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        TvContentRating tvContentRating;
        block3: {
            block2: {
                if (!(object instanceof TvContentRating)) break block2;
                tvContentRating = (TvContentRating)object;
                if (this.mHashCode == tvContentRating.mHashCode && TextUtils.equals(this.mDomain, tvContentRating.mDomain) && TextUtils.equals(this.mRatingSystem, tvContentRating.mRatingSystem) && TextUtils.equals(this.mRating, tvContentRating.mRating)) break block3;
            }
            return false;
        }
        return Arrays.equals(this.mSubRatings, tvContentRating.mSubRatings);
    }

    public String flattenToString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mDomain);
        stringBuilder.append(DELIMITER);
        stringBuilder.append(this.mRatingSystem);
        stringBuilder.append(DELIMITER);
        stringBuilder.append(this.mRating);
        if (this.mSubRatings != null) {
            for (String string2 : this.mSubRatings) {
                stringBuilder.append(DELIMITER);
                stringBuilder.append(string2);
            }
        }
        return stringBuilder.toString();
    }

    public String getDomain() {
        return this.mDomain;
    }

    public String getMainRating() {
        return this.mRating;
    }

    public String getRatingSystem() {
        return this.mRatingSystem;
    }

    public List<String> getSubRatings() {
        if (this.mSubRatings == null) {
            return null;
        }
        return Collections.unmodifiableList(Arrays.asList(this.mSubRatings));
    }

    public int hashCode() {
        return this.mHashCode;
    }
}

