/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.media.tv.TvInputInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITvInputServiceCallback
extends IInterface {
    public void addHardwareTvInput(int var1, TvInputInfo var2) throws RemoteException;

    public void addHdmiTvInput(int var1, TvInputInfo var2) throws RemoteException;

    public void removeTvInput(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvInputServiceCallback {
        private static final String DESCRIPTOR = "android.media.tv.ITvInputServiceCallback";
        static final int TRANSACTION_addHardwareTvInput = 1;
        static final int TRANSACTION_addHdmiTvInput = 2;
        static final int TRANSACTION_removeTvInput = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITvInputServiceCallback asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ITvInputServiceCallback) {
                return (ITvInputServiceCallback)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = parcel.readInt();
                    TvInputInfo tvInputInfo = parcel.readInt() != 0 ? TvInputInfo.CREATOR.createFromParcel(parcel) : null;
                    this.addHardwareTvInput(n3, tvInputInfo);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = parcel.readInt();
                    TvInputInfo tvInputInfo = parcel.readInt() != 0 ? TvInputInfo.CREATOR.createFromParcel(parcel) : null;
                    this.addHdmiTvInput(n4, tvInputInfo);
                    return true;
                }
                case 3: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.removeTvInput(parcel.readString());
            return true;
        }

        private static class Proxy
        implements ITvInputServiceCallback {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addHardwareTvInput(int n, TvInputInfo tvInputInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (tvInputInfo != null) {
                        parcel.writeInt(1);
                        tvInputInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addHdmiTvInput(int n, TvInputInfo tvInputInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (tvInputInfo != null) {
                        parcel.writeInt(1);
                        tvInputInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void removeTvInput(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

