/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.media.AudioAttributes;
import android.media.MediaDescription;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.VolumeProvider;
import android.media.session.ISession;
import android.media.session.ISessionCallback;
import android.media.session.ISessionController;
import android.media.session.MediaController;
import android.media.session.MediaSessionManager;
import android.media.session.PlaybackState;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import java.lang.ref.WeakReference;
import java.util.List;

public final class MediaSession {
    public static final int FLAG_EXCLUSIVE_GLOBAL_PRIORITY = 65536;
    public static final int FLAG_HANDLES_MEDIA_BUTTONS = 1;
    public static final int FLAG_HANDLES_TRANSPORT_CONTROLS = 2;
    private static final String TAG = "MediaSession";
    private boolean mActive = false;
    private final ISession mBinder;
    private CallbackMessageHandler mCallback;
    private final CallbackStub mCbStub;
    private final MediaController mController;
    private final Object mLock = new Object();
    private PlaybackState mPlaybackState;
    private final Token mSessionToken;
    private VolumeProvider mVolumeProvider;

    public MediaSession(Context context, String string2) {
        this(context, string2, UserHandle.myUserId());
    }

    public MediaSession(Context context, String string2, int n) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null.");
        }
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException("tag cannot be null or empty");
        }
        this.mCbStub = new CallbackStub(this);
        MediaSessionManager mediaSessionManager = (MediaSessionManager)context.getSystemService("media_session");
        try {
            this.mBinder = mediaSessionManager.createSession(this.mCbStub, string2, n);
            this.mSessionToken = new Token(this.mBinder.getController());
            this.mController = new MediaController(context, this.mSessionToken);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Remote error creating session.", remoteException);
        }
    }

    private void dispatchCustomAction(String string2, Bundle bundle) {
        this.postToCallback(13, string2, bundle);
    }

    private void dispatchFastForward() {
        this.postToCallback(9);
    }

    private void dispatchMediaButton(Intent intent) {
        this.postToCallback(14, intent);
    }

    private void dispatchNext() {
        this.postToCallback(7);
    }

    private void dispatchPause() {
        this.postToCallback(5);
    }

    private void dispatchPlay() {
        this.postToCallback(1);
    }

    private void dispatchPlayFromMediaId(String string2, Bundle bundle) {
        this.postToCallback(2, string2, bundle);
    }

    private void dispatchPlayFromSearch(String string2, Bundle bundle) {
        this.postToCallback(3, string2, bundle);
    }

    private void dispatchPrevious() {
        this.postToCallback(8);
    }

    private void dispatchRate(Rating rating) {
        this.postToCallback(12, rating);
    }

    private void dispatchRewind() {
        this.postToCallback(10);
    }

    private void dispatchSeekTo(long l) {
        this.postToCallback(11, l);
    }

    private void dispatchSkipToItem(long l) {
        this.postToCallback(4, l);
    }

    private void dispatchStop() {
        this.postToCallback(6);
    }

    public static boolean isActiveState(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
        }
        return true;
    }

    private void postCommand(String string2, Bundle bundle, ResultReceiver resultReceiver) {
        this.postToCallback(15, new Command(string2, bundle, resultReceiver));
    }

    private void postToCallback(int n) {
        this.postToCallback(n, null);
    }

    private void postToCallback(int n, Object object) {
        this.postToCallback(n, object, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void postToCallback(int n, Object object, Bundle bundle) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mCallback != null) {
                this.mCallback.post(n, object, bundle);
            }
            return;
        }
    }

    public MediaController getController() {
        return this.mController;
    }

    public Token getSessionToken() {
        return this.mSessionToken;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public void notifyRemoteVolumeChanged(VolumeProvider volumeProvider) {
        if (volumeProvider == null || volumeProvider != this.mVolumeProvider) {
            Log.w(TAG, "Received update from stale volume provider");
            return;
        }
        try {
            this.mBinder.setCurrentVolume(volumeProvider.getCurrentVolume());
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error in notifyVolumeChanged", remoteException);
            return;
        }
    }

    public void release() {
        try {
            this.mBinder.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Error releasing session: ", remoteException);
            return;
        }
    }

    public void sendSessionEvent(String string2, Bundle bundle) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException("event cannot be null or empty");
        }
        try {
            this.mBinder.sendEvent(string2, bundle);
            return;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Error sending event", remoteException);
            return;
        }
    }

    public void setActive(boolean bl) {
        if (this.mActive == bl) {
            return;
        }
        try {
            this.mBinder.setActive(bl);
            this.mActive = bl;
            return;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Failure in setActive.", remoteException);
            return;
        }
    }

    public void setCallback(Callback callback) {
        this.setCallback(callback, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCallback(Callback callback, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            if (callback == null) {
                if (this.mCallback != null) {
                    Callback.access$102(this.mCallback.mCallback, null);
                }
                this.mCallback = null;
                return;
            }
            if (this.mCallback != null) {
                Callback.access$102(this.mCallback.mCallback, null);
            }
            if (handler == null) {
                handler = new Handler();
            }
            Callback.access$102(callback, this);
            this.mCallback = new CallbackMessageHandler(handler.getLooper(), callback);
            return;
        }
    }

    public void setExtras(Bundle bundle) {
        try {
            this.mBinder.setExtras(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            Log.wtf("Dead object in setExtras.", remoteException);
            return;
        }
    }

    public void setFlags(int n) {
        try {
            this.mBinder.setFlags(n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Failure in setFlags.", remoteException);
            return;
        }
    }

    public void setMediaButtonReceiver(PendingIntent pendingIntent) {
        try {
            this.mBinder.setMediaButtonReceiver(pendingIntent);
            return;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Failure in setMediaButtonReceiver.", remoteException);
            return;
        }
    }

    public void setMetadata(MediaMetadata mediaMetadata) {
        try {
            this.mBinder.setMetadata(mediaMetadata);
            return;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Dead object in setPlaybackState.", remoteException);
            return;
        }
    }

    public void setPlaybackState(PlaybackState playbackState) {
        this.mPlaybackState = playbackState;
        try {
            this.mBinder.setPlaybackState(playbackState);
            return;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Dead object in setPlaybackState.", remoteException);
            return;
        }
    }

    public void setPlaybackToLocal(AudioAttributes audioAttributes) {
        if (audioAttributes == null) {
            throw new IllegalArgumentException("Attributes cannot be null for local playback.");
        }
        try {
            this.mBinder.setPlaybackToLocal(audioAttributes);
            return;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Failure in setPlaybackToLocal.", remoteException);
            return;
        }
    }

    public void setPlaybackToRemote(VolumeProvider volumeProvider) {
        if (volumeProvider == null) {
            throw new IllegalArgumentException("volumeProvider may not be null!");
        }
        this.mVolumeProvider = volumeProvider;
        volumeProvider.setCallback(new VolumeProvider.Callback(){

            @Override
            public void onVolumeChanged(VolumeProvider volumeProvider) {
                MediaSession.this.notifyRemoteVolumeChanged(volumeProvider);
            }
        });
        try {
            this.mBinder.setPlaybackToRemote(volumeProvider.getVolumeControl(), volumeProvider.getMaxVolume());
            this.mBinder.setCurrentVolume(volumeProvider.getCurrentVolume());
            return;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Failure in setPlaybackToRemote.", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setQueue(List<QueueItem> list) {
        try {
            ISession iSession = this.mBinder;
            ParceledListSlice<QueueItem> parceledListSlice = list == null ? null : new ParceledListSlice<QueueItem>(list);
            iSession.setQueue(parceledListSlice);
            return;
        }
        catch (RemoteException remoteException) {
            Log.wtf("Dead object in setQueue.", remoteException);
            return;
        }
    }

    public void setQueueTitle(CharSequence charSequence) {
        try {
            this.mBinder.setQueueTitle(charSequence);
            return;
        }
        catch (RemoteException remoteException) {
            Log.wtf("Dead object in setQueueTitle.", remoteException);
            return;
        }
    }

    public void setSessionActivity(PendingIntent pendingIntent) {
        try {
            this.mBinder.setLaunchPendingIntent(pendingIntent);
            return;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Failure in setLaunchPendingIntent.", remoteException);
            return;
        }
    }

    public static abstract class Callback {
        private MediaSession mSession;

        static /* synthetic */ MediaSession access$102(Callback callback, MediaSession mediaSession) {
            callback.mSession = mediaSession;
            return mediaSession;
        }

        public void onCommand(String string2, Bundle bundle, ResultReceiver resultReceiver) {
        }

        public void onCustomAction(String string2, Bundle bundle) {
        }

        public void onFastForward() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean onMediaButtonEvent(Intent intent) {
            KeyEvent keyEvent;
            if (this.mSession == null || !"android.intent.action.MEDIA_BUTTON".equals(intent.getAction()) || (keyEvent = (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT")) == null || keyEvent.getAction() != 0) return false;
            PlaybackState playbackState = this.mSession.mPlaybackState;
            long l = playbackState == null ? 0L : playbackState.getActions();
            switch (keyEvent.getKeyCode()) {
                case 126: {
                    if ((4L & l) == 0L) return false;
                    this.onPlay();
                    return true;
                }
                case 127: {
                    if ((2L & l) == 0L) return false;
                    this.onPause();
                    return true;
                }
                case 87: {
                    if ((0x20L & l) == 0L) return false;
                    this.onSkipToNext();
                    return true;
                }
                case 88: {
                    if ((0x10L & l) == 0L) return false;
                    this.onSkipToPrevious();
                    return true;
                }
                case 86: {
                    if ((1L & l) == 0L) return false;
                    this.onStop();
                    return true;
                }
                case 90: {
                    if ((0x40L & l) == 0L) return false;
                    this.onFastForward();
                    return true;
                }
                case 89: {
                    if ((8L & l) == 0L) return false;
                    this.onRewind();
                    return true;
                }
                default: {
                    return false;
                }
                case 79: 
                case 85: 
            }
            boolean bl = playbackState == null ? false : playbackState.getState() == 3;
            boolean bl2 = (0x204L & l) != 0L;
            boolean bl3 = (0x202L & l) != 0L;
            if (bl && bl3) {
                this.onPause();
                return true;
            }
            if (bl || !bl2) return false;
            this.onPlay();
            return true;
        }

        public void onPause() {
        }

        public void onPlay() {
        }

        public void onPlayFromMediaId(String string2, Bundle bundle) {
        }

        public void onPlayFromSearch(String string2, Bundle bundle) {
        }

        public void onRewind() {
        }

        public void onSeekTo(long l) {
        }

        public void onSetRating(Rating rating) {
        }

        public void onSkipToNext() {
        }

        public void onSkipToPrevious() {
        }

        public void onSkipToQueueItem(long l) {
        }

        public void onStop() {
        }
    }

    private class CallbackMessageHandler
    extends Handler {
        private static final int MSG_COMMAND = 15;
        private static final int MSG_CUSTOM_ACTION = 13;
        private static final int MSG_FAST_FORWARD = 9;
        private static final int MSG_MEDIA_BUTTON = 14;
        private static final int MSG_NEXT = 7;
        private static final int MSG_PAUSE = 5;
        private static final int MSG_PLAY = 1;
        private static final int MSG_PLAY_MEDIA_ID = 2;
        private static final int MSG_PLAY_SEARCH = 3;
        private static final int MSG_PREVIOUS = 8;
        private static final int MSG_RATE = 12;
        private static final int MSG_REWIND = 10;
        private static final int MSG_SEEK_TO = 11;
        private static final int MSG_SKIP_TO_ITEM = 4;
        private static final int MSG_STOP = 6;
        private Callback mCallback;

        public CallbackMessageHandler(Looper looper, Callback callback) {
            super(looper, null, true);
            this.mCallback = callback;
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    this.mCallback.onPlay();
                    return;
                }
                case 2: {
                    this.mCallback.onPlayFromMediaId((String)message.obj, message.getData());
                    return;
                }
                case 3: {
                    this.mCallback.onPlayFromSearch((String)message.obj, message.getData());
                    return;
                }
                case 4: {
                    this.mCallback.onSkipToQueueItem((Long)message.obj);
                    return;
                }
                case 5: {
                    this.mCallback.onPause();
                    return;
                }
                case 6: {
                    this.mCallback.onStop();
                    return;
                }
                case 7: {
                    this.mCallback.onSkipToNext();
                    return;
                }
                case 8: {
                    this.mCallback.onSkipToPrevious();
                    return;
                }
                case 9: {
                    this.mCallback.onFastForward();
                    return;
                }
                case 10: {
                    this.mCallback.onRewind();
                    return;
                }
                case 11: {
                    this.mCallback.onSeekTo((Long)message.obj);
                    return;
                }
                case 12: {
                    this.mCallback.onSetRating((Rating)message.obj);
                    return;
                }
                case 13: {
                    this.mCallback.onCustomAction((String)message.obj, message.getData());
                    return;
                }
                case 14: {
                    this.mCallback.onMediaButtonEvent((Intent)message.obj);
                    return;
                }
                case 15: 
            }
            Command command = (Command)message.obj;
            this.mCallback.onCommand(command.command, command.extras, command.stub);
        }

        public void post(int n) {
            this.post(n, null);
        }

        public void post(int n, Object object) {
            this.obtainMessage(n, object).sendToTarget();
        }

        public void post(int n, Object object, int n2) {
            this.obtainMessage(n, n2, 0, object).sendToTarget();
        }

        public void post(int n, Object object, Bundle bundle) {
            Message message = this.obtainMessage(n, object);
            message.setData(bundle);
            message.sendToTarget();
        }
    }

    public static class CallbackStub
    extends ISessionCallback.Stub {
        private WeakReference<MediaSession> mMediaSession;

        public CallbackStub(MediaSession mediaSession) {
            this.mMediaSession = new WeakReference<MediaSession>(mediaSession);
        }

        @Override
        public void onAdjustVolume(int n) {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null && mediaSession.mVolumeProvider != null) {
                mediaSession.mVolumeProvider.onAdjustVolume(n);
            }
        }

        @Override
        public void onCommand(String string2, Bundle bundle, ResultReceiver resultReceiver) {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null) {
                mediaSession.postCommand(string2, bundle, resultReceiver);
            }
        }

        @Override
        public void onCustomAction(String string2, Bundle bundle) {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null) {
                mediaSession.dispatchCustomAction(string2, bundle);
            }
        }

        @Override
        public void onFastForward() {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null) {
                mediaSession.dispatchFastForward();
            }
        }

        @Override
        public void onMediaButton(Intent intent, int n, ResultReceiver resultReceiver) {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null) {
                mediaSession.dispatchMediaButton(intent);
            }
            return;
            finally {
                if (resultReceiver != null) {
                    resultReceiver.send(n, null);
                }
            }
        }

        @Override
        public void onNext() {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null) {
                mediaSession.dispatchNext();
            }
        }

        @Override
        public void onPause() {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null) {
                mediaSession.dispatchPause();
            }
        }

        @Override
        public void onPlay() {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null) {
                mediaSession.dispatchPlay();
            }
        }

        @Override
        public void onPlayFromMediaId(String string2, Bundle bundle) {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null) {
                mediaSession.dispatchPlayFromMediaId(string2, bundle);
            }
        }

        @Override
        public void onPlayFromSearch(String string2, Bundle bundle) {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null) {
                mediaSession.dispatchPlayFromSearch(string2, bundle);
            }
        }

        @Override
        public void onPrevious() {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null) {
                mediaSession.dispatchPrevious();
            }
        }

        @Override
        public void onRate(Rating rating) {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null) {
                mediaSession.dispatchRate(rating);
            }
        }

        @Override
        public void onRewind() {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null) {
                mediaSession.dispatchRewind();
            }
        }

        @Override
        public void onSeekTo(long l) {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null) {
                mediaSession.dispatchSeekTo(l);
            }
        }

        @Override
        public void onSetVolumeTo(int n) {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null && mediaSession.mVolumeProvider != null) {
                mediaSession.mVolumeProvider.onSetVolumeTo(n);
            }
        }

        @Override
        public void onSkipToTrack(long l) {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null) {
                mediaSession.dispatchSkipToItem(l);
            }
        }

        @Override
        public void onStop() {
            MediaSession mediaSession = (MediaSession)this.mMediaSession.get();
            if (mediaSession != null) {
                mediaSession.dispatchStop();
            }
        }
    }

    private static final class Command {
        public final String command;
        public final Bundle extras;
        public final ResultReceiver stub;

        public Command(String string2, Bundle bundle, ResultReceiver resultReceiver) {
            this.command = string2;
            this.extras = bundle;
            this.stub = resultReceiver;
        }
    }

    public static final class QueueItem
    implements Parcelable {
        public static final Parcelable.Creator<QueueItem> CREATOR = new Parcelable.Creator<QueueItem>(){

            @Override
            public QueueItem createFromParcel(Parcel parcel) {
                return new QueueItem(parcel);
            }

            public QueueItem[] newArray(int n) {
                return new QueueItem[n];
            }
        };
        public static final int UNKNOWN_ID = -1;
        private final MediaDescription mDescription;
        private final long mId;

        public QueueItem(MediaDescription mediaDescription, long l) {
            if (mediaDescription == null) {
                throw new IllegalArgumentException("Description cannot be null.");
            }
            if (l == -1L) {
                throw new IllegalArgumentException("Id cannot be QueueItem.UNKNOWN_ID");
            }
            this.mDescription = mediaDescription;
            this.mId = l;
        }

        private QueueItem(Parcel parcel) {
            this.mDescription = MediaDescription.CREATOR.createFromParcel(parcel);
            this.mId = parcel.readLong();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public MediaDescription getDescription() {
            return this.mDescription;
        }

        public long getQueueId() {
            return this.mId;
        }

        public String toString() {
            return "MediaSession.QueueItem {Description=" + this.mDescription + ", Id=" + this.mId + " }";
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            this.mDescription.writeToParcel(parcel, n);
            parcel.writeLong(this.mId);
        }
    }

    public static final class Token
    implements Parcelable {
        public static final Parcelable.Creator<Token> CREATOR = new Parcelable.Creator<Token>(){

            @Override
            public Token createFromParcel(Parcel parcel) {
                return new Token(ISessionController.Stub.asInterface(parcel.readStrongBinder()));
            }

            public Token[] newArray(int n) {
                return new Token[n];
            }
        };
        private ISessionController mBinder;

        public Token(ISessionController iSessionController) {
            this.mBinder = iSessionController;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            if (this == object) return true;
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Token token = (Token)object;
            if (this.mBinder == null) {
                if (token.mBinder == null) return true;
                return false;
            }
            if (!this.mBinder.asBinder().equals(token.mBinder.asBinder())) return false;
            return true;
        }

        ISessionController getBinder() {
            return this.mBinder;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int hashCode() {
            if (this.mBinder == null) {
                return 31;
            }
            int n = this.mBinder.asBinder().hashCode();
            return n + 31;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeStrongBinder(this.mBinder.asBinder());
        }
    }
}

