/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.content.Context;
import android.content.Intent;
import android.media.projection.IMediaProjection;
import android.media.projection.IMediaProjectionManager;
import android.media.projection.IMediaProjectionWatcherCallback;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionInfo;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import java.util.Map;

public final class MediaProjectionManager {
    public static final String EXTRA_APP_TOKEN = "android.media.projection.extra.EXTRA_APP_TOKEN";
    public static final String EXTRA_MEDIA_PROJECTION = "android.media.projection.extra.EXTRA_MEDIA_PROJECTION";
    private static final String TAG = "MediaProjectionManager";
    public static final int TYPE_MIRRORING = 1;
    public static final int TYPE_PRESENTATION = 2;
    public static final int TYPE_SCREEN_CAPTURE;
    private Map<Callback, CallbackDelegate> mCallbacks;
    private Context mContext;
    private IMediaProjectionManager mService;

    public MediaProjectionManager(Context context) {
        this.mContext = context;
        this.mService = IMediaProjectionManager.Stub.asInterface(ServiceManager.getService("media_projection"));
        this.mCallbacks = new ArrayMap<Callback, CallbackDelegate>();
    }

    public void addCallback(Callback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        CallbackDelegate callbackDelegate = new CallbackDelegate(callback, handler);
        this.mCallbacks.put(callback, callbackDelegate);
        try {
            this.mService.addCallback(callbackDelegate);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Unable to add callbacks to MediaProjection service", remoteException);
            return;
        }
    }

    public Intent createScreenCaptureIntent() {
        Intent intent = new Intent();
        intent.setClassName("com.android.systemui", "com.android.systemui.media.MediaProjectionPermissionActivity");
        return intent;
    }

    public MediaProjectionInfo getActiveProjectionInfo() {
        try {
            MediaProjectionInfo mediaProjectionInfo = this.mService.getActiveProjectionInfo();
            return mediaProjectionInfo;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Unable to get the active projection info", remoteException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public MediaProjection getMediaProjection(int n, Intent intent) {
        IBinder iBinder;
        if (n != -1 || intent == null || (iBinder = intent.getIBinderExtra(EXTRA_MEDIA_PROJECTION)) == null) {
            return null;
        }
        return new MediaProjection(this.mContext, IMediaProjection.Stub.asInterface(iBinder));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeCallback(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        CallbackDelegate callbackDelegate = this.mCallbacks.remove(callback);
        if (callbackDelegate == null) return;
        try {
            this.mService.removeCallback(callbackDelegate);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Unable to add callbacks to MediaProjection service", remoteException);
            return;
        }
    }

    public void stopActiveProjection() {
        try {
            this.mService.stopActiveProjection();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Unable to stop the currently active media projection", remoteException);
            return;
        }
    }

    public static abstract class Callback {
        public abstract void onStart(MediaProjectionInfo var1);

        public abstract void onStop(MediaProjectionInfo var1);
    }

    private static final class CallbackDelegate
    extends IMediaProjectionWatcherCallback.Stub {
        private Callback mCallback;
        private Handler mHandler;

        public CallbackDelegate(Callback callback, Handler handler) {
            this.mCallback = callback;
            if (handler == null) {
                handler = new Handler();
            }
            this.mHandler = handler;
        }

        @Override
        public void onStart(final MediaProjectionInfo mediaProjectionInfo) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    CallbackDelegate.this.mCallback.onStart(mediaProjectionInfo);
                }
            });
        }

        @Override
        public void onStop(final MediaProjectionInfo mediaProjectionInfo) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    CallbackDelegate.this.mCallback.onStop(mediaProjectionInfo);
                }
            });
        }
    }
}

