/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.content.Context;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.media.AudioRecord;
import android.media.projection.IMediaProjection;
import android.media.projection.IMediaProjectionCallback;
import android.os.Handler;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import android.view.Surface;
import java.util.Map;

public final class MediaProjection {
    private static final String TAG = "MediaProjection";
    private final Map<Callback, CallbackRecord> mCallbacks = new ArrayMap<Callback, CallbackRecord>();
    private final Context mContext;
    private final IMediaProjection mImpl;

    public MediaProjection(Context context, IMediaProjection iMediaProjection) {
        this.mContext = context;
        this.mImpl = iMediaProjection;
        try {
            this.mImpl.start(new MediaProjectionCallback());
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Failed to start media projection", remoteException);
        }
    }

    public AudioRecord createAudioRecord(int n, int n2, int n3, int n4) {
        return null;
    }

    public VirtualDisplay createVirtualDisplay(String string2, int n, int n2, int n3, int n4, Surface surface, VirtualDisplay.Callback callback, Handler handler) {
        return ((DisplayManager)this.mContext.getSystemService("display")).createVirtualDisplay(this, string2, n, n2, n3, surface, n4, callback, handler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VirtualDisplay createVirtualDisplay(String string2, int n, int n2, int n3, boolean bl, Surface surface, VirtualDisplay.Callback callback, Handler handler) {
        int n4;
        DisplayManager displayManager = (DisplayManager)this.mContext.getSystemService("display");
        if (bl) {
            n4 = 4;
            return displayManager.createVirtualDisplay(this, string2, n, n2, n3, surface, 2 | (n4 | 0x10), callback, handler);
        }
        n4 = 0;
        return displayManager.createVirtualDisplay(this, string2, n, n2, n3, surface, 2 | (n4 | 0x10), callback, handler);
    }

    public IMediaProjection getProjection() {
        return this.mImpl;
    }

    public void registerCallback(Callback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("callback should not be null");
        }
        this.mCallbacks.put(callback, new CallbackRecord(callback, handler));
    }

    public void stop() {
        try {
            this.mImpl.stop();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Unable to stop projection", remoteException);
            return;
        }
    }

    public void unregisterCallback(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback should not be null");
        }
        this.mCallbacks.remove(callback);
    }

    public static abstract class Callback {
        public void onStop() {
        }
    }

    private static final class CallbackRecord {
        private Callback mCallback;
        private Handler mHandler;

        public CallbackRecord(Callback callback, Handler handler) {
            this.mCallback = callback;
            this.mHandler = handler;
        }

        public void onStop() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    CallbackRecord.this.mCallback.onStop();
                }
            });
        }
    }

    private final class MediaProjectionCallback
    extends IMediaProjectionCallback.Stub {
        private MediaProjectionCallback() {
        }

        @Override
        public void onStop() {
            int n = MediaProjection.this.mCallbacks.size();
            for (int i = 0; i < n; ++i) {
                ((CallbackRecord)MediaProjection.this.mCallbacks.get(i)).onStop();
            }
        }
    }
}

