/*
 * Decompiled with CFR 0.152.
 */
package android.media.effect.effects;

import android.filterfw.core.OneShotScheduler;
import android.filterpacks.videoproc.BackDropperFilter;
import android.media.effect.EffectContext;
import android.media.effect.EffectUpdateListener;
import android.media.effect.FilterGraphEffect;

public class BackDropperEffect
extends FilterGraphEffect {
    private static final String mGraphDefinition = "@import android.filterpacks.base;\n@import android.filterpacks.videoproc;\n@import android.filterpacks.videosrc;\n\n@filter GLTextureSource foreground {\n  texId = 0;\n  width = 0;\n  height = 0;\n  repeatFrame = true;\n}\n\n@filter MediaSource background {\n  sourceUrl = \"no_file_specified\";\n  waitForNewFrame = false;\n  sourceIsUrl = true;\n}\n\n@filter BackDropperFilter replacer {\n  autowbToggle = 1;\n}\n\n@filter GLTextureTarget output {\n  texId = 0;\n}\n\n@connect foreground[frame]  => replacer[video];\n@connect background[video]  => replacer[background];\n@connect replacer[video]    => output[frame];\n";
    private EffectUpdateListener mEffectListener = null;
    private BackDropperFilter.LearningDoneListener mLearningListener = new BackDropperFilter.LearningDoneListener(){

        @Override
        public void onLearningDone(BackDropperFilter backDropperFilter) {
            if (BackDropperEffect.this.mEffectListener != null) {
                BackDropperEffect.this.mEffectListener.onEffectUpdated(BackDropperEffect.this, null);
            }
        }
    };

    public BackDropperEffect(EffectContext effectContext, String string2) {
        super(effectContext, string2, mGraphDefinition, "foreground", "output", OneShotScheduler.class);
        this.mGraph.getFilter("replacer").setInputValue("learningDoneListener", this.mLearningListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setParameter(String string2, Object object) {
        if (string2.equals("source")) {
            this.mGraph.getFilter("background").setInputValue("sourceUrl", object);
            return;
        } else {
            if (!string2.equals("context")) return;
            this.mGraph.getFilter("background").setInputValue("context", object);
            return;
        }
    }

    @Override
    public void setUpdateListener(EffectUpdateListener effectUpdateListener) {
        this.mEffectListener = effectUpdateListener;
    }
}

