/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import java.util.StringTokenizer;

public class EnvironmentalReverb
extends AudioEffect {
    public static final int PARAM_DECAY_HF_RATIO = 3;
    public static final int PARAM_DECAY_TIME = 2;
    public static final int PARAM_DENSITY = 9;
    public static final int PARAM_DIFFUSION = 8;
    private static final int PARAM_PROPERTIES = 10;
    public static final int PARAM_REFLECTIONS_DELAY = 5;
    public static final int PARAM_REFLECTIONS_LEVEL = 4;
    public static final int PARAM_REVERB_DELAY = 7;
    public static final int PARAM_REVERB_LEVEL = 6;
    public static final int PARAM_ROOM_HF_LEVEL = 1;
    public static final int PARAM_ROOM_LEVEL = 0;
    private static int PROPERTY_SIZE = 0;
    private static final String TAG = "EnvironmentalReverb";
    private BaseParameterListener mBaseParamListener = null;
    private OnParameterChangeListener mParamListener = null;
    private final Object mParamListenerLock = new Object();

    static {
        PROPERTY_SIZE = 26;
    }

    public EnvironmentalReverb(int n, int n2) throws IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        super(EFFECT_TYPE_ENV_REVERB, EFFECT_TYPE_NULL, n, n2);
    }

    public short getDecayHFRatio() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[2];
        this.checkStatus(this.getParameter(3, byArray));
        return EnvironmentalReverb.byteArrayToShort(byArray);
    }

    public int getDecayTime() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[4];
        this.checkStatus(this.getParameter(2, byArray));
        return EnvironmentalReverb.byteArrayToInt(byArray);
    }

    public short getDensity() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[2];
        this.checkStatus(this.getParameter(9, byArray));
        return EnvironmentalReverb.byteArrayToShort(byArray);
    }

    public short getDiffusion() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[2];
        this.checkStatus(this.getParameter(8, byArray));
        return EnvironmentalReverb.byteArrayToShort(byArray);
    }

    public Settings getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[PROPERTY_SIZE];
        this.checkStatus(this.getParameter(10, byArray));
        Settings settings = new Settings();
        settings.roomLevel = EnvironmentalReverb.byteArrayToShort(byArray, 0);
        settings.roomHFLevel = EnvironmentalReverb.byteArrayToShort(byArray, 2);
        settings.decayTime = EnvironmentalReverb.byteArrayToInt(byArray, 4);
        settings.decayHFRatio = EnvironmentalReverb.byteArrayToShort(byArray, 8);
        settings.reflectionsLevel = EnvironmentalReverb.byteArrayToShort(byArray, 10);
        settings.reflectionsDelay = EnvironmentalReverb.byteArrayToInt(byArray, 12);
        settings.reverbLevel = EnvironmentalReverb.byteArrayToShort(byArray, 16);
        settings.reverbDelay = EnvironmentalReverb.byteArrayToInt(byArray, 18);
        settings.diffusion = EnvironmentalReverb.byteArrayToShort(byArray, 22);
        settings.density = EnvironmentalReverb.byteArrayToShort(byArray, 24);
        return settings;
    }

    public int getReflectionsDelay() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[4];
        this.checkStatus(this.getParameter(5, byArray));
        return EnvironmentalReverb.byteArrayToInt(byArray);
    }

    public short getReflectionsLevel() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[2];
        this.checkStatus(this.getParameter(4, byArray));
        return EnvironmentalReverb.byteArrayToShort(byArray);
    }

    public int getReverbDelay() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[4];
        this.checkStatus(this.getParameter(7, byArray));
        return EnvironmentalReverb.byteArrayToInt(byArray);
    }

    public short getReverbLevel() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[2];
        this.checkStatus(this.getParameter(6, byArray));
        return EnvironmentalReverb.byteArrayToShort(byArray);
    }

    public short getRoomHFLevel() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[2];
        this.checkStatus(this.getParameter(1, byArray));
        return EnvironmentalReverb.byteArrayToShort(byArray);
    }

    public short getRoomLevel() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[2];
        this.checkStatus(this.getParameter(0, byArray));
        return EnvironmentalReverb.byteArrayToShort(byArray);
    }

    public void setDecayHFRatio(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(3, EnvironmentalReverb.shortToByteArray(s)));
    }

    public void setDecayTime(int n) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(2, EnvironmentalReverb.intToByteArray(n)));
    }

    public void setDensity(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(9, EnvironmentalReverb.shortToByteArray(s)));
    }

    public void setDiffusion(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(8, EnvironmentalReverb.shortToByteArray(s)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setParameterListener(OnParameterChangeListener onParameterChangeListener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                this.mParamListener = onParameterChangeListener;
                this.mBaseParamListener = new BaseParameterListener();
                super.setParameterListener(this.mBaseParamListener);
            }
            return;
        }
    }

    public void setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[][] byArrayArray = new byte[][]{EnvironmentalReverb.shortToByteArray(settings.roomLevel), EnvironmentalReverb.shortToByteArray(settings.roomHFLevel), EnvironmentalReverb.intToByteArray(settings.decayTime), EnvironmentalReverb.shortToByteArray(settings.decayHFRatio), EnvironmentalReverb.shortToByteArray(settings.reflectionsLevel), EnvironmentalReverb.intToByteArray(settings.reflectionsDelay), EnvironmentalReverb.shortToByteArray(settings.reverbLevel), EnvironmentalReverb.intToByteArray(settings.reverbDelay), EnvironmentalReverb.shortToByteArray(settings.diffusion), EnvironmentalReverb.shortToByteArray(settings.density)};
        this.checkStatus(this.setParameter(10, EnvironmentalReverb.concatArrays(byArrayArray)));
    }

    public void setReflectionsDelay(int n) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(5, EnvironmentalReverb.intToByteArray(n)));
    }

    public void setReflectionsLevel(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(4, EnvironmentalReverb.shortToByteArray(s)));
    }

    public void setReverbDelay(int n) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(7, EnvironmentalReverb.intToByteArray(n)));
    }

    public void setReverbLevel(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(6, EnvironmentalReverb.shortToByteArray(s)));
    }

    public void setRoomHFLevel(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(1, EnvironmentalReverb.shortToByteArray(s)));
    }

    public void setRoomLevel(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(0, EnvironmentalReverb.shortToByteArray(s)));
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener {
        private BaseParameterListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onParameterChange(AudioEffect audioEffect, int n, byte[] byArray, byte[] byArray2) {
            Object object = EnvironmentalReverb.this.mParamListenerLock;
            // MONITORENTER : object
            OnParameterChangeListener onParameterChangeListener = EnvironmentalReverb.this.mParamListener;
            OnParameterChangeListener onParameterChangeListener2 = null;
            if (onParameterChangeListener != null) {
                onParameterChangeListener2 = EnvironmentalReverb.this.mParamListener;
            }
            // MONITOREXIT : object
            if (onParameterChangeListener2 == null) return;
            int n2 = -1;
            int n3 = -1;
            if (byArray.length == 4) {
                n2 = AudioEffect.byteArrayToInt(byArray, 0);
            }
            if (byArray2.length == 2) {
                n3 = AudioEffect.byteArrayToShort(byArray2, 0);
            } else if (byArray2.length == 4) {
                n3 = AudioEffect.byteArrayToInt(byArray2, 0);
            }
            if (n2 == -1) return;
            if (n3 == -1) return;
            onParameterChangeListener2.onParameterChange(EnvironmentalReverb.this, n, n2, n3);
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(EnvironmentalReverb var1, int var2, int var3, int var4);
    }

    public static class Settings {
        public short decayHFRatio;
        public int decayTime;
        public short density;
        public short diffusion;
        public int reflectionsDelay;
        public short reflectionsLevel;
        public int reverbDelay;
        public short reverbLevel;
        public short roomHFLevel;
        public short roomLevel;

        public Settings() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Settings(String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=;");
            stringTokenizer.countTokens();
            if (stringTokenizer.countTokens() != 21) {
                throw new IllegalArgumentException("settings: " + string2);
            }
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals(EnvironmentalReverb.TAG)) {
                throw new IllegalArgumentException("invalid settings for EnvironmentalReverb: " + string3);
            }
            try {
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("roomLevel")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("invalid value for key: " + string3);
            }
            {
                this.roomLevel = Short.parseShort(stringTokenizer.nextToken());
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("roomHFLevel")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
                this.roomHFLevel = Short.parseShort(stringTokenizer.nextToken());
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("decayTime")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
                this.decayTime = Integer.parseInt(stringTokenizer.nextToken());
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("decayHFRatio")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
                this.decayHFRatio = Short.parseShort(stringTokenizer.nextToken());
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("reflectionsLevel")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
                this.reflectionsLevel = Short.parseShort(stringTokenizer.nextToken());
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("reflectionsDelay")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
                this.reflectionsDelay = Integer.parseInt(stringTokenizer.nextToken());
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("reverbLevel")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
                this.reverbLevel = Short.parseShort(stringTokenizer.nextToken());
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("reverbDelay")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
                this.reverbDelay = Integer.parseInt(stringTokenizer.nextToken());
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("diffusion")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
                this.diffusion = Short.parseShort(stringTokenizer.nextToken());
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("density")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
                this.density = Short.parseShort(stringTokenizer.nextToken());
                return;
            }
        }

        public String toString() {
            return new String("EnvironmentalReverb;roomLevel=" + Short.toString(this.roomLevel) + ";roomHFLevel=" + Short.toString(this.roomHFLevel) + ";decayTime=" + Integer.toString(this.decayTime) + ";decayHFRatio=" + Short.toString(this.decayHFRatio) + ";reflectionsLevel=" + Short.toString(this.reflectionsLevel) + ";reflectionsDelay=" + Integer.toString(this.reflectionsDelay) + ";reverbLevel=" + Short.toString(this.reverbLevel) + ";reverbDelay=" + Integer.toString(this.reverbDelay) + ";diffusion=" + Short.toString(this.diffusion) + ";density=" + Short.toString(this.density));
        }
    }
}

