/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import android.util.Log;
import java.util.StringTokenizer;

public class BassBoost
extends AudioEffect {
    public static final int PARAM_STRENGTH = 1;
    public static final int PARAM_STRENGTH_SUPPORTED = 0;
    private static final String TAG = "BassBoost";
    private BaseParameterListener mBaseParamListener;
    private OnParameterChangeListener mParamListener;
    private final Object mParamListenerLock;
    private boolean mStrengthSupported;

    /*
     * Enabled aggressive block sorting
     */
    public BassBoost(int n, int n2) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        int n3 = 1;
        super(EFFECT_TYPE_BASS_BOOST, EFFECT_TYPE_NULL, n, n2);
        this.mStrengthSupported = false;
        this.mParamListener = null;
        this.mBaseParamListener = null;
        this.mParamListenerLock = new Object();
        if (n2 == 0) {
            Log.w(TAG, "WARNING: attaching a BassBoost to global output mix is deprecated!");
        }
        int[] nArray = new int[n3];
        this.checkStatus(this.getParameter(0, nArray));
        if (nArray[0] == 0) {
            n3 = 0;
        }
        this.mStrengthSupported = n3;
    }

    public Settings getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        Settings settings = new Settings();
        short[] sArray = new short[1];
        this.checkStatus(this.getParameter(1, sArray));
        settings.strength = sArray[0];
        return settings;
    }

    public short getRoundedStrength() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] sArray = new short[1];
        this.checkStatus(this.getParameter(1, sArray));
        return sArray[0];
    }

    public boolean getStrengthSupported() {
        return this.mStrengthSupported;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setParameterListener(OnParameterChangeListener onParameterChangeListener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                this.mParamListener = onParameterChangeListener;
                this.mBaseParamListener = new BaseParameterListener();
                super.setParameterListener(this.mBaseParamListener);
            }
            return;
        }
    }

    public void setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(1, settings.strength));
    }

    public void setStrength(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(1, s));
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener {
        private BaseParameterListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onParameterChange(AudioEffect audioEffect, int n, byte[] byArray, byte[] byArray2) {
            Object object = BassBoost.this.mParamListenerLock;
            // MONITORENTER : object
            OnParameterChangeListener onParameterChangeListener = BassBoost.this.mParamListener;
            OnParameterChangeListener onParameterChangeListener2 = null;
            if (onParameterChangeListener != null) {
                onParameterChangeListener2 = BassBoost.this.mParamListener;
            }
            // MONITOREXIT : object
            if (onParameterChangeListener2 == null) return;
            int n2 = -1;
            short s = -1;
            if (byArray.length == 4) {
                n2 = AudioEffect.byteArrayToInt(byArray, 0);
            }
            if (byArray2.length == 2) {
                s = AudioEffect.byteArrayToShort(byArray2, 0);
            }
            if (n2 == -1) return;
            if (s == -1) return;
            onParameterChangeListener2.onParameterChange(BassBoost.this, n, n2, s);
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(BassBoost var1, int var2, int var3, short var4);
    }

    public static class Settings {
        public short strength;

        public Settings() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Settings(String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=;");
            stringTokenizer.countTokens();
            if (stringTokenizer.countTokens() != 3) {
                throw new IllegalArgumentException("settings: " + string2);
            }
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals(BassBoost.TAG)) {
                throw new IllegalArgumentException("invalid settings for BassBoost: " + string3);
            }
            try {
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("strength")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("invalid value for key: " + string3);
            }
            {
                this.strength = Short.parseShort(stringTokenizer.nextToken());
                return;
            }
        }

        public String toString() {
            return new String("BassBoost;strength=" + Short.toString(this.strength));
        }
    }
}

