/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import android.util.Log;

public class AutomaticGainControl
extends AudioEffect {
    private static final String TAG = "AutomaticGainControl";

    private AutomaticGainControl(int n) throws IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        super(EFFECT_TYPE_AGC, EFFECT_TYPE_NULL, 0, n);
    }

    public static AutomaticGainControl create(int n) {
        try {
            AutomaticGainControl automaticGainControl = new AutomaticGainControl(n);
            return automaticGainControl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w(TAG, "not implemented on this device " + null);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.w(TAG, "not enough resources");
        }
        catch (RuntimeException runtimeException) {
            Log.w(TAG, "not enough memory");
        }
        finally {
            return null;
        }
    }

    public static boolean isAvailable() {
        return AudioEffect.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_AGC);
    }
}

