/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaFormat;
import android.media.SubtitleData;
import android.media.SubtitleTrack;
import android.media.TextTrackCue;
import android.media.TextTrackCueSpan;
import android.media.WebVttRenderingWidget;
import android.media.WebVttTrack;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.util.Log;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

class SRTTrack
extends WebVttTrack {
    private static final int KEY_LOCAL_SETTING = 102;
    private static final int KEY_START_TIME = 7;
    private static final int KEY_STRUCT_TEXT = 16;
    private static final int MEDIA_TIMED_TEXT = 99;
    private static final String TAG = "SRTTrack";
    private final Handler mEventHandler;

    SRTTrack(WebVttRenderingWidget webVttRenderingWidget, MediaFormat mediaFormat) {
        super(webVttRenderingWidget, mediaFormat);
        this.mEventHandler = null;
    }

    SRTTrack(Handler handler, MediaFormat mediaFormat) {
        super(null, mediaFormat);
        this.mEventHandler = handler;
    }

    private static long parseMs(String string2) {
        long l = Long.parseLong(string2.split(":")[0].trim());
        long l2 = Long.parseLong(string2.split(":")[1].trim());
        long l3 = Long.parseLong(string2.split(":")[2].split(",")[0].trim());
        return Long.parseLong(string2.split(":")[2].split(",")[1].trim()) + (1000L * (60L * (60L * l)) + 1000L * (60L * l2) + 1000L * l3);
    }

    @Override
    protected void onData(SubtitleData subtitleData) {
        TextTrackCue textTrackCue = new TextTrackCue();
        textTrackCue.mStartTimeMs = subtitleData.getStartTimeUs() / 1000L;
        textTrackCue.mEndTimeMs = (subtitleData.getStartTimeUs() + subtitleData.getDurationUs()) / 1000L;
        String[] stringArray = new String(subtitleData.getData(), "UTF-8").split("\\r?\\n");
        textTrackCue.mLines = new TextTrackCueSpan[stringArray.length][];
        int n = stringArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            TextTrackCueSpan[] textTrackCueSpanArray = new TextTrackCueSpan[]{new TextTrackCueSpan(string2, -1L)};
            TextTrackCueSpan[][] textTrackCueSpanArray2 = textTrackCue.mLines;
            int n3 = n2 + 1;
            textTrackCueSpanArray2[n2] = textTrackCueSpanArray;
            n2 = n3;
            continue;
        }
        try {
            this.addCue(textTrackCue);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.w(TAG, "subtitle data is not UTF-8 encoded: " + unsupportedEncodingException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onData(byte[] byArray, boolean bl, long l) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)byteArrayInputStream, "UTF-8"));
            while (bufferedReader.readLine() != null) {
                String string2;
                String string3 = bufferedReader.readLine();
                if (string3 == null) {
                    return;
                }
                TextTrackCue textTrackCue = new TextTrackCue();
                String[] stringArray = string3.split("-->");
                textTrackCue.mStartTimeMs = SRTTrack.parseMs(stringArray[0]);
                textTrackCue.mEndTimeMs = SRTTrack.parseMs(stringArray[1]);
                ArrayList<String> arrayList = new ArrayList<String>();
                while ((string2 = bufferedReader.readLine()) != null && !string2.trim().equals("")) {
                    arrayList.add(string2);
                }
                textTrackCue.mLines = new TextTrackCueSpan[arrayList.size()][];
                textTrackCue.mStrings = arrayList.toArray(new String[0]);
                Iterator iterator = arrayList.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    TextTrackCueSpan textTrackCueSpan = new TextTrackCueSpan(string4, -1L);
                    TextTrackCueSpan[] textTrackCueSpanArray = new TextTrackCueSpan[]{textTrackCueSpan};
                    textTrackCue.mStrings[n] = string4;
                    TextTrackCueSpan[][] textTrackCueSpanArray2 = textTrackCue.mLines;
                    int n2 = n + 1;
                    textTrackCueSpanArray2[n] = textTrackCueSpanArray;
                    n = n2;
                }
                this.addCue(textTrackCue);
            }
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.w(TAG, "subtitle data is not UTF-8 encoded: " + unsupportedEncodingException);
            return;
        }
        catch (IOException iOException) {
            Log.e(TAG, iOException.getMessage(), iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateView(Vector<SubtitleTrack.Cue> vector) {
        if (this.getRenderingWidget() != null) {
            super.updateView(vector);
            return;
        }
        if (this.mEventHandler == null) {
            return;
        }
        Iterator iterator = vector.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                vector.clear();
                return;
            }
            SubtitleTrack.Cue cue = (SubtitleTrack.Cue)iterator.next();
            TextTrackCue textTrackCue = (TextTrackCue)cue;
            Parcel parcel = Parcel.obtain();
            parcel.writeInt(102);
            parcel.writeInt(7);
            parcel.writeInt((int)cue.mStartTimeMs);
            parcel.writeInt(16);
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = textTrackCue.mStrings;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(stringArray[i]).append('\n');
            }
            byte[] byArray = stringBuilder.toString().getBytes();
            parcel.writeInt(byArray.length);
            parcel.writeByteArray(byArray);
            Message message = this.mEventHandler.obtainMessage(99, 0, 0, parcel);
            this.mEventHandler.sendMessage(message);
        }
    }
}

