/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Handler;
import android.view.Surface;
import dalvik.system.CloseGuard;

public final class RemoteDisplay {
    public static final int DISPLAY_ERROR_CONNECTION_DROPPED = 2;
    public static final int DISPLAY_ERROR_UNKOWN = 1;
    public static final int DISPLAY_FLAG_SECURE = 1;
    private final CloseGuard mGuard = CloseGuard.get();
    private final Handler mHandler;
    private final Listener mListener;
    private long mPtr;

    private RemoteDisplay(Listener listener, Handler handler) {
        this.mListener = listener;
        this.mHandler = handler;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dispose(boolean bl) {
        if (this.mPtr != 0L) {
            if (this.mGuard != null) {
                if (bl) {
                    this.mGuard.warnIfOpen();
                } else {
                    this.mGuard.close();
                }
            }
            this.nativeDispose(this.mPtr);
            this.mPtr = 0L;
        }
    }

    public static RemoteDisplay listen(String string2, Listener listener, Handler handler) {
        if (string2 == null) {
            throw new IllegalArgumentException("iface must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        RemoteDisplay remoteDisplay = new RemoteDisplay(listener, handler);
        remoteDisplay.startListening(string2);
        return remoteDisplay;
    }

    private native void nativeDispose(long var1);

    private native long nativeListen(String var1);

    private native void nativePause(long var1);

    private native void nativeResume(long var1);

    private void notifyDisplayConnected(final Surface surface, final int n, final int n2, final int n3, final int n4) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                RemoteDisplay.this.mListener.onDisplayConnected(surface, n, n2, n3, n4);
            }
        });
    }

    private void notifyDisplayDisconnected() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                RemoteDisplay.this.mListener.onDisplayDisconnected();
            }
        });
    }

    private void notifyDisplayError(final int n) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                RemoteDisplay.this.mListener.onDisplayError(n);
            }
        });
    }

    private void startListening(String string2) {
        this.mPtr = this.nativeListen(string2);
        if (this.mPtr == 0L) {
            throw new IllegalStateException("Could not start listening for remote display connection on \"" + string2 + "\"");
        }
        this.mGuard.open("dispose");
    }

    public void dispose() {
        this.dispose(false);
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public void pause() {
        this.nativePause(this.mPtr);
    }

    public void resume() {
        this.nativeResume(this.mPtr);
    }

    public static interface Listener {
        public void onDisplayConnected(Surface var1, int var2, int var3, int var4, int var5);

        public void onDisplayDisconnected();

        public void onDisplayError(int var1);
    }
}

