/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;

public final class MediaRouterClientState
implements Parcelable {
    public static final Parcelable.Creator<MediaRouterClientState> CREATOR = new Parcelable.Creator<MediaRouterClientState>(){

        @Override
        public MediaRouterClientState createFromParcel(Parcel parcel) {
            return new MediaRouterClientState(parcel);
        }

        public MediaRouterClientState[] newArray(int n) {
            return new MediaRouterClientState[n];
        }
    };
    public String globallySelectedRouteId;
    public final ArrayList<RouteInfo> routes;

    public MediaRouterClientState() {
        this.routes = new ArrayList();
    }

    MediaRouterClientState(Parcel parcel) {
        this.routes = parcel.createTypedArrayList(RouteInfo.CREATOR);
        this.globallySelectedRouteId = parcel.readString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public RouteInfo getRoute(String string2) {
        int n = this.routes.size();
        for (int i = 0; i < n; ++i) {
            RouteInfo routeInfo = this.routes.get(i);
            if (!routeInfo.id.equals(string2)) continue;
            return routeInfo;
        }
        return null;
    }

    public String toString() {
        return "MediaRouterClientState{ globallySelectedRouteId=" + this.globallySelectedRouteId + ", routes=" + this.routes.toString() + " }";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeTypedList(this.routes);
        parcel.writeString(this.globallySelectedRouteId);
    }

    public static final class RouteInfo
    implements Parcelable {
        public static final Parcelable.Creator<RouteInfo> CREATOR = new Parcelable.Creator<RouteInfo>(){

            @Override
            public RouteInfo createFromParcel(Parcel parcel) {
                return new RouteInfo(parcel);
            }

            public RouteInfo[] newArray(int n) {
                return new RouteInfo[n];
            }
        };
        public String description;
        public boolean enabled;
        public String id;
        public String name;
        public int playbackStream;
        public int playbackType;
        public int presentationDisplayId;
        public int statusCode;
        public int supportedTypes;
        public int volume;
        public int volumeHandling;
        public int volumeMax;

        public RouteInfo(RouteInfo routeInfo) {
            this.id = routeInfo.id;
            this.name = routeInfo.name;
            this.description = routeInfo.description;
            this.supportedTypes = routeInfo.supportedTypes;
            this.enabled = routeInfo.enabled;
            this.statusCode = routeInfo.statusCode;
            this.playbackType = routeInfo.playbackType;
            this.playbackStream = routeInfo.playbackStream;
            this.volume = routeInfo.volume;
            this.volumeMax = routeInfo.volumeMax;
            this.volumeHandling = routeInfo.volumeHandling;
            this.presentationDisplayId = routeInfo.presentationDisplayId;
        }

        /*
         * Enabled aggressive block sorting
         */
        RouteInfo(Parcel parcel) {
            this.id = parcel.readString();
            this.name = parcel.readString();
            this.description = parcel.readString();
            this.supportedTypes = parcel.readInt();
            boolean bl = parcel.readInt() != 0;
            this.enabled = bl;
            this.statusCode = parcel.readInt();
            this.playbackType = parcel.readInt();
            this.playbackStream = parcel.readInt();
            this.volume = parcel.readInt();
            this.volumeMax = parcel.readInt();
            this.volumeHandling = parcel.readInt();
            this.presentationDisplayId = parcel.readInt();
        }

        public RouteInfo(String string2) {
            this.id = string2;
            this.enabled = true;
            this.statusCode = 0;
            this.playbackType = 1;
            this.playbackStream = -1;
            this.volumeHandling = 0;
            this.presentationDisplayId = -1;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "RouteInfo{ id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", supportedTypes=0x" + Integer.toHexString(this.supportedTypes) + ", enabled=" + this.enabled + ", statusCode=" + this.statusCode + ", playbackType=" + this.playbackType + ", playbackStream=" + this.playbackStream + ", volume=" + this.volume + ", volumeMax=" + this.volumeMax + ", volumeHandling=" + this.volumeHandling + ", presentationDisplayId=" + this.presentationDisplayId + " }";
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.id);
            parcel.writeString(this.name);
            parcel.writeString(this.description);
            parcel.writeInt(this.supportedTypes);
            int n2 = this.enabled ? 1 : 0;
            parcel.writeInt(n2);
            parcel.writeInt(this.statusCode);
            parcel.writeInt(this.playbackType);
            parcel.writeInt(this.playbackStream);
            parcel.writeInt(this.volume);
            parcel.writeInt(this.volumeMax);
            parcel.writeInt(this.volumeHandling);
            parcel.writeInt(this.presentationDisplayId);
        }
    }
}

