/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentValues;
import android.content.IContentProvider;
import android.net.Uri;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MediaInserter {
    private final int mBufferSizePerUri;
    private final String mPackageName;
    private final HashMap<Uri, List<ContentValues>> mPriorityRowMap;
    private final IContentProvider mProvider;
    private final HashMap<Uri, List<ContentValues>> mRowMap = new HashMap();

    public MediaInserter(IContentProvider iContentProvider, String string2, int n) {
        this.mPriorityRowMap = new HashMap();
        this.mProvider = iContentProvider;
        this.mPackageName = string2;
        this.mBufferSizePerUri = n;
    }

    private void flush(Uri uri, List<ContentValues> list) throws RemoteException {
        if (!list.isEmpty()) {
            ContentValues[] contentValuesArray = list.toArray(new ContentValues[list.size()]);
            this.mProvider.bulkInsert(this.mPackageName, uri, contentValuesArray);
            list.clear();
        }
    }

    private void flushAllPriority() throws RemoteException {
        for (Uri uri : this.mPriorityRowMap.keySet()) {
            this.flush(uri, this.mPriorityRowMap.get(uri));
        }
        this.mPriorityRowMap.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void insert(Uri uri, ContentValues contentValues, boolean bl) throws RemoteException {
        HashMap<Uri, List<ContentValues>> hashMap = bl ? this.mPriorityRowMap : this.mRowMap;
        List<ContentValues> list = hashMap.get(uri);
        if (list == null) {
            list = new ArrayList<ContentValues>();
            hashMap.put(uri, list);
        }
        list.add(new ContentValues(contentValues));
        if (list.size() >= this.mBufferSizePerUri) {
            this.flushAllPriority();
            this.flush(uri, list);
        }
    }

    public void flushAll() throws RemoteException {
        this.flushAllPriority();
        for (Uri uri : this.mRowMap.keySet()) {
            this.flush(uri, this.mRowMap.get(uri));
        }
        this.mRowMap.clear();
    }

    public void insert(Uri uri, ContentValues contentValues) throws RemoteException {
        this.insert(uri, contentValues, false);
    }

    public void insertwithPriority(Uri uri, ContentValues contentValues) throws RemoteException {
        this.insert(uri, contentValues, true);
    }
}

