/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.DataSource;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaHTTPService;
import android.net.Uri;
import android.os.IBinder;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class MediaExtractor {
    public static final int SAMPLE_FLAG_ENCRYPTED = 2;
    public static final int SAMPLE_FLAG_SYNC = 1;
    public static final int SEEK_TO_CLOSEST_SYNC = 2;
    public static final int SEEK_TO_NEXT_SYNC = 1;
    public static final int SEEK_TO_PREVIOUS_SYNC;
    private long mNativeContext;

    static {
        System.loadLibrary("media_jni");
        MediaExtractor.native_init();
    }

    public MediaExtractor() {
        this.native_setup();
    }

    private native Map<String, Object> getFileFormatNative();

    private native Map<String, Object> getTrackFormatNative(int var1);

    private final native void nativeSetDataSource(IBinder var1, String var2, String[] var3, String[] var4) throws IOException;

    private final native void native_finalize();

    private static final native void native_init();

    private final native void native_setup();

    public native boolean advance();

    protected void finalize() {
        this.native_finalize();
    }

    public native long getCachedDuration();

    public Map<UUID, byte[]> getPsshInfo() {
        Map<String, Object> map = this.getFileFormatNative();
        HashMap<UUID, byte[]> hashMap = null;
        if (map != null) {
            boolean bl = map.containsKey("pssh");
            hashMap = null;
            if (bl) {
                ByteBuffer byteBuffer = (ByteBuffer)map.get("pssh");
                byteBuffer.order(ByteOrder.nativeOrder());
                byteBuffer.rewind();
                map.remove("pssh");
                hashMap = new HashMap<UUID, byte[]>();
                while (byteBuffer.remaining() > 0) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                    UUID uUID = new UUID(byteBuffer.getLong(), byteBuffer.getLong());
                    byteBuffer.order(ByteOrder.nativeOrder());
                    byte[] byArray = new byte[byteBuffer.getInt()];
                    byteBuffer.get(byArray);
                    hashMap.put(uUID, byArray);
                }
            }
        }
        return hashMap;
    }

    public native boolean getSampleCryptoInfo(MediaCodec.CryptoInfo var1);

    public native int getSampleFlags();

    public native long getSampleTime();

    public native int getSampleTrackIndex();

    public final native int getTrackCount();

    public MediaFormat getTrackFormat(int n) {
        return new MediaFormat(this.getTrackFormatNative(n));
    }

    public native boolean hasCacheReachedEndOfStream();

    public native int readSampleData(ByteBuffer var1, int var2);

    public final native void release();

    public native void seekTo(long var1, int var3);

    public native void selectTrack(int var1);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setDataSource(Context context, Uri uri, Map<String, String> map) throws IOException {
        AssetFileDescriptor assetFileDescriptor;
        block13: {
            block12: {
                block11: {
                    AssetFileDescriptor assetFileDescriptor2;
                    String string2 = uri.getScheme();
                    if (string2 == null || string2.equals("file")) {
                        this.setDataSource(uri.getPath());
                        return;
                    }
                    assetFileDescriptor = null;
                    assetFileDescriptor = assetFileDescriptor2 = context.getContentResolver().openAssetFileDescriptor(uri, "r");
                    if (assetFileDescriptor != null) break block11;
                    if (assetFileDescriptor == null) return;
                    assetFileDescriptor.close();
                    return;
                }
                if (assetFileDescriptor.getDeclaredLength() >= 0L) break block12;
                this.setDataSource(assetFileDescriptor.getFileDescriptor());
                break block13;
            }
            try {
                this.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getDeclaredLength());
            }
            catch (SecurityException securityException) {
                block14: {
                    if (assetFileDescriptor != null) {
                        assetFileDescriptor.close();
                    }
                    break block14;
                    catch (IOException iOException) {
                        if (assetFileDescriptor == null) break block14;
                        assetFileDescriptor.close();
                    }
                }
                this.setDataSource(uri.toString(), map);
                return;
            }
            catch (Throwable throwable) {
                if (assetFileDescriptor == null) throw throwable;
                assetFileDescriptor.close();
                throw throwable;
            }
        }
        if (assetFileDescriptor == null) return;
        assetFileDescriptor.close();
        return;
    }

    public final native void setDataSource(DataSource var1) throws IOException;

    public final void setDataSource(FileDescriptor fileDescriptor) throws IOException {
        this.setDataSource(fileDescriptor, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    public final native void setDataSource(FileDescriptor var1, long var2, long var4) throws IOException;

    public final void setDataSource(String string2) throws IOException {
        this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(string2), string2, null, null);
    }

    public final void setDataSource(String string2, Map<String, String> map) throws IOException {
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (map != null) {
            stringArray = new String[map.size()];
            stringArray2 = new String[map.size()];
            int n = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                stringArray[n] = entry.getKey();
                stringArray2[n] = entry.getValue();
                ++n;
            }
        }
        this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(string2), string2, stringArray, stringArray2);
    }

    public native void unselectTrack(int var1);
}

