/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaCryptoException;
import java.util.UUID;

public final class MediaCrypto {
    private long mNativeContext;

    static {
        System.loadLibrary("media_jni");
        MediaCrypto.native_init();
    }

    public MediaCrypto(UUID uUID, byte[] byArray) throws MediaCryptoException {
        this.native_setup(MediaCrypto.getByteArrayFromUUID(uUID), byArray);
    }

    private static final byte[] getByteArrayFromUUID(UUID uUID) {
        long l = uUID.getMostSignificantBits();
        long l2 = uUID.getLeastSignificantBits();
        byte[] byArray = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l >>> 8 * (7 - i));
            byArray[i + 8] = (byte)(l2 >>> 8 * (7 - i));
        }
        return byArray;
    }

    public static final boolean isCryptoSchemeSupported(UUID uUID) {
        return MediaCrypto.isCryptoSchemeSupportedNative(MediaCrypto.getByteArrayFromUUID(uUID));
    }

    private static final native boolean isCryptoSchemeSupportedNative(byte[] var0);

    private final native void native_finalize();

    private static final native void native_init();

    private final native void native_setup(byte[] var1, byte[] var2) throws MediaCryptoException;

    protected void finalize() {
        this.native_finalize();
    }

    public final native void release();

    public final native boolean requiresSecureDecoderComponent(String var1);
}

