/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;

public final class MediaCodecList {
    public static final int ALL_CODECS = 1;
    public static final int REGULAR_CODECS = 0;
    private static final String TAG = "MediaCodecList";
    private static MediaCodecInfo[] sAllCodecInfos;
    private static Object sInitLock;
    private static MediaCodecInfo[] sRegularCodecInfos;
    private MediaCodecInfo[] mCodecInfos;

    static {
        sInitLock = new Object();
        System.loadLibrary("media_jni");
        MediaCodecList.native_init();
    }

    private MediaCodecList() {
        this(0);
    }

    public MediaCodecList(int n) {
        MediaCodecList.initCodecList();
        if (n == 0) {
            this.mCodecInfos = sRegularCodecInfos;
            return;
        }
        this.mCodecInfos = sAllCodecInfos;
    }

    static final native int findCodecByName(String var0);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findCodecForFormat(boolean bl, MediaFormat mediaFormat) {
        String string2 = mediaFormat.getString("mime");
        MediaCodecInfo[] mediaCodecInfoArray = this.mCodecInfos;
        int n = mediaCodecInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            MediaCodecInfo mediaCodecInfo = mediaCodecInfoArray[n2];
            if (mediaCodecInfo.isEncoder() == bl) {
                try {
                    MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string2);
                    if (codecCapabilities != null && codecCapabilities.isFormatSupported(mediaFormat)) {
                        return mediaCodecInfo.getName();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            ++n2;
        }
        return null;
    }

    static final native MediaCodecInfo.CodecCapabilities getCodecCapabilities(int var0, String var1);

    public static final int getCodecCount() {
        MediaCodecList.initCodecList();
        return sRegularCodecInfos.length;
    }

    public static final MediaCodecInfo getCodecInfoAt(int n) {
        MediaCodecList.initCodecList();
        if (n < 0 || n > sRegularCodecInfos.length) {
            throw new IllegalArgumentException();
        }
        return sRegularCodecInfos[n];
    }

    static final native String getCodecName(int var0);

    public static MediaCodecInfo getInfoFor(String string2) {
        MediaCodecList.initCodecList();
        return sAllCodecInfos[MediaCodecList.findCodecByName(string2)];
    }

    private static MediaCodecInfo getNewCodecInfoAt(int n) {
        String[] stringArray = MediaCodecList.getSupportedTypes(n);
        MediaCodecInfo.CodecCapabilities[] codecCapabilitiesArray = new MediaCodecInfo.CodecCapabilities[stringArray.length];
        int n2 = stringArray.length;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            String string2 = stringArray[i];
            int n4 = n3 + 1;
            codecCapabilitiesArray[n3] = MediaCodecList.getCodecCapabilities(n, string2);
            n3 = n4;
        }
        return new MediaCodecInfo(MediaCodecList.getCodecName(n), MediaCodecList.isEncoder(n), codecCapabilitiesArray);
    }

    static final native String[] getSupportedTypes(int var0);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void initCodecList() {
        Object object = sInitLock;
        synchronized (object) {
            if (sRegularCodecInfos == null) {
                int n = MediaCodecList.native_getCodecCount();
                ArrayList<MediaCodecInfo> arrayList = new ArrayList<MediaCodecInfo>();
                ArrayList<MediaCodecInfo> arrayList2 = new ArrayList<MediaCodecInfo>();
                for (int i = 0; i < n; ++i) {
                    try {
                        MediaCodecInfo mediaCodecInfo = MediaCodecList.getNewCodecInfoAt(i);
                        arrayList2.add(mediaCodecInfo);
                        MediaCodecInfo mediaCodecInfo2 = mediaCodecInfo.makeRegular();
                        if (mediaCodecInfo2 == null) continue;
                        arrayList.add(mediaCodecInfo2);
                        continue;
                    }
                    catch (Exception exception) {
                        Log.e(TAG, "Could not get codec capabilities", exception);
                    }
                }
                sRegularCodecInfos = arrayList.toArray(new MediaCodecInfo[arrayList.size()]);
                sAllCodecInfos = arrayList2.toArray(new MediaCodecInfo[arrayList2.size()]);
            }
            return;
        }
    }

    static final native boolean isEncoder(int var0);

    private static final native int native_getCodecCount();

    private static final native void native_init();

    public final String findDecoderForFormat(MediaFormat mediaFormat) {
        return this.findCodecForFormat(false, mediaFormat);
    }

    public final String findEncoderForFormat(MediaFormat mediaFormat) {
        return this.findCodecForFormat(true, mediaFormat);
    }

    public final MediaCodecInfo[] getCodecInfos() {
        return Arrays.copyOf(this.mCodecInfos, this.mCodecInfos.length);
    }
}

