/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Rect;
import android.media.AudioSystem;
import android.media.Image;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.media.Utils;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.NioUtils;
import java.nio.ReadOnlyBufferException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class MediaCodec {
    public static final int BUFFER_FLAG_CODEC_CONFIG = 2;
    public static final int BUFFER_FLAG_END_OF_STREAM = 4;
    public static final int BUFFER_FLAG_KEY_FRAME = 1;
    public static final int BUFFER_FLAG_SYNC_FRAME = 1;
    private static final int CB_ERROR = 3;
    private static final int CB_INPUT_AVAILABLE = 1;
    private static final int CB_OUTPUT_AVAILABLE = 2;
    private static final int CB_OUTPUT_FORMAT_CHANGE = 4;
    public static final int CONFIGURE_FLAG_ENCODE = 1;
    public static final int CRYPTO_MODE_AES_CTR = 1;
    public static final int CRYPTO_MODE_UNENCRYPTED = 0;
    private static final int EVENT_CALLBACK = 1;
    private static final int EVENT_SET_CALLBACK = 2;
    public static final int INFO_OUTPUT_BUFFERS_CHANGED = -3;
    public static final int INFO_OUTPUT_FORMAT_CHANGED = -2;
    public static final int INFO_TRY_AGAIN_LATER = -1;
    public static final String PARAMETER_KEY_REQUEST_SYNC_FRAME = "request-sync";
    public static final String PARAMETER_KEY_SUSPEND = "drop-input-frames";
    public static final String PARAMETER_KEY_VIDEO_BITRATE = "video-bitrate";
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;
    private final Object mBufferLock;
    private ByteBuffer[] mCachedInputBuffers;
    private ByteBuffer[] mCachedOutputBuffers;
    private Callback mCallback;
    private final BufferMap mDequeuedInputBuffers = new BufferMap();
    private final BufferMap mDequeuedOutputBuffers = new BufferMap();
    private EventHandler mEventHandler;
    private long mNativeContext;

    static {
        System.loadLibrary("media_jni");
        MediaCodec.native_init();
    }

    /*
     * Enabled aggressive block sorting
     */
    private MediaCodec(String string2, boolean bl, boolean bl2) {
        Looper looper;
        Looper looper2 = Looper.myLooper();
        this.mEventHandler = looper2 != null ? new EventHandler(this, looper2) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mBufferLock = new Object();
        this.native_setup(string2, bl, bl2);
    }

    static /* synthetic */ Callback access$002(MediaCodec mediaCodec, Callback callback) {
        mediaCodec.mCallback = callback;
        return callback;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void cacheBuffers(boolean bl) {
        ByteBuffer[] byteBufferArray = null;
        try {
            byteBufferArray = this.getBuffers(bl);
            this.invalidateByteBuffers(byteBufferArray);
        }
        catch (IllegalStateException illegalStateException) {}
        if (bl) {
            this.mCachedInputBuffers = byteBufferArray;
            return;
        }
        this.mCachedOutputBuffers = byteBufferArray;
    }

    public static MediaCodec createByCodecName(String string2) throws IOException {
        return new MediaCodec(string2, false, false);
    }

    public static MediaCodec createDecoderByType(String string2) throws IOException {
        return new MediaCodec(string2, true, false);
    }

    public static MediaCodec createEncoderByType(String string2) throws IOException {
        return new MediaCodec(string2, true, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void freeAllTrackedBuffers() {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.freeByteBuffers(this.mCachedInputBuffers);
            this.freeByteBuffers(this.mCachedOutputBuffers);
            this.mCachedInputBuffers = null;
            this.mCachedOutputBuffers = null;
            this.mDequeuedInputBuffers.clear();
            this.mDequeuedOutputBuffers.clear();
            return;
        }
    }

    private final void freeByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            NioUtils.freeDirectBuffer((ByteBuffer)byteBuffer);
        }
    }

    private final void freeByteBuffers(ByteBuffer[] byteBufferArray) {
        if (byteBufferArray != null) {
            int n = byteBufferArray.length;
            for (int i = 0; i < n; ++i) {
                this.freeByteBuffer(byteBufferArray[i]);
            }
        }
    }

    private final native ByteBuffer getBuffer(boolean var1, int var2);

    private final native ByteBuffer[] getBuffers(boolean var1);

    private final native Map<String, Object> getFormatNative(boolean var1);

    private final native Image getImage(boolean var1, int var2);

    private final native Map<String, Object> getOutputFormatNative(int var1);

    private final void invalidateByteBuffer(ByteBuffer[] byteBufferArray, int n) {
        ByteBuffer byteBuffer;
        if (byteBufferArray != null && n >= 0 && n < byteBufferArray.length && (byteBuffer = byteBufferArray[n]) != null) {
            byteBuffer.setAccessible(false);
        }
    }

    private final void invalidateByteBuffers(ByteBuffer[] byteBufferArray) {
        if (byteBufferArray != null) {
            for (ByteBuffer byteBuffer : byteBufferArray) {
                if (byteBuffer == null) continue;
                byteBuffer.setAccessible(false);
            }
        }
    }

    private final native void native_configure(String[] var1, Object[] var2, Surface var3, MediaCrypto var4, int var5);

    private final native int native_dequeueInputBuffer(long var1);

    private final native int native_dequeueOutputBuffer(BufferInfo var1, long var2);

    private final native void native_finalize();

    private final native void native_flush();

    private static final native void native_init();

    private final native void native_queueInputBuffer(int var1, int var2, int var3, long var4, int var6) throws CryptoException;

    private final native void native_queueSecureInputBuffer(int var1, int var2, CryptoInfo var3, long var4, int var6) throws CryptoException;

    private final native void native_release();

    private final native void native_reset();

    private final native void native_setCallback(Callback var1);

    private final native void native_setup(String var1, boolean var2, boolean var3);

    private final native void native_start();

    private final native void native_stop();

    private void postEventFromNative(int n, int n2, int n3, Object object) {
        if (this.mEventHandler != null) {
            Message message = this.mEventHandler.obtainMessage(n, n2, n3, object);
            this.mEventHandler.sendMessage(message);
        }
    }

    private final native void releaseOutputBuffer(int var1, boolean var2, boolean var3, long var4);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void revalidateByteBuffer(ByteBuffer[] byteBufferArray, int n) {
        Object object = this.mBufferLock;
        synchronized (object) {
            ByteBuffer byteBuffer;
            if (byteBufferArray != null && n >= 0 && n < byteBufferArray.length && (byteBuffer = byteBufferArray[n]) != null) {
                byteBuffer.setAccessible(true);
            }
            return;
        }
    }

    private final native void setParameters(String[] var1, Object[] var2);

    private final void validateInputByteBuffer(ByteBuffer[] byteBufferArray, int n) {
        ByteBuffer byteBuffer;
        if (byteBufferArray != null && n >= 0 && n < byteBufferArray.length && (byteBuffer = byteBufferArray[n]) != null) {
            byteBuffer.setAccessible(true);
            byteBuffer.clear();
        }
    }

    private final void validateOutputByteBuffer(ByteBuffer[] byteBufferArray, int n, BufferInfo bufferInfo) {
        ByteBuffer byteBuffer;
        if (byteBufferArray != null && n >= 0 && n < byteBufferArray.length && (byteBuffer = byteBufferArray[n]) != null) {
            byteBuffer.setAccessible(true);
            byteBuffer.limit(bufferInfo.offset + bufferInfo.size).position(bufferInfo.offset);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(MediaFormat mediaFormat, Surface surface, MediaCrypto mediaCrypto, int n) {
        Object[] objectArray;
        String[] stringArray;
        block3: {
            Map<String, Object> map = mediaFormat.getMap();
            stringArray = null;
            objectArray = null;
            if (mediaFormat == null) break block3;
            stringArray = new String[map.size()];
            objectArray = new Object[map.size()];
            int n2 = 0;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                block5: {
                    block4: {
                        int n3;
                        if (!entry.getKey().equals("audio-session-id")) break block4;
                        try {
                            n3 = (Integer)entry.getValue();
                            stringArray[n2] = "audio-hw-sync";
                        }
                        catch (Exception exception) {
                            throw new IllegalArgumentException("Wrong Session ID Parameter!");
                        }
                        objectArray[n2] = AudioSystem.getAudioHwSyncForSession(n3);
                        break block5;
                    }
                    stringArray[n2] = entry.getKey();
                    objectArray[n2] = entry.getValue();
                }
                ++n2;
            }
        }
        this.native_configure(stringArray, objectArray, surface, mediaCrypto, n);
    }

    public final native Surface createInputSurface();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int dequeueInputBuffer(long l) {
        int n = this.native_dequeueInputBuffer(l);
        if (n >= 0) {
            Object object = this.mBufferLock;
            synchronized (object) {
                this.validateInputByteBuffer(this.mCachedInputBuffers, n);
                return n;
            }
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int dequeueOutputBuffer(BufferInfo bufferInfo, long l) {
        int n = this.native_dequeueOutputBuffer(bufferInfo, l);
        Object object = this.mBufferLock;
        synchronized (object) {
            if (n == -3) {
                this.cacheBuffers(false);
            } else if (n >= 0) {
                this.validateOutputByteBuffer(this.mCachedOutputBuffers, n, bufferInfo);
            }
            return n;
        }
    }

    protected void finalize() {
        this.native_finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void flush() {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffers(this.mCachedInputBuffers);
            this.invalidateByteBuffers(this.mCachedOutputBuffers);
            this.mDequeuedInputBuffers.clear();
            this.mDequeuedOutputBuffers.clear();
        }
        this.native_flush();
    }

    public MediaCodecInfo getCodecInfo() {
        return MediaCodecList.getInfoFor(this.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer getInputBuffer(int n) {
        ByteBuffer byteBuffer = this.getBuffer(true, n);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, n);
            this.mDequeuedInputBuffers.put(n, byteBuffer);
            return byteBuffer;
        }
    }

    public ByteBuffer[] getInputBuffers() {
        if (this.mCachedInputBuffers == null) {
            throw new IllegalStateException();
        }
        return this.mCachedInputBuffers;
    }

    public final MediaFormat getInputFormat() {
        return new MediaFormat(this.getFormatNative(true));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image getInputImage(int n) {
        Image image = this.getImage(true, n);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, n);
            this.mDequeuedInputBuffers.put(n, image);
            return image;
        }
    }

    public final native String getName();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer getOutputBuffer(int n) {
        ByteBuffer byteBuffer = this.getBuffer(false, n);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, n);
            this.mDequeuedOutputBuffers.put(n, byteBuffer);
            return byteBuffer;
        }
    }

    public ByteBuffer[] getOutputBuffers() {
        if (this.mCachedOutputBuffers == null) {
            throw new IllegalStateException();
        }
        return this.mCachedOutputBuffers;
    }

    public final MediaFormat getOutputFormat() {
        return new MediaFormat(this.getFormatNative(false));
    }

    public final MediaFormat getOutputFormat(int n) {
        return new MediaFormat(this.getOutputFormatNative(n));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image getOutputImage(int n) {
        Image image = this.getImage(false, n);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, n);
            this.mDequeuedOutputBuffers.put(n, image);
            return image;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void queueInputBuffer(int var1_1, int var2_2, int var3_3, long var4_4, int var6_5) throws CryptoException {
        var7_6 = this.mBufferLock;
        synchronized (var7_6) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, var1_1);
            this.mDequeuedInputBuffers.remove(var1_1);
        }
        try {
            this.native_queueInputBuffer(var1_1, var2_2, var3_3, var4_4, var6_5);
            return;
        }
        catch (CryptoException var9_7) {}
        ** GOTO lbl-1000
        catch (IllegalStateException var9_9) {}
lbl-1000:
        // 2 sources

        {
            this.revalidateByteBuffer(this.mCachedInputBuffers, var1_1);
            throw var9_8;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void queueSecureInputBuffer(int var1_1, int var2_2, CryptoInfo var3_3, long var4_4, int var6_5) throws CryptoException {
        var7_6 = this.mBufferLock;
        synchronized (var7_6) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, var1_1);
            this.mDequeuedInputBuffers.remove(var1_1);
        }
        try {
            this.native_queueSecureInputBuffer(var1_1, var2_2, var3_3, var4_4, var6_5);
            return;
        }
        catch (CryptoException var9_7) {}
        ** GOTO lbl-1000
        catch (IllegalStateException var9_9) {}
lbl-1000:
        // 2 sources

        {
            this.revalidateByteBuffer(this.mCachedInputBuffers, var1_1);
            throw var9_8;
        }
    }

    public final void release() {
        this.freeAllTrackedBuffers();
        this.native_release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void releaseOutputBuffer(int n, long l) {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, n);
            this.mDequeuedOutputBuffers.remove(n);
        }
        this.releaseOutputBuffer(n, true, true, l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void releaseOutputBuffer(int n, boolean bl) {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, n);
            this.mDequeuedOutputBuffers.remove(n);
        }
        this.releaseOutputBuffer(n, bl, false, 0L);
    }

    public final void reset() {
        this.freeAllTrackedBuffers();
        this.native_reset();
    }

    public void setCallback(Callback callback) {
        if (this.mEventHandler != null) {
            Message message = this.mEventHandler.obtainMessage(2, 0, 0, callback);
            this.mEventHandler.sendMessage(message);
            this.native_setCallback(callback);
        }
    }

    public final void setParameters(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        String[] stringArray = new String[bundle.size()];
        Object[] objectArray = new Object[bundle.size()];
        int n = 0;
        Iterator<String> iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            stringArray[n] = string2 = iterator.next();
            objectArray[n] = bundle.get(string2);
            ++n;
        }
        this.setParameters(stringArray, objectArray);
    }

    public final native void setVideoScalingMode(int var1);

    public final native void signalEndOfInputStream();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void start() {
        this.native_start();
        Object object = this.mBufferLock;
        synchronized (object) {
            this.cacheBuffers(true);
            this.cacheBuffers(false);
            return;
        }
    }

    public final void stop() {
        this.native_stop();
        this.freeAllTrackedBuffers();
        if (this.mEventHandler != null) {
            this.mEventHandler.removeMessages(1);
            this.mEventHandler.removeMessages(2);
        }
    }

    public static final class BufferInfo {
        public int flags;
        public int offset;
        public long presentationTimeUs;
        public int size;

        public void set(int n, int n2, long l, int n3) {
            this.offset = n;
            this.size = n2;
            this.presentationTimeUs = l;
            this.flags = n3;
        }
    }

    private static class BufferMap {
        private final Map<Integer, CodecBuffer> mMap = new HashMap<Integer, CodecBuffer>();

        private BufferMap() {
        }

        public void clear() {
            Iterator<CodecBuffer> iterator = this.mMap.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().free();
            }
            this.mMap.clear();
        }

        public void put(int n, Image image) {
            CodecBuffer codecBuffer = this.mMap.get(n);
            if (codecBuffer == null) {
                codecBuffer = new CodecBuffer();
                this.mMap.put(n, codecBuffer);
            }
            codecBuffer.setImage(image);
        }

        public void put(int n, ByteBuffer byteBuffer) {
            CodecBuffer codecBuffer = this.mMap.get(n);
            if (codecBuffer == null) {
                codecBuffer = new CodecBuffer();
                this.mMap.put(n, codecBuffer);
            }
            codecBuffer.setByteBuffer(byteBuffer);
        }

        public void remove(int n) {
            CodecBuffer codecBuffer = this.mMap.get(n);
            if (codecBuffer != null) {
                codecBuffer.free();
                this.mMap.remove(n);
            }
        }

        private static class CodecBuffer {
            private ByteBuffer mByteBuffer;
            private Image mImage;

            private CodecBuffer() {
            }

            public void free() {
                if (this.mByteBuffer != null) {
                    NioUtils.freeDirectBuffer((ByteBuffer)this.mByteBuffer);
                    this.mByteBuffer = null;
                }
                if (this.mImage != null) {
                    this.mImage.close();
                    this.mImage = null;
                }
            }

            public void setByteBuffer(ByteBuffer byteBuffer) {
                this.free();
                this.mByteBuffer = byteBuffer;
            }

            public void setImage(Image image) {
                this.free();
                this.mImage = image;
            }
        }
    }

    public static abstract class Callback {
        public abstract void onError(MediaCodec var1, CodecException var2);

        public abstract void onInputBufferAvailable(MediaCodec var1, int var2);

        public abstract void onOutputBufferAvailable(MediaCodec var1, int var2, BufferInfo var3);

        public abstract void onOutputFormatChanged(MediaCodec var1, MediaFormat var2);
    }

    public static final class CodecException
    extends IllegalStateException {
        private static final int ACTION_RECOVERABLE = 2;
        private static final int ACTION_TRANSIENT = 1;
        private final int mActionCode;
        private final String mDiagnosticInfo;
        private final int mErrorCode;

        /*
         * Enabled aggressive block sorting
         */
        CodecException(int n, int n2, String string2) {
            super(string2);
            this.mErrorCode = n;
            this.mActionCode = n2;
            String string3 = n < 0 ? "neg_" : "";
            this.mDiagnosticInfo = "android.media.MediaCodec.error_" + string3 + Math.abs(n);
        }

        public String getDiagnosticInfo() {
            return this.mDiagnosticInfo;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        public boolean isRecoverable() {
            return this.mActionCode == 2;
        }

        public boolean isTransient() {
            return this.mActionCode == 1;
        }
    }

    public static final class CryptoException
    extends RuntimeException {
        public static final int ERROR_INSUFFICIENT_OUTPUT_PROTECTION = 4;
        public static final int ERROR_KEY_EXPIRED = 2;
        public static final int ERROR_NO_KEY = 1;
        public static final int ERROR_RESOURCE_BUSY = 3;
        private int mErrorCode;

        public CryptoException(int n, String string2) {
            super(string2);
            this.mErrorCode = n;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }
    }

    public static final class CryptoInfo {
        public byte[] iv;
        public byte[] key;
        public int mode;
        public int[] numBytesOfClearData;
        public int[] numBytesOfEncryptedData;
        public int numSubSamples;

        public void set(int n, int[] nArray, int[] nArray2, byte[] byArray, byte[] byArray2, int n2) {
            this.numSubSamples = n;
            this.numBytesOfClearData = nArray;
            this.numBytesOfEncryptedData = nArray2;
            this.key = byArray;
            this.iv = byArray2;
            this.mode = n2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.numSubSamples + " subsamples, key [");
            for (int i = 0; i < this.key.length; ++i) {
                stringBuilder.append("0123456789abcdef".charAt((0xF0 & this.key[i]) >> 4));
                stringBuilder.append("0123456789abcdef".charAt(0xF & this.key[i]));
            }
            stringBuilder.append("], iv [");
            for (int i = 0; i < this.key.length; ++i) {
                stringBuilder.append("0123456789abcdef".charAt((0xF0 & this.iv[i]) >> 4));
                stringBuilder.append("0123456789abcdef".charAt(0xF & this.iv[i]));
            }
            stringBuilder.append("], clear ");
            stringBuilder.append(Arrays.toString(this.numBytesOfClearData));
            stringBuilder.append(", encrypted ");
            stringBuilder.append(Arrays.toString(this.numBytesOfEncryptedData));
            return stringBuilder.toString();
        }
    }

    private class EventHandler
    extends Handler {
        private MediaCodec mCodec;

        public EventHandler(MediaCodec mediaCodec2, Looper looper) {
            super(looper);
            this.mCodec = mediaCodec2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleCallback(Message message) {
            if (MediaCodec.this.mCallback == null) {
                return;
            }
            switch (message.arg1) {
                default: {
                    return;
                }
                case 1: {
                    int n = message.arg2;
                    Object object = MediaCodec.this.mBufferLock;
                    synchronized (object) {
                        MediaCodec.this.validateInputByteBuffer(MediaCodec.this.mCachedInputBuffers, n);
                    }
                    MediaCodec.this.mCallback.onInputBufferAvailable(this.mCodec, n);
                    return;
                }
                case 2: {
                    int n = message.arg2;
                    BufferInfo bufferInfo = (BufferInfo)message.obj;
                    Object object = MediaCodec.this.mBufferLock;
                    synchronized (object) {
                        MediaCodec.this.validateOutputByteBuffer(MediaCodec.this.mCachedOutputBuffers, n, bufferInfo);
                    }
                    MediaCodec.this.mCallback.onOutputBufferAvailable(this.mCodec, n, bufferInfo);
                    return;
                }
                case 3: {
                    MediaCodec.this.mCallback.onError(this.mCodec, (CodecException)message.obj);
                    return;
                }
                case 4: 
            }
            MediaCodec.this.mCallback.onOutputFormatChanged(this.mCodec, new MediaFormat((Map)message.obj));
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    this.handleCallback(message);
                    return;
                }
                case 2: 
            }
            MediaCodec.access$002(MediaCodec.this, (Callback)message.obj);
        }
    }

    public static class MediaImage
    extends Image {
        private static final int TYPE_YUV = 1;
        private final ByteBuffer mBuffer;
        private final int mFormat;
        private final int mHeight;
        private final ByteBuffer mInfo;
        private final boolean mIsReadOnly;
        private boolean mIsValid;
        private final Image.Plane[] mPlanes;
        private long mTimestamp;
        private final int mWidth;
        private final int mXOffset;
        private final int mYOffset;

        /*
         * Enabled aggressive block sorting
         */
        public MediaImage(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl, long l, int n, int n2, Rect rect) {
            this.mFormat = 35;
            this.mTimestamp = l;
            this.mIsValid = true;
            this.mIsReadOnly = byteBuffer.isReadOnly();
            this.mBuffer = byteBuffer.duplicate();
            if (rect != null) {
                rect.offset(-n, -n2);
            }
            super.setCropRect(rect);
            this.mXOffset = n;
            this.mYOffset = n2;
            this.mInfo = byteBuffer2;
            if (byteBuffer2.remaining() != 80 && byteBuffer2.remaining() != 156) {
                throw new UnsupportedOperationException("unsupported info length: " + byteBuffer2.remaining());
            }
            boolean bl2 = byteBuffer2.remaining() == 156;
            int n3 = byteBuffer2.getInt();
            if (n3 != 1) {
                throw new UnsupportedOperationException("unsupported type: " + n3);
            }
            int n4 = this.readInt(byteBuffer2, bl2);
            if (n4 != 3) {
                throw new RuntimeException("unexpected number of planes: " + n4);
            }
            this.mWidth = this.readInt(byteBuffer2, bl2);
            this.mHeight = this.readInt(byteBuffer2, bl2);
            if (this.mWidth < 1 || this.mHeight < 1) {
                throw new UnsupportedOperationException("unsupported size: " + this.mWidth + "x" + this.mHeight);
            }
            int n5 = this.readInt(byteBuffer2, bl2);
            if (n5 != 8) {
                throw new UnsupportedOperationException("unsupported bit depth: " + n5);
            }
            this.mPlanes = new MediaPlane[n4];
            int n6 = 0;
            while (n6 < n4) {
                int n7;
                int n8;
                int n9 = this.readInt(byteBuffer2, bl2);
                int n10 = this.readInt(byteBuffer2, bl2);
                int n11 = this.readInt(byteBuffer2, bl2);
                int n12 = this.readInt(byteBuffer2, bl2);
                if (n12 != (n8 = this.readInt(byteBuffer2, bl2)) || n12 != (n7 = n6 == 0 ? 1 : 2)) {
                    throw new UnsupportedOperationException("unexpected subsampling: " + n12 + "x" + n8 + " on plane " + n6);
                }
                byteBuffer.clear();
                byteBuffer.position(n9 + this.mBuffer.position() + n10 * (n / n12) + n11 * (n2 / n8));
                byteBuffer.limit(byteBuffer.position() + Utils.divUp(n5, 8) + n11 * (-1 + this.mHeight / n8) + n10 * (-1 + this.mWidth / n12));
                this.mPlanes[n6] = new MediaPlane(byteBuffer.slice(), n11, n10);
                ++n6;
            }
            return;
        }

        private void checkValid() {
            if (!this.mIsValid) {
                throw new IllegalStateException("Image is already released");
            }
        }

        private int readInt(ByteBuffer byteBuffer, boolean bl) {
            if (bl) {
                return (int)byteBuffer.getLong();
            }
            return byteBuffer.getInt();
        }

        @Override
        public void close() {
            if (this.mIsValid) {
                NioUtils.freeDirectBuffer((ByteBuffer)this.mBuffer);
                this.mIsValid = false;
            }
        }

        @Override
        public int getFormat() {
            this.checkValid();
            return this.mFormat;
        }

        @Override
        public int getHeight() {
            this.checkValid();
            return this.mHeight;
        }

        @Override
        public Image.Plane[] getPlanes() {
            this.checkValid();
            return Arrays.copyOf(this.mPlanes, this.mPlanes.length);
        }

        @Override
        public long getTimestamp() {
            this.checkValid();
            return this.mTimestamp;
        }

        @Override
        public int getWidth() {
            this.checkValid();
            return this.mWidth;
        }

        @Override
        public void setCropRect(Rect rect) {
            if (this.mIsReadOnly) {
                throw new ReadOnlyBufferException();
            }
            super.setCropRect(rect);
        }

        private class MediaPlane
        extends Image.Plane {
            private final int mColInc;
            private final ByteBuffer mData;
            private final int mRowInc;

            public MediaPlane(ByteBuffer byteBuffer, int n, int n2) {
                this.mData = byteBuffer;
                this.mRowInc = n;
                this.mColInc = n2;
            }

            @Override
            public ByteBuffer getBuffer() {
                MediaImage.this.checkValid();
                return this.mData;
            }

            @Override
            public int getPixelStride() {
                MediaImage.this.checkValid();
                return this.mColInc;
            }

            @Override
            public int getRowStride() {
                MediaImage.this.checkValid();
                return this.mRowInc;
            }
        }
    }
}

