/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.SoundPool;
import android.util.Log;

public class MediaActionSound {
    public static final int FOCUS_COMPLETE = 1;
    private static final int NUM_MEDIA_SOUND_STREAMS = 1;
    public static final int SHUTTER_CLICK = 0;
    private static final String[] SOUND_FILES = new String[]{"/system/media/audio/ui/camera_click.ogg", "/system/media/audio/ui/camera_focus.ogg", "/system/media/audio/ui/VideoRecord.ogg", "/system/media/audio/ui/VideoRecord.ogg"};
    private static final int SOUND_NOT_LOADED = -1;
    public static final int START_VIDEO_RECORDING = 2;
    public static final int STOP_VIDEO_RECORDING = 3;
    private static final String TAG = "MediaActionSound";
    private SoundPool.OnLoadCompleteListener mLoadCompleteListener = new SoundPool.OnLoadCompleteListener(){

        @Override
        public void onLoadComplete(SoundPool soundPool, int n, int n2) {
            if (n2 == 0) {
                if (MediaActionSound.this.mSoundIdToPlay == n) {
                    soundPool.play(n, 1.0f, 1.0f, 0, 0, 1.0f);
                    MediaActionSound.access$002(MediaActionSound.this, -1);
                }
                return;
            }
            Log.e(MediaActionSound.TAG, "Unable to load sound for playback (status: " + n2 + ")");
        }
    };
    private int mSoundIdToPlay;
    private int[] mSoundIds;
    private SoundPool mSoundPool = new SoundPool(1, 7, 0);

    public MediaActionSound() {
        this.mSoundPool.setOnLoadCompleteListener(this.mLoadCompleteListener);
        this.mSoundIds = new int[SOUND_FILES.length];
        for (int i = 0; i < this.mSoundIds.length; ++i) {
            this.mSoundIds[i] = -1;
        }
        this.mSoundIdToPlay = -1;
    }

    static /* synthetic */ int access$002(MediaActionSound mediaActionSound, int n) {
        mediaActionSound.mSoundIdToPlay = n;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(int n) {
        synchronized (this) {
            if (n < 0 || n >= SOUND_FILES.length) {
                throw new RuntimeException("Unknown sound requested: " + n);
            }
            if (this.mSoundIds[n] == -1) {
                this.mSoundIds[n] = this.mSoundPool.load(SOUND_FILES[n], 1);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void play(int n) {
        synchronized (this) {
            if (n < 0 || n >= SOUND_FILES.length) {
                throw new RuntimeException("Unknown sound requested: " + n);
            }
            if (this.mSoundIds[n] == -1) {
                this.mSoundIds[n] = this.mSoundIdToPlay = this.mSoundPool.load(SOUND_FILES[n], 1);
            } else {
                this.mSoundPool.play(this.mSoundIds[n], 1.0f, 1.0f, 0, 0, 1.0f);
            }
            return;
        }
    }

    public void release() {
        if (this.mSoundPool != null) {
            this.mSoundPool.release();
            this.mSoundPool = null;
        }
    }
}

