/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.bluetooth.BluetoothDevice;
import android.content.ComponentName;
import android.media.AudioRoutesInfo;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioRoutesObserver;
import android.media.IRemoteControlDisplay;
import android.media.IRingtonePlayer;
import android.media.IVolumeController;
import android.media.audiopolicy.AudioPolicyConfig;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IAudioService
extends IInterface {
    public int abandonAudioFocus(IAudioFocusDispatcher var1, String var2) throws RemoteException;

    public void adjustMasterVolume(int var1, int var2, String var3) throws RemoteException;

    public void adjustStreamVolume(int var1, int var2, int var3, String var4) throws RemoteException;

    public void adjustSuggestedStreamVolume(int var1, int var2, int var3, String var4) throws RemoteException;

    public void avrcpSupportsAbsoluteVolume(String var1, boolean var2) throws RemoteException;

    public void disableSafeMediaVolume() throws RemoteException;

    public void forceRemoteSubmixFullVolume(boolean var1, IBinder var2) throws RemoteException;

    public void forceVolumeControlStream(int var1, IBinder var2) throws RemoteException;

    public int getCurrentAudioFocus() throws RemoteException;

    public int getLastAudibleMasterVolume() throws RemoteException;

    public int getLastAudibleStreamVolume(int var1) throws RemoteException;

    public int getMasterMaxVolume() throws RemoteException;

    public int getMasterStreamType() throws RemoteException;

    public int getMasterVolume() throws RemoteException;

    public int getMode() throws RemoteException;

    public int getRingerMode() throws RemoteException;

    public IRingtonePlayer getRingtonePlayer() throws RemoteException;

    public int getStreamMaxVolume(int var1) throws RemoteException;

    public int getStreamVolume(int var1) throws RemoteException;

    public int getVibrateSetting(int var1) throws RemoteException;

    public boolean isBluetoothA2dpOn() throws RemoteException;

    public boolean isBluetoothScoOn() throws RemoteException;

    public boolean isCameraSoundForced() throws RemoteException;

    public boolean isHdmiSystemAudioSupported() throws RemoteException;

    public boolean isMasterMute() throws RemoteException;

    public boolean isSpeakerphoneOn() throws RemoteException;

    public boolean isStreamAffectedByRingerMode(int var1) throws RemoteException;

    public boolean isStreamMute(int var1) throws RemoteException;

    public boolean loadSoundEffects() throws RemoteException;

    public void notifyVolumeControllerVisible(IVolumeController var1, boolean var2) throws RemoteException;

    public void playSoundEffect(int var1) throws RemoteException;

    public void playSoundEffectVolume(int var1, float var2) throws RemoteException;

    public boolean registerAudioPolicy(AudioPolicyConfig var1, IBinder var2) throws RemoteException;

    public boolean registerRemoteControlDisplay(IRemoteControlDisplay var1, int var2, int var3) throws RemoteException;

    public boolean registerRemoteController(IRemoteControlDisplay var1, int var2, int var3, ComponentName var4) throws RemoteException;

    public void reloadAudioSettings() throws RemoteException;

    public void remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay var1, int var2, int var3) throws RemoteException;

    public void remoteControlDisplayWantsPlaybackPositionSync(IRemoteControlDisplay var1, boolean var2) throws RemoteException;

    public int requestAudioFocus(int var1, int var2, IBinder var3, IAudioFocusDispatcher var4, String var5, String var6) throws RemoteException;

    public int setBluetoothA2dpDeviceConnectionState(BluetoothDevice var1, int var2, int var3) throws RemoteException;

    public void setBluetoothA2dpOn(boolean var1) throws RemoteException;

    public void setBluetoothScoOn(boolean var1) throws RemoteException;

    public int setHdmiSystemAudioSupported(boolean var1) throws RemoteException;

    public void setMasterMute(boolean var1, int var2, String var3, IBinder var4) throws RemoteException;

    public void setMasterVolume(int var1, int var2, String var3) throws RemoteException;

    public void setMicrophoneMute(boolean var1, String var2) throws RemoteException;

    public void setMode(int var1, IBinder var2) throws RemoteException;

    public void setRemoteStreamVolume(int var1) throws RemoteException;

    public void setRingerMode(int var1, boolean var2) throws RemoteException;

    public void setRingtonePlayer(IRingtonePlayer var1) throws RemoteException;

    public void setSpeakerphoneOn(boolean var1) throws RemoteException;

    public void setStreamMute(int var1, boolean var2, IBinder var3) throws RemoteException;

    public void setStreamSolo(int var1, boolean var2, IBinder var3) throws RemoteException;

    public void setStreamVolume(int var1, int var2, int var3, String var4) throws RemoteException;

    public void setVibrateSetting(int var1, int var2) throws RemoteException;

    public void setVolumeController(IVolumeController var1) throws RemoteException;

    public void setWiredDeviceConnectionState(int var1, int var2, String var3) throws RemoteException;

    public boolean shouldVibrate(int var1) throws RemoteException;

    public void startBluetoothSco(IBinder var1, int var2) throws RemoteException;

    public void startBluetoothScoVirtualCall(IBinder var1) throws RemoteException;

    public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver var1) throws RemoteException;

    public void stopBluetoothSco(IBinder var1) throws RemoteException;

    public void unloadSoundEffects() throws RemoteException;

    public void unregisterAudioFocusClient(String var1) throws RemoteException;

    public void unregisterAudioPolicyAsync(IBinder var1) throws RemoteException;

    public void unregisterRemoteControlDisplay(IRemoteControlDisplay var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAudioService {
        private static final String DESCRIPTOR = "android.media.IAudioService";
        static final int TRANSACTION_abandonAudioFocus = 40;
        static final int TRANSACTION_adjustMasterVolume = 3;
        static final int TRANSACTION_adjustStreamVolume = 2;
        static final int TRANSACTION_adjustSuggestedStreamVolume = 1;
        static final int TRANSACTION_avrcpSupportsAbsoluteVolume = 32;
        static final int TRANSACTION_disableSafeMediaVolume = 62;
        static final int TRANSACTION_forceRemoteSubmixFullVolume = 10;
        static final int TRANSACTION_forceVolumeControlStream = 51;
        static final int TRANSACTION_getCurrentAudioFocus = 42;
        static final int TRANSACTION_getLastAudibleMasterVolume = 18;
        static final int TRANSACTION_getLastAudibleStreamVolume = 17;
        static final int TRANSACTION_getMasterMaxVolume = 16;
        static final int TRANSACTION_getMasterStreamType = 54;
        static final int TRANSACTION_getMasterVolume = 14;
        static final int TRANSACTION_getMode = 26;
        static final int TRANSACTION_getRingerMode = 21;
        static final int TRANSACTION_getRingtonePlayer = 53;
        static final int TRANSACTION_getStreamMaxVolume = 15;
        static final int TRANSACTION_getStreamVolume = 13;
        static final int TRANSACTION_getVibrateSetting = 23;
        static final int TRANSACTION_isBluetoothA2dpOn = 38;
        static final int TRANSACTION_isBluetoothScoOn = 36;
        static final int TRANSACTION_isCameraSoundForced = 58;
        static final int TRANSACTION_isHdmiSystemAudioSupported = 64;
        static final int TRANSACTION_isMasterMute = 12;
        static final int TRANSACTION_isSpeakerphoneOn = 34;
        static final int TRANSACTION_isStreamAffectedByRingerMode = 61;
        static final int TRANSACTION_isStreamMute = 9;
        static final int TRANSACTION_loadSoundEffects = 29;
        static final int TRANSACTION_notifyVolumeControllerVisible = 60;
        static final int TRANSACTION_playSoundEffect = 27;
        static final int TRANSACTION_playSoundEffectVolume = 28;
        static final int TRANSACTION_registerAudioPolicy = 65;
        static final int TRANSACTION_registerRemoteControlDisplay = 43;
        static final int TRANSACTION_registerRemoteController = 44;
        static final int TRANSACTION_reloadAudioSettings = 31;
        static final int TRANSACTION_remoteControlDisplayUsesBitmapSize = 46;
        static final int TRANSACTION_remoteControlDisplayWantsPlaybackPositionSync = 47;
        static final int TRANSACTION_requestAudioFocus = 39;
        static final int TRANSACTION_setBluetoothA2dpDeviceConnectionState = 56;
        static final int TRANSACTION_setBluetoothA2dpOn = 37;
        static final int TRANSACTION_setBluetoothScoOn = 35;
        static final int TRANSACTION_setHdmiSystemAudioSupported = 63;
        static final int TRANSACTION_setMasterMute = 11;
        static final int TRANSACTION_setMasterVolume = 6;
        static final int TRANSACTION_setMicrophoneMute = 19;
        static final int TRANSACTION_setMode = 25;
        static final int TRANSACTION_setRemoteStreamVolume = 5;
        static final int TRANSACTION_setRingerMode = 20;
        static final int TRANSACTION_setRingtonePlayer = 52;
        static final int TRANSACTION_setSpeakerphoneOn = 33;
        static final int TRANSACTION_setStreamMute = 8;
        static final int TRANSACTION_setStreamSolo = 7;
        static final int TRANSACTION_setStreamVolume = 4;
        static final int TRANSACTION_setVibrateSetting = 22;
        static final int TRANSACTION_setVolumeController = 59;
        static final int TRANSACTION_setWiredDeviceConnectionState = 55;
        static final int TRANSACTION_shouldVibrate = 24;
        static final int TRANSACTION_startBluetoothSco = 48;
        static final int TRANSACTION_startBluetoothScoVirtualCall = 49;
        static final int TRANSACTION_startWatchingRoutes = 57;
        static final int TRANSACTION_stopBluetoothSco = 50;
        static final int TRANSACTION_unloadSoundEffects = 30;
        static final int TRANSACTION_unregisterAudioFocusClient = 41;
        static final int TRANSACTION_unregisterAudioPolicyAsync = 66;
        static final int TRANSACTION_unregisterRemoteControlDisplay = 45;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAudioService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IAudioService) {
                return (IAudioService)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.adjustSuggestedStreamVolume(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.adjustStreamVolume(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.adjustMasterVolume(parcel.readInt(), parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setStreamVolume(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setRemoteStreamVolume(parcel.readInt());
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setMasterVolume(parcel.readInt(), parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.setStreamSolo(n3, bl, parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.setStreamMute(n4, bl, parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isStreamMute(parcel.readInt());
                    parcel2.writeNoException();
                    int n5 = 0;
                    if (bl) {
                        n5 = 1;
                    }
                    parcel2.writeInt(n5);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.forceRemoteSubmixFullVolume(bl, parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setMasterMute(bl, parcel.readInt(), parcel.readString(), parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isMasterMute();
                    parcel2.writeNoException();
                    int n6 = 0;
                    if (bl) {
                        n6 = 1;
                    }
                    parcel2.writeInt(n6);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n7 = this.getStreamVolume(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n7);
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n8 = this.getMasterVolume();
                    parcel2.writeNoException();
                    parcel2.writeInt(n8);
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n9 = this.getStreamMaxVolume(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n9);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n10 = this.getMasterMaxVolume();
                    parcel2.writeNoException();
                    parcel2.writeInt(n10);
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n11 = this.getLastAudibleStreamVolume(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n11);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n12 = this.getLastAudibleMasterVolume();
                    parcel2.writeNoException();
                    parcel2.writeInt(n12);
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setMicrophoneMute(bl, parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n13 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.setRingerMode(n13, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n14 = this.getRingerMode();
                    parcel2.writeNoException();
                    parcel2.writeInt(n14);
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setVibrateSetting(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n15 = this.getVibrateSetting(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n15);
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.shouldVibrate(parcel.readInt());
                    parcel2.writeNoException();
                    int n16 = 0;
                    if (bl) {
                        n16 = 1;
                    }
                    parcel2.writeInt(n16);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setMode(parcel.readInt(), parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n17 = this.getMode();
                    parcel2.writeNoException();
                    parcel2.writeInt(n17);
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.playSoundEffect(parcel.readInt());
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.playSoundEffectVolume(parcel.readInt(), parcel.readFloat());
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.loadSoundEffects();
                    parcel2.writeNoException();
                    int n18 = 0;
                    if (bl) {
                        n18 = 1;
                    }
                    parcel2.writeInt(n18);
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unloadSoundEffects();
                    return true;
                }
                case 31: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.reloadAudioSettings();
                    return true;
                }
                case 32: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    this.avrcpSupportsAbsoluteVolume(string2, bl);
                    return true;
                }
                case 33: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setSpeakerphoneOn(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 34: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isSpeakerphoneOn();
                    parcel2.writeNoException();
                    int n19 = 0;
                    if (bl) {
                        n19 = 1;
                    }
                    parcel2.writeInt(n19);
                    return true;
                }
                case 35: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setBluetoothScoOn(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 36: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isBluetoothScoOn();
                    parcel2.writeNoException();
                    int n20 = 0;
                    if (bl) {
                        n20 = 1;
                    }
                    parcel2.writeInt(n20);
                    return true;
                }
                case 37: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setBluetoothA2dpOn(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 38: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isBluetoothA2dpOn();
                    parcel2.writeNoException();
                    int n21 = 0;
                    if (bl) {
                        n21 = 1;
                    }
                    parcel2.writeInt(n21);
                    return true;
                }
                case 39: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n22 = this.requestAudioFocus(parcel.readInt(), parcel.readInt(), parcel.readStrongBinder(), IAudioFocusDispatcher.Stub.asInterface(parcel.readStrongBinder()), parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n22);
                    return true;
                }
                case 40: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n23 = this.abandonAudioFocus(IAudioFocusDispatcher.Stub.asInterface(parcel.readStrongBinder()), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n23);
                    return true;
                }
                case 41: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unregisterAudioFocusClient(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 42: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n24 = this.getCurrentAudioFocus();
                    parcel2.writeNoException();
                    parcel2.writeInt(n24);
                    return true;
                }
                case 43: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.registerRemoteControlDisplay(IRemoteControlDisplay.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    int n25 = 0;
                    if (bl) {
                        n25 = 1;
                    }
                    parcel2.writeInt(n25);
                    return true;
                }
                case 44: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IRemoteControlDisplay iRemoteControlDisplay = IRemoteControlDisplay.Stub.asInterface(parcel.readStrongBinder());
                    int n26 = parcel.readInt();
                    int n27 = parcel.readInt();
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.registerRemoteController(iRemoteControlDisplay, n26, n27, componentName);
                    parcel2.writeNoException();
                    int n28 = 0;
                    if (bl) {
                        n28 = 1;
                    }
                    parcel2.writeInt(n28);
                    return true;
                }
                case 45: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unregisterRemoteControlDisplay(IRemoteControlDisplay.Stub.asInterface(parcel.readStrongBinder()));
                    return true;
                }
                case 46: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt(), parcel.readInt());
                    return true;
                }
                case 47: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IRemoteControlDisplay iRemoteControlDisplay = IRemoteControlDisplay.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = parcel.readInt() != 0;
                    this.remoteControlDisplayWantsPlaybackPositionSync(iRemoteControlDisplay, bl);
                    return true;
                }
                case 48: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.startBluetoothSco(parcel.readStrongBinder(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 49: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.startBluetoothScoVirtualCall(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 50: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.stopBluetoothSco(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 51: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.forceVolumeControlStream(parcel.readInt(), parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 52: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setRingtonePlayer(IRingtonePlayer.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 53: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IRingtonePlayer iRingtonePlayer = this.getRingtonePlayer();
                    parcel2.writeNoException();
                    IBinder iBinder = iRingtonePlayer != null ? iRingtonePlayer.asBinder() : null;
                    parcel2.writeStrongBinder(iBinder);
                    return true;
                }
                case 54: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n29 = this.getMasterStreamType();
                    parcel2.writeNoException();
                    parcel2.writeInt(n29);
                    return true;
                }
                case 55: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setWiredDeviceConnectionState(parcel.readInt(), parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 56: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    int n30 = this.setBluetoothA2dpDeviceConnectionState(bluetoothDevice, parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n30);
                    return true;
                }
                case 57: {
                    parcel.enforceInterface(DESCRIPTOR);
                    AudioRoutesInfo audioRoutesInfo = this.startWatchingRoutes(IAudioRoutesObserver.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    if (audioRoutesInfo != null) {
                        parcel2.writeInt(1);
                        audioRoutesInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 58: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isCameraSoundForced();
                    parcel2.writeNoException();
                    int n31 = 0;
                    if (bl) {
                        n31 = 1;
                    }
                    parcel2.writeInt(n31);
                    return true;
                }
                case 59: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setVolumeController(IVolumeController.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 60: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IVolumeController iVolumeController = IVolumeController.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = parcel.readInt() != 0;
                    this.notifyVolumeControllerVisible(iVolumeController, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 61: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isStreamAffectedByRingerMode(parcel.readInt());
                    parcel2.writeNoException();
                    int n32 = 0;
                    if (bl) {
                        n32 = 1;
                    }
                    parcel2.writeInt(n32);
                    return true;
                }
                case 62: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.disableSafeMediaVolume();
                    parcel2.writeNoException();
                    return true;
                }
                case 63: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    int n33 = this.setHdmiSystemAudioSupported(bl);
                    parcel2.writeNoException();
                    parcel2.writeInt(n33);
                    return true;
                }
                case 64: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isHdmiSystemAudioSupported();
                    parcel2.writeNoException();
                    int n34 = 0;
                    if (bl) {
                        n34 = 1;
                    }
                    parcel2.writeInt(n34);
                    return true;
                }
                case 65: {
                    parcel.enforceInterface(DESCRIPTOR);
                    AudioPolicyConfig audioPolicyConfig = parcel.readInt() != 0 ? AudioPolicyConfig.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.registerAudioPolicy(audioPolicyConfig, parcel.readStrongBinder());
                    parcel2.writeNoException();
                    int n35 = 0;
                    if (bl) {
                        n35 = 1;
                    }
                    parcel2.writeInt(n35);
                    return true;
                }
                case 66: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.unregisterAudioPolicyAsync(parcel.readStrongBinder());
            return true;
        }

        private static class Proxy
        implements IAudioService {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int abandonAudioFocus(IAudioFocusDispatcher iAudioFocusDispatcher, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iAudioFocusDispatcher != null ? iAudioFocusDispatcher.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    this.mRemote.transact(40, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void adjustMasterVolume(int n, int n2, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeString(string2);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void adjustStreamVolume(int n, int n2, int n3, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeString(string2);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void adjustSuggestedStreamVolume(int n, int n2, int n3, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeString(string2);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void avrcpSupportsAbsoluteVolume(String string2, boolean bl) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (!bl) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(32, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void disableSafeMediaVolume() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(62, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void forceRemoteSubmixFullVolume(boolean bl, IBinder iBinder) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    parcel2.writeStrongBinder(iBinder);
                    this.mRemote.transact(10, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void forceVolumeControlStream(int n, IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(51, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getCurrentAudioFocus() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(42, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public int getLastAudibleMasterVolume() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getLastAudibleStreamVolume(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getMasterMaxVolume() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getMasterStreamType() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(54, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getMasterVolume() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getRingerMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IRingtonePlayer getRingtonePlayer() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(53, parcel, parcel2, 0);
                    parcel2.readException();
                    IRingtonePlayer iRingtonePlayer = IRingtonePlayer.Stub.asInterface(parcel2.readStrongBinder());
                    return iRingtonePlayer;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getStreamMaxVolume(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getStreamVolume(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getVibrateSetting(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean isBluetoothA2dpOn() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(38, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isBluetoothScoOn() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(36, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isCameraSoundForced() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(58, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isHdmiSystemAudioSupported() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(64, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isMasterMute() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isSpeakerphoneOn() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(34, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isStreamAffectedByRingerMode(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(61, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isStreamMute(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean loadSoundEffects() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyVolumeControllerVisible(IVolumeController iVolumeController, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iVolumeController != null ? iVolumeController.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    int n = 0;
                    if (bl) {
                        n = 1;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(60, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void playSoundEffect(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(27, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void playSoundEffectVolume(int n, float f) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeFloat(f);
                    this.mRemote.transact(28, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean registerAudioPolicy(AudioPolicyConfig audioPolicyConfig, IBinder iBinder) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (audioPolicyConfig != null) {
                                parcel2.writeInt(1);
                                audioPolicyConfig.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeStrongBinder(iBinder);
                            this.mRemote.transact(65, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean registerRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iRemoteControlDisplay != null ? iRemoteControlDisplay.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(43, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    boolean bl = false;
                    if (n3 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean registerRemoteController(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2, ComponentName componentName) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            IBinder iBinder = iRemoteControlDisplay != null ? iRemoteControlDisplay.asBinder() : null;
                            parcel2.writeStrongBinder(iBinder);
                            parcel2.writeInt(n);
                            parcel2.writeInt(n2);
                            if (componentName != null) {
                                parcel2.writeInt(1);
                                componentName.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(44, parcel2, parcel, 0);
                            parcel.readException();
                            int n3 = parcel.readInt();
                            if (n3 == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            @Override
            public void reloadAudioSettings() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(31, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = null;
                    if (iRemoteControlDisplay != null) {
                        iBinder = iRemoteControlDisplay.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(46, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void remoteControlDisplayWantsPlaybackPositionSync(IRemoteControlDisplay iRemoteControlDisplay, boolean bl) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = null;
                    if (iRemoteControlDisplay != null) {
                        iBinder = iRemoteControlDisplay.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    if (!bl) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(47, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int requestAudioFocus(int n, int n2, IBinder iBinder, IAudioFocusDispatcher iAudioFocusDispatcher, String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeStrongBinder(iBinder);
                    IBinder iBinder2 = iAudioFocusDispatcher != null ? iAudioFocusDispatcher.asBinder() : null;
                    parcel.writeStrongBinder(iBinder2);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(39, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int setBluetoothA2dpDeviceConnectionState(BluetoothDevice bluetoothDevice, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(56, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    return n3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setBluetoothA2dpOn(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(37, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setBluetoothScoOn(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(35, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public int setHdmiSystemAudioSupported(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(63, parcel2, parcel, 0);
                    parcel.readException();
                    int n2 = parcel.readInt();
                    return n2;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setMasterMute(boolean bl, int n, String string2, IBinder iBinder) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    parcel2.writeInt(n);
                    parcel2.writeString(string2);
                    parcel2.writeStrongBinder(iBinder);
                    this.mRemote.transact(11, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setMasterVolume(int n, int n2, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeString(string2);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setMicrophoneMute(boolean bl, String string2) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    parcel2.writeString(string2);
                    this.mRemote.transact(19, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setMode(int n, IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setRemoteStreamVolume(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setRingerMode(int n, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(20, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setRingtonePlayer(IRingtonePlayer iRingtonePlayer) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iRingtonePlayer != null ? iRingtonePlayer.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(52, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setSpeakerphoneOn(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(33, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setStreamMute(int n, boolean bl, IBinder iBinder) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    parcel2.writeStrongBinder(iBinder);
                    this.mRemote.transact(8, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setStreamSolo(int n, boolean bl, IBinder iBinder) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    parcel2.writeStrongBinder(iBinder);
                    this.mRemote.transact(7, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setStreamVolume(int n, int n2, int n3, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeString(string2);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setVibrateSetting(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setVolumeController(IVolumeController iVolumeController) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iVolumeController != null ? iVolumeController.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(59, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setWiredDeviceConnectionState(int n, int n2, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeString(string2);
                    this.mRemote.transact(55, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean shouldVibrate(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void startBluetoothSco(IBinder iBinder, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(48, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void startBluetoothScoVirtualCall(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(49, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver iAudioRoutesObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iAudioRoutesObserver != null ? iAudioRoutesObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(57, parcel, parcel2, 0);
                    parcel2.readException();
                    AudioRoutesInfo audioRoutesInfo = parcel2.readInt() != 0 ? AudioRoutesInfo.CREATOR.createFromParcel(parcel2) : null;
                    return audioRoutesInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void stopBluetoothSco(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(50, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void unloadSoundEffects() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(30, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void unregisterAudioFocusClient(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(41, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void unregisterAudioPolicyAsync(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(66, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unregisterRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = null;
                    if (iRemoteControlDisplay != null) {
                        iBinder = iRemoteControlDisplay.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(45, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

