/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioManager;
import android.media.AudioPatch;
import android.media.AudioPort;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

class AudioPortEventHandler {
    private static final int AUDIOPORT_EVENT_NEW_LISTENER = 4;
    private static final int AUDIOPORT_EVENT_PATCH_LIST_UPDATED = 2;
    private static final int AUDIOPORT_EVENT_PORT_LIST_UPDATED = 1;
    private static final int AUDIOPORT_EVENT_SERVICE_DIED = 3;
    private static String TAG = "AudioPortEventHandler";
    private AudioManager mAudioManager;
    private final Handler mHandler;
    private ArrayList<AudioManager.OnAudioPortUpdateListener> mListeners;

    /*
     * Enabled aggressive block sorting
     */
    AudioPortEventHandler(AudioManager audioManager) {
        this.mAudioManager = audioManager;
        this.mListeners = new ArrayList();
        Looper looper = Looper.getMainLooper();
        this.mHandler = looper != null ? new Handler(looper){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleMessage(Message message) {
                ArrayList arrayList;
                synchronized (this) {
                    if (message.what == 4) {
                        arrayList = new ArrayList();
                        if (AudioPortEventHandler.this.mListeners.contains(message.obj)) {
                            arrayList.add((AudioManager.OnAudioPortUpdateListener)message.obj);
                        }
                    } else {
                        arrayList = AudioPortEventHandler.this.mListeners;
                    }
                }
                if (arrayList.isEmpty()) return;
                if (message.what == 1 || message.what == 2 || message.what == 3) {
                    AudioPortEventHandler.this.mAudioManager.resetAudioPortGeneration();
                }
                ArrayList<AudioPort> arrayList2 = new ArrayList<AudioPort>();
                ArrayList<AudioPatch> arrayList3 = new ArrayList<AudioPatch>();
                if (message.what != 3 && AudioPortEventHandler.this.mAudioManager.updateAudioPortCache(arrayList2, arrayList3) != 0) return;
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: 
                    case 4: {
                        AudioPort[] audioPortArray = arrayList2.toArray(new AudioPort[0]);
                        for (int i = 0; i < arrayList.size(); ++i) {
                            ((AudioManager.OnAudioPortUpdateListener)arrayList.get(i)).onAudioPortListUpdate(audioPortArray);
                        }
                        if (message.what == 1) return;
                    }
                    case 2: {
                        AudioPatch[] audioPatchArray = arrayList3.toArray(new AudioPatch[0]);
                        for (int i = 0; i < arrayList.size(); ++i) {
                            ((AudioManager.OnAudioPortUpdateListener)arrayList.get(i)).onAudioPatchListUpdate(audioPatchArray);
                        }
                        return;
                    }
                    case 3: {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            ((AudioManager.OnAudioPortUpdateListener)arrayList.get(i)).onServiceDied();
                        }
                    }
                }
            }
        } : null;
        this.native_setup(new WeakReference<AudioPortEventHandler>(this));
    }

    private native void native_finalize();

    private native void native_setup(Object var1);

    /*
     * Enabled aggressive block sorting
     */
    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        Handler handler;
        AudioPortEventHandler audioPortEventHandler = (AudioPortEventHandler)((WeakReference)object).get();
        if (audioPortEventHandler == null || audioPortEventHandler == null || (handler = audioPortEventHandler.handler()) == null) {
            return;
        }
        handler.sendMessage(handler.obtainMessage(n, n2, n3, object2));
    }

    protected void finalize() {
        this.native_finalize();
    }

    Handler handler() {
        return this.mHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void registerListener(AudioManager.OnAudioPortUpdateListener onAudioPortUpdateListener) {
        // MONITORENTER : this
        this.mListeners.add(onAudioPortUpdateListener);
        // MONITOREXIT : this
        if (this.mHandler == null) return;
        Message message = this.mHandler.obtainMessage(4, 0, 0, onAudioPortUpdateListener);
        this.mHandler.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void unregisterListener(AudioManager.OnAudioPortUpdateListener onAudioPortUpdateListener) {
        synchronized (this) {
            this.mListeners.remove(onAudioPortUpdateListener);
            return;
        }
    }
}

