/*
 * Decompiled with CFR 0.152.
 */
package android.media;

public class AudioFormat {
    public static final int AUDIO_FORMAT_HAS_PROPERTY_CHANNEL_MASK = 4;
    public static final int AUDIO_FORMAT_HAS_PROPERTY_ENCODING = 1;
    public static final int AUDIO_FORMAT_HAS_PROPERTY_NONE = 0;
    public static final int AUDIO_FORMAT_HAS_PROPERTY_SAMPLE_RATE = 2;
    @Deprecated
    public static final int CHANNEL_CONFIGURATION_DEFAULT = 1;
    @Deprecated
    public static final int CHANNEL_CONFIGURATION_INVALID = 0;
    @Deprecated
    public static final int CHANNEL_CONFIGURATION_MONO = 2;
    @Deprecated
    public static final int CHANNEL_CONFIGURATION_STEREO = 3;
    public static final int CHANNEL_INVALID = 0;
    public static final int CHANNEL_IN_BACK = 32;
    public static final int CHANNEL_IN_BACK_PROCESSED = 512;
    public static final int CHANNEL_IN_DEFAULT = 1;
    public static final int CHANNEL_IN_FRONT = 16;
    public static final int CHANNEL_IN_FRONT_BACK = 48;
    public static final int CHANNEL_IN_FRONT_PROCESSED = 256;
    public static final int CHANNEL_IN_LEFT = 4;
    public static final int CHANNEL_IN_LEFT_PROCESSED = 64;
    public static final int CHANNEL_IN_MONO = 16;
    public static final int CHANNEL_IN_PRESSURE = 1024;
    public static final int CHANNEL_IN_RIGHT = 8;
    public static final int CHANNEL_IN_RIGHT_PROCESSED = 128;
    public static final int CHANNEL_IN_STEREO = 12;
    public static final int CHANNEL_IN_VOICE_DNLINK = 32768;
    public static final int CHANNEL_IN_VOICE_UPLINK = 16384;
    public static final int CHANNEL_IN_X_AXIS = 2048;
    public static final int CHANNEL_IN_Y_AXIS = 4096;
    public static final int CHANNEL_IN_Z_AXIS = 8192;
    public static final int CHANNEL_OUT_5POINT1 = 252;
    public static final int CHANNEL_OUT_5POINT1_SIDE = 6204;
    public static final int CHANNEL_OUT_7POINT1 = 1020;
    public static final int CHANNEL_OUT_7POINT1_SURROUND = 6396;
    public static final int CHANNEL_OUT_BACK_CENTER = 1024;
    public static final int CHANNEL_OUT_BACK_LEFT = 64;
    public static final int CHANNEL_OUT_BACK_RIGHT = 128;
    public static final int CHANNEL_OUT_DEFAULT = 1;
    public static final int CHANNEL_OUT_FRONT_CENTER = 16;
    public static final int CHANNEL_OUT_FRONT_LEFT = 4;
    public static final int CHANNEL_OUT_FRONT_LEFT_OF_CENTER = 256;
    public static final int CHANNEL_OUT_FRONT_RIGHT = 8;
    public static final int CHANNEL_OUT_FRONT_RIGHT_OF_CENTER = 512;
    public static final int CHANNEL_OUT_LOW_FREQUENCY = 32;
    public static final int CHANNEL_OUT_MONO = 4;
    public static final int CHANNEL_OUT_QUAD = 204;
    public static final int CHANNEL_OUT_QUAD_SIDE = 6156;
    public static final int CHANNEL_OUT_SIDE_LEFT = 2048;
    public static final int CHANNEL_OUT_SIDE_RIGHT = 4096;
    public static final int CHANNEL_OUT_STEREO = 12;
    public static final int CHANNEL_OUT_SURROUND = 1052;
    public static final int CHANNEL_OUT_TOP_BACK_CENTER = 262144;
    public static final int CHANNEL_OUT_TOP_BACK_LEFT = 131072;
    public static final int CHANNEL_OUT_TOP_BACK_RIGHT = 524288;
    public static final int CHANNEL_OUT_TOP_CENTER = 8192;
    public static final int CHANNEL_OUT_TOP_FRONT_CENTER = 32768;
    public static final int CHANNEL_OUT_TOP_FRONT_LEFT = 16384;
    public static final int CHANNEL_OUT_TOP_FRONT_RIGHT = 65536;
    public static final int ENCODING_AC3 = 5;
    public static final int ENCODING_DEFAULT = 1;
    public static final int ENCODING_E_AC3 = 6;
    public static final int ENCODING_INVALID = 0;
    public static final int ENCODING_PCM_16BIT = 2;
    public static final int ENCODING_PCM_8BIT = 3;
    public static final int ENCODING_PCM_FLOAT = 4;
    private int mChannelMask;
    private int mEncoding;
    private int mPropertySetMask;
    private int mSampleRate;

    public AudioFormat() {
        throw new UnsupportedOperationException("There is no valid usage of this constructor");
    }

    private AudioFormat(int n) {
    }

    private AudioFormat(int n, int n2, int n3) {
        this.mEncoding = n;
        this.mSampleRate = n2;
        this.mChannelMask = n3;
        this.mPropertySetMask = 7;
    }

    static /* synthetic */ int access$002(AudioFormat audioFormat, int n) {
        audioFormat.mEncoding = n;
        return n;
    }

    static /* synthetic */ int access$102(AudioFormat audioFormat, int n) {
        audioFormat.mSampleRate = n;
        return n;
    }

    static /* synthetic */ int access$202(AudioFormat audioFormat, int n) {
        audioFormat.mChannelMask = n;
        return n;
    }

    static /* synthetic */ int access$302(AudioFormat audioFormat, int n) {
        audioFormat.mPropertySetMask = n;
        return n;
    }

    public static int channelCountFromInChannelMask(int n) {
        return Integer.bitCount(n);
    }

    public static int channelCountFromOutChannelMask(int n) {
        return Integer.bitCount(n);
    }

    public static int convertChannelOutMaskToNativeMask(int n) {
        return n >> 2;
    }

    public static int convertNativeChannelMaskToOutMask(int n) {
        return n << 2;
    }

    public static int getBytesPerSample(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Bad audio format " + n);
            }
            case 3: {
                return 1;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 4: 
        }
        return 4;
    }

    public static boolean isEncodingLinearPcm(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Bad audio format " + n);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
            case 5: 
            case 6: 
        }
        return false;
    }

    public static boolean isValidEncoding(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
        }
        return true;
    }

    public int getChannelMask() {
        if ((4 & this.mPropertySetMask) == 0) {
            return 0;
        }
        return this.mChannelMask;
    }

    public int getEncoding() {
        if ((1 & this.mPropertySetMask) == 0) {
            return 0;
        }
        return this.mEncoding;
    }

    public int getPropertySetMask() {
        return this.mPropertySetMask;
    }

    public int getSampleRate() {
        if ((2 & this.mPropertySetMask) == 0) {
            return 0;
        }
        return this.mSampleRate;
    }

    public String toString() {
        return new String("AudioFormat: props=" + this.mPropertySetMask + " enc=" + this.mEncoding + " chan=0x" + Integer.toHexString(this.mChannelMask) + " rate=" + this.mSampleRate);
    }

    public static class Builder {
        private int mChannelMask = 0;
        private int mEncoding = 0;
        private int mPropertySetMask = 0;
        private int mSampleRate = 0;

        public Builder() {
        }

        public Builder(AudioFormat audioFormat) {
            this.mEncoding = audioFormat.mEncoding;
            this.mSampleRate = audioFormat.mSampleRate;
            this.mChannelMask = audioFormat.mChannelMask;
            this.mPropertySetMask = audioFormat.mPropertySetMask;
        }

        public AudioFormat build() {
            AudioFormat audioFormat = new AudioFormat(1980);
            AudioFormat.access$002(audioFormat, this.mEncoding);
            AudioFormat.access$102(audioFormat, this.mSampleRate);
            AudioFormat.access$202(audioFormat, this.mChannelMask);
            AudioFormat.access$302(audioFormat, this.mPropertySetMask);
            return audioFormat;
        }

        public Builder setChannelMask(int n) {
            this.mChannelMask = n;
            this.mPropertySetMask = 4 | this.mPropertySetMask;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder setEncoding(int n) throws IllegalArgumentException {
            switch (n) {
                default: {
                    throw new IllegalArgumentException("Invalid encoding " + n);
                }
                case 1: {
                    this.mEncoding = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.mEncoding = n;
                }
            }
            this.mPropertySetMask = 1 | this.mPropertySetMask;
            return this;
        }

        public Builder setSampleRate(int n) throws IllegalArgumentException {
            if (n <= 0 || n > 192000) {
                throw new IllegalArgumentException("Invalid sample rate " + n);
            }
            this.mSampleRate = n;
            this.mPropertySetMask = 2 | this.mPropertySetMask;
            return this;
        }
    }
}

