/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Printer;
import android.util.TimeUtils;
import java.text.DecimalFormat;
import java.util.StringTokenizer;

public class Location
implements Parcelable {
    public static final Parcelable.Creator<Location> CREATOR = new Parcelable.Creator<Location>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Location createFromParcel(Parcel parcel) {
            boolean bl = true;
            Location location = new Location(parcel.readString());
            Location.access$002(location, parcel.readLong());
            Location.access$102(location, parcel.readLong());
            Location.access$202(location, parcel.readDouble());
            Location.access$302(location, parcel.readDouble());
            boolean bl2 = parcel.readInt() != 0 ? bl : false;
            Location.access$402(location, bl2);
            Location.access$502(location, parcel.readDouble());
            boolean bl3 = parcel.readInt() != 0 ? bl : false;
            Location.access$602(location, bl3);
            Location.access$702(location, parcel.readFloat());
            boolean bl4 = parcel.readInt() != 0 ? bl : false;
            Location.access$802(location, bl4);
            Location.access$902(location, parcel.readFloat());
            boolean bl5 = parcel.readInt() != 0 ? bl : false;
            Location.access$1002(location, bl5);
            Location.access$1102(location, parcel.readFloat());
            Location.access$1202(location, parcel.readBundle());
            if (parcel.readInt() == 0) {
                bl = false;
            }
            Location.access$1302(location, bl);
            return location;
        }

        public Location[] newArray(int n) {
            return new Location[n];
        }
    };
    public static final String EXTRA_COARSE_LOCATION = "coarseLocation";
    public static final String EXTRA_NO_GPS_LOCATION = "noGPSLocation";
    public static final int FORMAT_DEGREES = 0;
    public static final int FORMAT_MINUTES = 1;
    public static final int FORMAT_SECONDS = 2;
    private float mAccuracy = 0.0f;
    private double mAltitude = 0.0;
    private float mBearing = 0.0f;
    private float mDistance = 0.0f;
    private long mElapsedRealtimeNanos = 0L;
    private Bundle mExtras = null;
    private boolean mHasAccuracy = false;
    private boolean mHasAltitude = false;
    private boolean mHasBearing = false;
    private boolean mHasSpeed = false;
    private float mInitialBearing = 0.0f;
    private boolean mIsFromMockProvider = false;
    private double mLat1 = 0.0;
    private double mLat2 = 0.0;
    private double mLatitude = 0.0;
    private double mLon1 = 0.0;
    private double mLon2 = 0.0;
    private double mLongitude = 0.0;
    private String mProvider;
    private final float[] mResults = new float[2];
    private float mSpeed = 0.0f;
    private long mTime = 0L;

    public Location(Location location) {
        this.set(location);
    }

    public Location(String string2) {
        this.mProvider = string2;
    }

    static /* synthetic */ long access$002(Location location, long l) {
        location.mTime = l;
        return l;
    }

    static /* synthetic */ boolean access$1002(Location location, boolean bl) {
        location.mHasAccuracy = bl;
        return bl;
    }

    static /* synthetic */ long access$102(Location location, long l) {
        location.mElapsedRealtimeNanos = l;
        return l;
    }

    static /* synthetic */ float access$1102(Location location, float f) {
        location.mAccuracy = f;
        return f;
    }

    static /* synthetic */ Bundle access$1202(Location location, Bundle bundle) {
        location.mExtras = bundle;
        return bundle;
    }

    static /* synthetic */ boolean access$1302(Location location, boolean bl) {
        location.mIsFromMockProvider = bl;
        return bl;
    }

    static /* synthetic */ double access$202(Location location, double d) {
        location.mLatitude = d;
        return d;
    }

    static /* synthetic */ double access$302(Location location, double d) {
        location.mLongitude = d;
        return d;
    }

    static /* synthetic */ boolean access$402(Location location, boolean bl) {
        location.mHasAltitude = bl;
        return bl;
    }

    static /* synthetic */ double access$502(Location location, double d) {
        location.mAltitude = d;
        return d;
    }

    static /* synthetic */ boolean access$602(Location location, boolean bl) {
        location.mHasSpeed = bl;
        return bl;
    }

    static /* synthetic */ float access$702(Location location, float f) {
        location.mSpeed = f;
        return f;
    }

    static /* synthetic */ boolean access$802(Location location, boolean bl) {
        location.mHasBearing = bl;
        return bl;
    }

    static /* synthetic */ float access$902(Location location, float f) {
        location.mBearing = f;
        return f;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void computeDistanceAndBearing(double d, double d2, double d3, double d4, float[] fArray) {
        double d5 = d * (Math.PI / 180);
        double d6 = d3 * (Math.PI / 180);
        double d7 = d2 * (Math.PI / 180);
        double d8 = d4 * (Math.PI / 180);
        double d9 = (6378137.0 - 6356752.3142) / 6378137.0;
        double d10 = (6378137.0 * 6378137.0 - 6356752.3142 * 6356752.3142) / (6356752.3142 * 6356752.3142);
        double d11 = d8 - d7;
        double d12 = 0.0;
        double d13 = Math.atan((1.0 - d9) * Math.tan(d5));
        double d14 = Math.atan((1.0 - d9) * Math.tan(d6));
        double d15 = Math.cos(d13);
        double d16 = Math.cos(d14);
        double d17 = Math.sin(d13);
        double d18 = Math.sin(d14);
        double d19 = d15 * d16;
        double d20 = d17 * d18;
        double d21 = 0.0;
        double d22 = 0.0;
        double d23 = 0.0;
        double d24 = 0.0;
        double d25 = d11;
        for (int i = 0; i < 20; ++i) {
            double d26 = d25;
            d23 = Math.cos(d25);
            d24 = Math.sin(d25);
            double d27 = d16 * d24;
            double d28 = d15 * d18 - d23 * (d17 * d16);
            double d29 = Math.sqrt(d27 * d27 + d28 * d28);
            double d30 = d20 + d19 * d23;
            d21 = Math.atan2(d29, d30);
            double d31 = d29 == 0.0 ? 0.0 : d19 * d24 / d29;
            double d32 = 1.0 - d31 * d31;
            double d33 = d32 == 0.0 ? 0.0 : d30 - 2.0 * d20 / d32;
            double d34 = d32 * d10;
            d12 = 1.0 + d34 / 16384.0 * (4096.0 + d34 * (-768.0 + d34 * (320.0 - 175.0 * d34)));
            double d35 = d34 / 1024.0 * (256.0 + d34 * (-128.0 + d34 * (74.0 - 47.0 * d34)));
            double d36 = d32 * (d9 / 16.0) * (4.0 + d9 * (4.0 - 3.0 * d32));
            double d37 = d33 * d33;
            d22 = d35 * d29 * (d33 + d35 / 4.0 * (d30 * (-1.0 + 2.0 * d37) - d33 * (d35 / 6.0) * (-3.0 + d29 * (4.0 * d29)) * (-3.0 + 4.0 * d37)));
            d25 = d11 + d31 * (d9 * (1.0 - d36)) * (d21 + d36 * d29 * (d33 + d36 * d30 * (-1.0 + d33 * (2.0 * d33))));
            if (Math.abs((d25 - d26) / d25) < 1.0E-12) break;
        }
        fArray[0] = (float)(6356752.3142 * d12 * (d21 - d22));
        if (fArray.length > 1) {
            fArray[1] = (float)(57.29577951308232 * (double)((float)Math.atan2(d16 * d24, d15 * d18 - d23 * (d17 * d16))));
            if (fArray.length > 2) {
                fArray[2] = (float)(57.29577951308232 * (double)((float)Math.atan2(d15 * d24, d16 * -d17 + d23 * (d15 * d18))));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double convert(String string2) {
        double d;
        double d2;
        int n;
        String string3;
        boolean bl;
        block11: {
            String string4;
            StringTokenizer stringTokenizer;
            block10: {
                double d3;
                int n2;
                if (string2 == null) {
                    throw new NullPointerException("coordinate");
                }
                char c = string2.charAt(0);
                bl = false;
                if (c == '-') {
                    string2 = string2.substring(1);
                    bl = true;
                }
                if ((n2 = (stringTokenizer = new StringTokenizer(string2, ":")).countTokens()) < 1) {
                    throw new IllegalArgumentException("coordinate=" + string2);
                }
                try {
                    string4 = stringTokenizer.nextToken();
                    if (n2 != 1) break block10;
                    d3 = Double.parseDouble(string4);
                    if (!bl) return d3;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("coordinate=" + string2);
                }
                return -d3;
            }
            string3 = stringTokenizer.nextToken();
            n = Integer.parseInt(string4);
            d2 = 0.0;
            if (!stringTokenizer.hasMoreTokens()) break block11;
            d = Integer.parseInt(string3);
            d2 = Double.parseDouble(stringTokenizer.nextToken());
        }
        d = Double.parseDouble(string3);
        boolean bl2 = bl && n == 180 && d == 0.0 && d2 == 0.0;
        if ((double)n < 0.0) throw new IllegalArgumentException("coordinate=" + string2);
        if (n > 179 && !bl2) {
            throw new IllegalArgumentException("coordinate=" + string2);
        }
        if (d < 0.0) throw new IllegalArgumentException("coordinate=" + string2);
        if (d > 59.0) {
            throw new IllegalArgumentException("coordinate=" + string2);
        }
        if (d2 < 0.0) throw new IllegalArgumentException("coordinate=" + string2);
        if (!(d2 > 59.0)) {
            double d4 = (d2 + (3600.0 * (double)n + 60.0 * d)) / 3600.0;
            if (!bl) return d4;
            return -d4;
        }
        throw new IllegalArgumentException("coordinate=" + string2);
    }

    public static String convert(double d, int n) {
        if (d < -180.0 || d > 180.0 || Double.isNaN(d)) {
            throw new IllegalArgumentException("coordinate=" + d);
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("outputType=" + n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (d < 0.0) {
            stringBuilder.append('-');
            d = -d;
        }
        DecimalFormat decimalFormat = new DecimalFormat("###.#####");
        if (n == 1 || n == 2) {
            int n2 = (int)Math.floor(d);
            stringBuilder.append(n2);
            stringBuilder.append(':');
            d = 60.0 * (d - (double)n2);
            if (n == 2) {
                int n3 = (int)Math.floor(d);
                stringBuilder.append(n3);
                stringBuilder.append(':');
                d = 60.0 * (d - (double)n3);
            }
        }
        stringBuilder.append(decimalFormat.format(d));
        return stringBuilder.toString();
    }

    public static void distanceBetween(double d, double d2, double d3, double d4, float[] fArray) {
        if (fArray == null || fArray.length < 1) {
            throw new IllegalArgumentException("results is null or has length < 1");
        }
        Location.computeDistanceAndBearing(d, d2, d3, d4, fArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float bearingTo(Location location) {
        float[] fArray = this.mResults;
        synchronized (fArray) {
            if (this.mLatitude == this.mLat1 && this.mLongitude == this.mLon1 && location.mLatitude == this.mLat2) {
                if (location.mLongitude == this.mLon2) return this.mInitialBearing;
            }
            Location.computeDistanceAndBearing(this.mLatitude, this.mLongitude, location.mLatitude, location.mLongitude, this.mResults);
            this.mLat1 = this.mLatitude;
            this.mLon1 = this.mLongitude;
            this.mLat2 = location.mLatitude;
            this.mLon2 = location.mLongitude;
            this.mDistance = this.mResults[0];
            this.mInitialBearing = this.mResults[1];
            return this.mInitialBearing;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float distanceTo(Location location) {
        float[] fArray = this.mResults;
        synchronized (fArray) {
            if (this.mLatitude == this.mLat1 && this.mLongitude == this.mLon1 && location.mLatitude == this.mLat2) {
                if (location.mLongitude == this.mLon2) return this.mDistance;
            }
            Location.computeDistanceAndBearing(this.mLatitude, this.mLongitude, location.mLatitude, location.mLongitude, this.mResults);
            this.mLat1 = this.mLatitude;
            this.mLon1 = this.mLongitude;
            this.mLat2 = location.mLatitude;
            this.mLon2 = location.mLongitude;
            this.mDistance = this.mResults[0];
            this.mInitialBearing = this.mResults[1];
            return this.mDistance;
        }
    }

    public void dump(Printer printer, String string2) {
        printer.println(string2 + this.toString());
    }

    public float getAccuracy() {
        return this.mAccuracy;
    }

    public double getAltitude() {
        return this.mAltitude;
    }

    public float getBearing() {
        return this.mBearing;
    }

    public long getElapsedRealtimeNanos() {
        return this.mElapsedRealtimeNanos;
    }

    public Location getExtraLocation(String string2) {
        Object t;
        if (this.mExtras != null && (t = this.mExtras.getParcelable(string2)) instanceof Location) {
            return (Location)t;
        }
        return null;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public String getProvider() {
        return this.mProvider;
    }

    public float getSpeed() {
        return this.mSpeed;
    }

    public long getTime() {
        return this.mTime;
    }

    public boolean hasAccuracy() {
        return this.mHasAccuracy;
    }

    public boolean hasAltitude() {
        return this.mHasAltitude;
    }

    public boolean hasBearing() {
        return this.mHasBearing;
    }

    public boolean hasSpeed() {
        return this.mHasSpeed;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isComplete() {
        return this.mProvider != null && this.mHasAccuracy && this.mTime != 0L && this.mElapsedRealtimeNanos != 0L;
    }

    public boolean isFromMockProvider() {
        return this.mIsFromMockProvider;
    }

    public void makeComplete() {
        if (this.mProvider == null) {
            this.mProvider = "?";
        }
        if (!this.mHasAccuracy) {
            this.mHasAccuracy = true;
            this.mAccuracy = 100.0f;
        }
        if (this.mTime == 0L) {
            this.mTime = System.currentTimeMillis();
        }
        if (this.mElapsedRealtimeNanos == 0L) {
            this.mElapsedRealtimeNanos = SystemClock.elapsedRealtimeNanos();
        }
    }

    public void removeAccuracy() {
        this.mAccuracy = 0.0f;
        this.mHasAccuracy = false;
    }

    public void removeAltitude() {
        this.mAltitude = 0.0;
        this.mHasAltitude = false;
    }

    public void removeBearing() {
        this.mBearing = 0.0f;
        this.mHasBearing = false;
    }

    public void removeSpeed() {
        this.mSpeed = 0.0f;
        this.mHasSpeed = false;
    }

    public void reset() {
        this.mProvider = null;
        this.mTime = 0L;
        this.mElapsedRealtimeNanos = 0L;
        this.mLatitude = 0.0;
        this.mLongitude = 0.0;
        this.mHasAltitude = false;
        this.mAltitude = 0.0;
        this.mHasSpeed = false;
        this.mSpeed = 0.0f;
        this.mHasBearing = false;
        this.mBearing = 0.0f;
        this.mHasAccuracy = false;
        this.mAccuracy = 0.0f;
        this.mExtras = null;
        this.mIsFromMockProvider = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void set(Location location) {
        this.mProvider = location.mProvider;
        this.mTime = location.mTime;
        this.mElapsedRealtimeNanos = location.mElapsedRealtimeNanos;
        this.mLatitude = location.mLatitude;
        this.mLongitude = location.mLongitude;
        this.mHasAltitude = location.mHasAltitude;
        this.mAltitude = location.mAltitude;
        this.mHasSpeed = location.mHasSpeed;
        this.mSpeed = location.mSpeed;
        this.mHasBearing = location.mHasBearing;
        this.mBearing = location.mBearing;
        this.mHasAccuracy = location.mHasAccuracy;
        this.mAccuracy = location.mAccuracy;
        Bundle bundle = location.mExtras == null ? null : new Bundle(location.mExtras);
        this.mExtras = bundle;
        this.mIsFromMockProvider = location.mIsFromMockProvider;
    }

    public void setAccuracy(float f) {
        this.mAccuracy = f;
        this.mHasAccuracy = true;
    }

    public void setAltitude(double d) {
        this.mAltitude = d;
        this.mHasAltitude = true;
    }

    public void setBearing(float f) {
        while (f < 0.0f) {
            f += 360.0f;
        }
        while (f >= 360.0f) {
            f -= 360.0f;
        }
        this.mBearing = f;
        this.mHasBearing = true;
    }

    public void setElapsedRealtimeNanos(long l) {
        this.mElapsedRealtimeNanos = l;
    }

    public void setExtraLocation(String string2, Location location) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putParcelable(string2, location);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setExtras(Bundle bundle) {
        Bundle bundle2 = bundle == null ? null : new Bundle(bundle);
        this.mExtras = bundle2;
    }

    public void setIsFromMockProvider(boolean bl) {
        this.mIsFromMockProvider = bl;
    }

    public void setLatitude(double d) {
        this.mLatitude = d;
    }

    public void setLongitude(double d) {
        this.mLongitude = d;
    }

    public void setProvider(String string2) {
        this.mProvider = string2;
    }

    public void setSpeed(float f) {
        this.mSpeed = f;
        this.mHasSpeed = true;
    }

    public void setTime(long l) {
        this.mTime = l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Location[");
        stringBuilder.append(this.mProvider);
        Object[] objectArray = new Object[]{this.mLatitude, this.mLongitude};
        stringBuilder.append(String.format(" %.6f,%.6f", objectArray));
        if (this.mHasAccuracy) {
            Object[] objectArray2 = new Object[]{Float.valueOf(this.mAccuracy)};
            stringBuilder.append(String.format(" acc=%.0f", objectArray2));
        } else {
            stringBuilder.append(" acc=???");
        }
        if (this.mTime == 0L) {
            stringBuilder.append(" t=?!?");
        }
        if (this.mElapsedRealtimeNanos == 0L) {
            stringBuilder.append(" et=?!?");
        } else {
            stringBuilder.append(" et=");
            TimeUtils.formatDuration(this.mElapsedRealtimeNanos / 1000000L, stringBuilder);
        }
        if (this.mHasAltitude) {
            stringBuilder.append(" alt=").append(this.mAltitude);
        }
        if (this.mHasSpeed) {
            stringBuilder.append(" vel=").append(this.mSpeed);
        }
        if (this.mHasBearing) {
            stringBuilder.append(" bear=").append(this.mBearing);
        }
        if (this.mIsFromMockProvider) {
            stringBuilder.append(" mock");
        }
        if (this.mExtras != null) {
            stringBuilder.append(" {").append(this.mExtras).append('}');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeString(this.mProvider);
        parcel.writeLong(this.mTime);
        parcel.writeLong(this.mElapsedRealtimeNanos);
        parcel.writeDouble(this.mLatitude);
        parcel.writeDouble(this.mLongitude);
        int n3 = this.mHasAltitude ? n2 : 0;
        parcel.writeInt(n3);
        parcel.writeDouble(this.mAltitude);
        int n4 = this.mHasSpeed ? n2 : 0;
        parcel.writeInt(n4);
        parcel.writeFloat(this.mSpeed);
        int n5 = this.mHasBearing ? n2 : 0;
        parcel.writeInt(n5);
        parcel.writeFloat(this.mBearing);
        int n6 = this.mHasAccuracy ? n2 : 0;
        parcel.writeInt(n6);
        parcel.writeFloat(this.mAccuracy);
        parcel.writeBundle(this.mExtras);
        if (!this.mIsFromMockProvider) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }
}

