/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.GpsSatellite;
import android.os.SystemProperties;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class GpsStatus {
    public static final int GPS_EVENT_FIRST_FIX = 3;
    public static final int GPS_EVENT_SATELLITE_STATUS = 4;
    public static final int GPS_EVENT_STARTED = 1;
    public static final int GPS_EVENT_STOPPED = 2;
    private static final int NUM_SATELLITES = 255;
    private static final boolean mGnssSvStatus = Boolean.parseBoolean(SystemProperties.get("ro.gnss.sv.status"));
    private Iterable<GpsSatellite> mSatelliteList;
    private GpsSatellite[] mSatellites = new GpsSatellite[255];
    private int mTimeToFirstFix;

    GpsStatus() {
        this.mSatelliteList = new Iterable<GpsSatellite>(){

            @Override
            public Iterator<GpsSatellite> iterator() {
                return new SatelliteIterator(GpsStatus.this.mSatellites);
            }
        };
        for (int i = 0; i < this.mSatellites.length; ++i) {
            this.mSatellites[i] = new GpsSatellite(i + 1);
        }
    }

    public int getMaxSatellites() {
        return 255;
    }

    public Iterable<GpsSatellite> getSatellites() {
        return this.mSatelliteList;
    }

    public int getTimeToFirstFix() {
        return this.mTimeToFirstFix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setStatus(int n, int[] nArray, float[] fArray, float[] fArray2, float[] fArray3, int n2, int n3, int n4) {
        synchronized (this) {
            for (int i = 0; i < this.mSatellites.length; ++i) {
                this.mSatellites[i].mValid = false;
            }
            int n5 = 0;
            while (n5 < n) {
                int n6 = -1 + nArray[n5];
                int n7 = 1 << n5;
                if (n6 >= 0 && n6 < this.mSatellites.length) {
                    GpsSatellite gpsSatellite = this.mSatellites[n6];
                    gpsSatellite.mValid = true;
                    gpsSatellite.mSnr = fArray[n5];
                    gpsSatellite.mElevation = fArray2[n5];
                    gpsSatellite.mAzimuth = fArray3[n5];
                    boolean bl = (n2 & n7) != 0;
                    gpsSatellite.mHasEphemeris = bl;
                    boolean bl2 = (n3 & n7) != 0;
                    gpsSatellite.mHasAlmanac = bl2;
                    boolean bl3 = (n4 & n7) != 0;
                    gpsSatellite.mUsedInFix = bl3;
                }
                ++n5;
            }
            return;
        }
    }

    void setStatus(GpsStatus gpsStatus) {
        this.mTimeToFirstFix = gpsStatus.getTimeToFirstFix();
        for (int i = 0; i < this.mSatellites.length; ++i) {
            this.mSatellites[i].setStatus(gpsStatus.mSatellites[i]);
        }
    }

    void setTimeToFirstFix(int n) {
        this.mTimeToFirstFix = n;
    }

    public static interface Listener {
        public void onGpsStatusChanged(int var1);
    }

    public static interface NmeaListener {
        public void onNmeaReceived(long var1, String var3);
    }

    private final class SatelliteIterator
    implements Iterator<GpsSatellite> {
        int mIndex = 0;
        private GpsSatellite[] mSatellites;

        SatelliteIterator(GpsSatellite[] gpsSatelliteArray) {
            this.mSatellites = gpsSatelliteArray;
        }

        @Override
        public boolean hasNext() {
            for (int i = this.mIndex; i < this.mSatellites.length; ++i) {
                if (!this.mSatellites[i].mValid) continue;
                return true;
            }
            return false;
        }

        @Override
        public GpsSatellite next() {
            while (this.mIndex < this.mSatellites.length) {
                GpsSatellite[] gpsSatelliteArray = this.mSatellites;
                int n = this.mIndex;
                this.mIndex = n + 1;
                GpsSatellite gpsSatellite = gpsSatelliteArray[n];
                if (!gpsSatellite.mValid) continue;
                return gpsSatellite;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

