/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;

public final class Geofence
implements Parcelable {
    public static final Parcelable.Creator<Geofence> CREATOR = new Parcelable.Creator<Geofence>(){

        @Override
        public Geofence createFromParcel(Parcel parcel) {
            int n = parcel.readInt();
            double d = parcel.readDouble();
            double d2 = parcel.readDouble();
            float f = parcel.readFloat();
            Geofence.checkType(n);
            return Geofence.createCircle(d, d2, f);
        }

        public Geofence[] newArray(int n) {
            return new Geofence[n];
        }
    };
    public static final int TYPE_HORIZONTAL_CIRCLE = 1;
    private final double mLatitude;
    private final double mLongitude;
    private final float mRadius;
    private final int mType;

    private Geofence(double d, double d2, float f) {
        Geofence.checkRadius(f);
        Geofence.checkLatLong(d, d2);
        this.mType = 1;
        this.mLatitude = d;
        this.mLongitude = d2;
        this.mRadius = f;
    }

    private static void checkLatLong(double d, double d2) {
        if (d > 90.0 || d < -90.0) {
            throw new IllegalArgumentException("invalid latitude: " + d);
        }
        if (d2 > 180.0 || d2 < -180.0) {
            throw new IllegalArgumentException("invalid longitude: " + d2);
        }
    }

    private static void checkRadius(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("invalid radius: " + f);
        }
    }

    private static void checkType(int n) {
        if (n != 1) {
            throw new IllegalArgumentException("invalid type: " + n);
        }
    }

    public static Geofence createCircle(double d, double d2, float f) {
        return new Geofence(d, d2, f);
    }

    private static String typeToString(int n) {
        switch (n) {
            default: {
                Geofence.checkType(n);
                return null;
            }
            case 1: 
        }
        return "CIRCLE";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block9: {
            block8: {
                if (this == object) break block8;
                if (object == null) {
                    return false;
                }
                if (!(object instanceof Geofence)) {
                    return false;
                }
                Geofence geofence = (Geofence)object;
                if (this.mRadius != geofence.mRadius) {
                    return false;
                }
                if (this.mLatitude != geofence.mLatitude) {
                    return false;
                }
                if (this.mLongitude != geofence.mLongitude) {
                    return false;
                }
                if (this.mType != geofence.mType) break block9;
            }
            return true;
        }
        return false;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public float getRadius() {
        return this.mRadius;
    }

    public int getType() {
        return this.mType;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.mLatitude);
        int n = 31 + (int)(l ^ l >>> 32);
        long l2 = Double.doubleToLongBits(this.mLongitude);
        return 31 * (31 * (n * 31 + (int)(l2 ^ l2 >>> 32)) + Float.floatToIntBits(this.mRadius)) + this.mType;
    }

    public String toString() {
        Object[] objectArray = new Object[]{Geofence.typeToString(this.mType), this.mLatitude, this.mLongitude, Float.valueOf(this.mRadius)};
        return String.format("Geofence[%s %.6f, %.6f %.0fm]", objectArray);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mType);
        parcel.writeDouble(this.mLatitude);
        parcel.writeDouble(this.mLongitude);
        parcel.writeFloat(this.mRadius);
    }
}

