/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;

public class Criteria
implements Parcelable {
    public static final int ACCURACY_COARSE = 2;
    public static final int ACCURACY_FINE = 1;
    public static final int ACCURACY_HIGH = 3;
    public static final int ACCURACY_LOW = 1;
    public static final int ACCURACY_MEDIUM = 2;
    public static final Parcelable.Creator<Criteria> CREATOR = new Parcelable.Creator<Criteria>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Criteria createFromParcel(Parcel parcel) {
            boolean bl = true;
            Criteria criteria = new Criteria();
            Criteria.access$002(criteria, parcel.readInt());
            Criteria.access$102(criteria, parcel.readInt());
            Criteria.access$202(criteria, parcel.readInt());
            Criteria.access$302(criteria, parcel.readInt());
            Criteria.access$402(criteria, parcel.readInt());
            boolean bl2 = parcel.readInt() != 0 ? bl : false;
            Criteria.access$502(criteria, bl2);
            boolean bl3 = parcel.readInt() != 0 ? bl : false;
            Criteria.access$602(criteria, bl3);
            boolean bl4 = parcel.readInt() != 0 ? bl : false;
            Criteria.access$702(criteria, bl4);
            if (parcel.readInt() == 0) {
                bl = false;
            }
            Criteria.access$802(criteria, bl);
            return criteria;
        }

        public Criteria[] newArray(int n) {
            return new Criteria[n];
        }
    };
    public static final int NO_REQUIREMENT = 0;
    public static final int POWER_HIGH = 3;
    public static final int POWER_LOW = 1;
    public static final int POWER_MEDIUM = 2;
    private boolean mAltitudeRequired = false;
    private int mBearingAccuracy = 0;
    private boolean mBearingRequired = false;
    private boolean mCostAllowed = false;
    private int mHorizontalAccuracy = 0;
    private int mPowerRequirement = 0;
    private int mSpeedAccuracy = 0;
    private boolean mSpeedRequired = false;
    private int mVerticalAccuracy = 0;

    public Criteria() {
    }

    public Criteria(Criteria criteria) {
        this.mHorizontalAccuracy = criteria.mHorizontalAccuracy;
        this.mVerticalAccuracy = criteria.mVerticalAccuracy;
        this.mSpeedAccuracy = criteria.mSpeedAccuracy;
        this.mBearingAccuracy = criteria.mBearingAccuracy;
        this.mPowerRequirement = criteria.mPowerRequirement;
        this.mAltitudeRequired = criteria.mAltitudeRequired;
        this.mBearingRequired = criteria.mBearingRequired;
        this.mSpeedRequired = criteria.mSpeedRequired;
        this.mCostAllowed = criteria.mCostAllowed;
    }

    static /* synthetic */ int access$002(Criteria criteria, int n) {
        criteria.mHorizontalAccuracy = n;
        return n;
    }

    static /* synthetic */ int access$102(Criteria criteria, int n) {
        criteria.mVerticalAccuracy = n;
        return n;
    }

    static /* synthetic */ int access$202(Criteria criteria, int n) {
        criteria.mSpeedAccuracy = n;
        return n;
    }

    static /* synthetic */ int access$302(Criteria criteria, int n) {
        criteria.mBearingAccuracy = n;
        return n;
    }

    static /* synthetic */ int access$402(Criteria criteria, int n) {
        criteria.mPowerRequirement = n;
        return n;
    }

    static /* synthetic */ boolean access$502(Criteria criteria, boolean bl) {
        criteria.mAltitudeRequired = bl;
        return bl;
    }

    static /* synthetic */ boolean access$602(Criteria criteria, boolean bl) {
        criteria.mBearingRequired = bl;
        return bl;
    }

    static /* synthetic */ boolean access$702(Criteria criteria, boolean bl) {
        criteria.mSpeedRequired = bl;
        return bl;
    }

    static /* synthetic */ boolean access$802(Criteria criteria, boolean bl) {
        criteria.mCostAllowed = bl;
        return bl;
    }

    private static String accuracyToString(int n) {
        switch (n) {
            default: {
                return "???";
            }
            case 0: {
                return "---";
            }
            case 3: {
                return "HIGH";
            }
            case 2: {
                return "MEDIUM";
            }
            case 1: 
        }
        return "LOW";
    }

    private static String powerToString(int n) {
        switch (n) {
            default: {
                return "???";
            }
            case 0: {
                return "NO_REQ";
            }
            case 1: {
                return "LOW";
            }
            case 2: {
                return "MEDIUM";
            }
            case 3: 
        }
        return "HIGH";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getAccuracy() {
        if (this.mHorizontalAccuracy >= 3) {
            return 1;
        }
        return 2;
    }

    public int getBearingAccuracy() {
        return this.mBearingAccuracy;
    }

    public int getHorizontalAccuracy() {
        return this.mHorizontalAccuracy;
    }

    public int getPowerRequirement() {
        return this.mPowerRequirement;
    }

    public int getSpeedAccuracy() {
        return this.mSpeedAccuracy;
    }

    public int getVerticalAccuracy() {
        return this.mVerticalAccuracy;
    }

    public boolean isAltitudeRequired() {
        return this.mAltitudeRequired;
    }

    public boolean isBearingRequired() {
        return this.mBearingRequired;
    }

    public boolean isCostAllowed() {
        return this.mCostAllowed;
    }

    public boolean isSpeedRequired() {
        return this.mSpeedRequired;
    }

    public void setAccuracy(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("accuracy=" + n);
        }
        if (n == 1) {
            this.mHorizontalAccuracy = 3;
            return;
        }
        this.mHorizontalAccuracy = 1;
    }

    public void setAltitudeRequired(boolean bl) {
        this.mAltitudeRequired = bl;
    }

    public void setBearingAccuracy(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("accuracy=" + n);
        }
        this.mBearingAccuracy = n;
    }

    public void setBearingRequired(boolean bl) {
        this.mBearingRequired = bl;
    }

    public void setCostAllowed(boolean bl) {
        this.mCostAllowed = bl;
    }

    public void setHorizontalAccuracy(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("accuracy=" + n);
        }
        this.mHorizontalAccuracy = n;
    }

    public void setPowerRequirement(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("level=" + n);
        }
        this.mPowerRequirement = n;
    }

    public void setSpeedAccuracy(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("accuracy=" + n);
        }
        this.mSpeedAccuracy = n;
    }

    public void setSpeedRequired(boolean bl) {
        this.mSpeedRequired = bl;
    }

    public void setVerticalAccuracy(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("accuracy=" + n);
        }
        this.mVerticalAccuracy = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Criteria[power=").append(Criteria.powerToString(this.mPowerRequirement));
        stringBuilder.append(" acc=").append(Criteria.accuracyToString(this.mHorizontalAccuracy));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeInt(this.mHorizontalAccuracy);
        parcel.writeInt(this.mVerticalAccuracy);
        parcel.writeInt(this.mSpeedAccuracy);
        parcel.writeInt(this.mBearingAccuracy);
        parcel.writeInt(this.mPowerRequirement);
        int n3 = this.mAltitudeRequired ? n2 : 0;
        parcel.writeInt(n3);
        int n4 = this.mBearingRequired ? n2 : 0;
        parcel.writeInt(n4);
        int n5 = this.mSpeedRequired ? n2 : 0;
        parcel.writeInt(n5);
        if (!this.mCostAllowed) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }
}

