/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Rect;
import android.os.IBinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.WindowManager;

public class SoftInputWindow
extends Dialog {
    private final Rect mBounds = new Rect();
    final Callback mCallback;
    final KeyEvent.DispatcherState mDispatcherState;
    final int mGravity;
    final KeyEvent.Callback mKeyEventCallback;
    final String mName;
    final boolean mTakesFocus;
    final int mWindowType;

    public SoftInputWindow(Context context, String string2, int n, Callback callback, KeyEvent.Callback callback2, KeyEvent.DispatcherState dispatcherState, int n2, int n3, boolean bl) {
        super(context, n);
        this.mName = string2;
        this.mCallback = callback;
        this.mKeyEventCallback = callback2;
        this.mDispatcherState = dispatcherState;
        this.mWindowType = n2;
        this.mGravity = n3;
        this.mTakesFocus = bl;
        this.initDockWindow();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initDockWindow() {
        int n;
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        layoutParams.type = this.mWindowType;
        layoutParams.setTitle(this.mName);
        layoutParams.gravity = this.mGravity;
        this.updateWidthHeight(layoutParams);
        this.getWindow().setAttributes(layoutParams);
        int n2 = 266;
        if (!this.mTakesFocus) {
            n = 0x100 | 8;
        } else {
            n = 0x100 | 0x20;
            n2 |= 0x20;
        }
        this.getWindow().setFlags(n, n2);
    }

    private void updateWidthHeight(WindowManager.LayoutParams layoutParams) {
        if (layoutParams.gravity == 48 || layoutParams.gravity == 80) {
            layoutParams.width = -1;
            layoutParams.height = -2;
            return;
        }
        layoutParams.width = -2;
        layoutParams.height = -1;
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        this.getWindow().getDecorView().getHitRect(this.mBounds);
        if (motionEvent.isWithinBoundsNoHistory(this.mBounds.left, this.mBounds.top, -1 + this.mBounds.right, -1 + this.mBounds.bottom)) {
            return super.dispatchTouchEvent(motionEvent);
        }
        MotionEvent motionEvent2 = motionEvent.clampNoHistory(this.mBounds.left, this.mBounds.top, -1 + this.mBounds.right, -1 + this.mBounds.bottom);
        boolean bl = super.dispatchTouchEvent(motionEvent2);
        motionEvent2.recycle();
        return bl;
    }

    public int getGravity() {
        return this.getWindow().getAttributes().gravity;
    }

    @Override
    public void onBackPressed() {
        if (this.mCallback != null) {
            this.mCallback.onBackPressed();
            return;
        }
        super.onBackPressed();
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (this.mKeyEventCallback != null && this.mKeyEventCallback.onKeyDown(n, keyEvent)) {
            return true;
        }
        return super.onKeyDown(n, keyEvent);
    }

    @Override
    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        if (this.mKeyEventCallback != null && this.mKeyEventCallback.onKeyLongPress(n, keyEvent)) {
            return true;
        }
        return super.onKeyLongPress(n, keyEvent);
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        if (this.mKeyEventCallback != null && this.mKeyEventCallback.onKeyMultiple(n, n2, keyEvent)) {
            return true;
        }
        return super.onKeyMultiple(n, n2, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (this.mKeyEventCallback != null && this.mKeyEventCallback.onKeyUp(n, keyEvent)) {
            return true;
        }
        return super.onKeyUp(n, keyEvent);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        this.mDispatcherState.reset();
    }

    public void setGravity(int n) {
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        layoutParams.gravity = n;
        this.updateWidthHeight(layoutParams);
        this.getWindow().setAttributes(layoutParams);
    }

    public void setToken(IBinder iBinder) {
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        layoutParams.token = iBinder;
        this.getWindow().setAttributes(layoutParams);
    }

    public static interface Callback {
        public void onBackPressed();
    }
}

