/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.inputmethodservice.InputMethodService;
import android.util.AttributeSet;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;

public class ExtractEditText
extends EditText {
    private InputMethodService mIME;
    private int mSettingExtractedText;

    public ExtractEditText(Context context) {
        super(context, null);
    }

    public ExtractEditText(Context context, AttributeSet attributeSet) {
        super(context, attributeSet, 16842862);
    }

    public ExtractEditText(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public ExtractEditText(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
    }

    @Override
    protected void deleteText_internal(int n, int n2) {
        this.mIME.onExtractedDeleteText(n, n2);
    }

    public void finishInternalChanges() {
        this.mSettingExtractedText = -1 + this.mSettingExtractedText;
    }

    @Override
    public boolean hasFocus() {
        return this.isEnabled();
    }

    public boolean hasVerticalScrollBar() {
        return this.computeVerticalScrollRange() > this.computeVerticalScrollExtent();
    }

    @Override
    public boolean hasWindowFocus() {
        return this.isEnabled();
    }

    @Override
    public boolean isFocused() {
        return this.isEnabled();
    }

    @Override
    public boolean isInputMethodTarget() {
        return true;
    }

    @Override
    protected void onSelectionChanged(int n, int n2) {
        if (this.mSettingExtractedText == 0 && this.mIME != null && n >= 0 && n2 >= 0) {
            this.mIME.onExtractedSelectionChanged(n, n2);
        }
    }

    @Override
    public boolean onTextContextMenuItem(int n) {
        if (this.mIME != null && this.mIME.onExtractTextContextMenuItem(n)) {
            if (n == 0x1020021) {
                this.stopSelectionActionMode();
            }
            if (n == 17041117 || n == 17041118 || n == 17041119) {
                this.stopSelectionActionMode();
            }
            return true;
        }
        return super.onTextContextMenuItem(n);
    }

    @Override
    public boolean performClick() {
        if (!super.performClick() && this.mIME != null) {
            this.mIME.onExtractedTextClicked();
            return true;
        }
        return false;
    }

    @Override
    protected void replaceText_internal(int n, int n2, CharSequence charSequence) {
        this.mIME.onExtractedReplaceText(n, n2, charSequence);
    }

    @Override
    protected void setCursorPosition_internal(int n, int n2) {
        this.mIME.onExtractedSelectionChanged(n, n2);
    }

    @Override
    public void setExtractedText(ExtractedText extractedText) {
        try {
            this.mSettingExtractedText = 1 + this.mSettingExtractedText;
            super.setExtractedText(extractedText);
            return;
        }
        finally {
            this.mSettingExtractedText = -1 + this.mSettingExtractedText;
        }
    }

    void setIME(InputMethodService inputMethodService) {
        this.mIME = inputMethodService;
    }

    @Override
    protected void setSpan_internal(Object object, int n, int n2, int n3) {
        this.mIME.onExtractedSetSpan(object, n, n2, n3);
    }

    public void startInternalChanges() {
        this.mSettingExtractedText = 1 + this.mSettingExtractedText;
    }

    @Override
    protected void viewClicked(InputMethodManager inputMethodManager) {
        if (this.mIME != null) {
            this.mIME.onViewClicked(false);
        }
    }
}

