/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.soundtrigger;

import android.hardware.soundtrigger.SoundTriggerModule;
import android.media.AudioFormat;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;

public class SoundTrigger {
    public static final int RECOGNITION_MODE_USER_AUTHENTICATION = 4;
    public static final int RECOGNITION_MODE_USER_IDENTIFICATION = 2;
    public static final int RECOGNITION_MODE_VOICE_TRIGGER = 1;
    public static final int RECOGNITION_STATUS_ABORT = 1;
    public static final int RECOGNITION_STATUS_FAILURE = 2;
    public static final int RECOGNITION_STATUS_SUCCESS = 0;
    public static final int SERVICE_STATE_DISABLED = 1;
    public static final int SERVICE_STATE_ENABLED = 0;
    public static final int SOUNDMODEL_STATUS_UPDATED = 0;
    public static final int STATUS_BAD_VALUE = -22;
    public static final int STATUS_DEAD_OBJECT = -32;
    public static final int STATUS_ERROR = Integer.MIN_VALUE;
    public static final int STATUS_INVALID_OPERATION = -38;
    public static final int STATUS_NO_INIT = -19;
    public static final int STATUS_OK = 0;
    public static final int STATUS_PERMISSION_DENIED = -1;

    public static SoundTriggerModule attachModule(int n, StatusListener statusListener, Handler handler) {
        if (statusListener == null) {
            return null;
        }
        return new SoundTriggerModule(n, statusListener, handler);
    }

    public static native int listModules(ArrayList<ModuleProperties> var0);

    public static class ConfidenceLevel
    implements Parcelable {
        public static final Parcelable.Creator<ConfidenceLevel> CREATOR = new Parcelable.Creator<ConfidenceLevel>(){

            @Override
            public ConfidenceLevel createFromParcel(Parcel parcel) {
                return ConfidenceLevel.fromParcel(parcel);
            }

            public ConfidenceLevel[] newArray(int n) {
                return new ConfidenceLevel[n];
            }
        };
        public final int confidenceLevel;
        public final int userId;

        public ConfidenceLevel(int n, int n2) {
            this.userId = n;
            this.confidenceLevel = n2;
        }

        private static ConfidenceLevel fromParcel(Parcel parcel) {
            return new ConfidenceLevel(parcel.readInt(), parcel.readInt());
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block7: {
                block6: {
                    if (this == object) break block6;
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    ConfidenceLevel confidenceLevel = (ConfidenceLevel)object;
                    if (this.confidenceLevel != confidenceLevel.confidenceLevel) {
                        return false;
                    }
                    if (this.userId != confidenceLevel.userId) break block7;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return 31 * (31 + this.confidenceLevel) + this.userId;
        }

        public String toString() {
            return "ConfidenceLevel [userId=" + this.userId + ", confidenceLevel=" + this.confidenceLevel + "]";
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.userId);
            parcel.writeInt(this.confidenceLevel);
        }
    }

    public static class Keyphrase
    implements Parcelable {
        public static final Parcelable.Creator<Keyphrase> CREATOR = new Parcelable.Creator<Keyphrase>(){

            @Override
            public Keyphrase createFromParcel(Parcel parcel) {
                return Keyphrase.fromParcel(parcel);
            }

            public Keyphrase[] newArray(int n) {
                return new Keyphrase[n];
            }
        };
        public final int id;
        public final String locale;
        public final int recognitionModes;
        public final String text;
        public final int[] users;

        public Keyphrase(int n, int n2, String string2, String string3, int[] nArray) {
            this.id = n;
            this.recognitionModes = n2;
            this.locale = string2;
            this.text = string3;
            this.users = nArray;
        }

        private static Keyphrase fromParcel(Parcel parcel) {
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            int n3 = parcel.readInt();
            int[] nArray = null;
            if (n3 >= 0) {
                nArray = new int[n3];
                parcel.readIntArray(nArray);
            }
            return new Keyphrase(n, n2, string2, string3, nArray);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block10: {
                block9: {
                    if (this == object) break block9;
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    Keyphrase keyphrase = (Keyphrase)object;
                    if (this.text == null ? keyphrase.text != null : !this.text.equals(keyphrase.text)) {
                        return false;
                    }
                    if (this.id != keyphrase.id) {
                        return false;
                    }
                    if (this.locale == null ? keyphrase.locale != null : !this.locale.equals(keyphrase.locale)) {
                        return false;
                    }
                    if (this.recognitionModes != keyphrase.recognitionModes) {
                        return false;
                    }
                    if (!Arrays.equals(this.users, keyphrase.users)) break block10;
                }
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public int hashCode() {
            int n = this.text == null ? 0 : this.text.hashCode();
            int n2 = 31 * (31 * (n + 31) + this.id);
            String string2 = this.locale;
            int n3 = 0;
            if (string2 == null) {
                return 31 * (31 * (n2 + n3) + this.recognitionModes) + Arrays.hashCode(this.users);
            }
            n3 = this.locale.hashCode();
            return 31 * (31 * (n2 + n3) + this.recognitionModes) + Arrays.hashCode(this.users);
        }

        public String toString() {
            return "Keyphrase [id=" + this.id + ", recognitionModes=" + this.recognitionModes + ", locale=" + this.locale + ", text=" + this.text + ", users=" + Arrays.toString(this.users) + "]";
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.id);
            parcel.writeInt(this.recognitionModes);
            parcel.writeString(this.locale);
            parcel.writeString(this.text);
            if (this.users != null) {
                parcel.writeInt(this.users.length);
                parcel.writeIntArray(this.users);
                return;
            }
            parcel.writeInt(-1);
        }
    }

    public static class KeyphraseRecognitionEvent
    extends RecognitionEvent {
        public static final Parcelable.Creator<KeyphraseRecognitionEvent> CREATOR = new Parcelable.Creator<KeyphraseRecognitionEvent>(){

            @Override
            public KeyphraseRecognitionEvent createFromParcel(Parcel parcel) {
                return KeyphraseRecognitionEvent.fromParcel(parcel);
            }

            public KeyphraseRecognitionEvent[] newArray(int n) {
                return new KeyphraseRecognitionEvent[n];
            }
        };
        public final KeyphraseRecognitionExtra[] keyphraseExtras;

        public KeyphraseRecognitionEvent(int n, int n2, boolean bl, int n3, int n4, int n5, boolean bl2, AudioFormat audioFormat, byte[] byArray, KeyphraseRecognitionExtra[] keyphraseRecognitionExtraArray) {
            super(n, n2, bl, n3, n4, n5, bl2, audioFormat, byArray);
            this.keyphraseExtras = keyphraseRecognitionExtraArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        private static KeyphraseRecognitionEvent fromParcel(Parcel parcel) {
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            boolean bl = parcel.readByte() == 1;
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            int n5 = parcel.readInt();
            boolean bl2 = parcel.readByte() == 1;
            byte by = parcel.readByte();
            AudioFormat audioFormat = null;
            if (by == 1) {
                int n6 = parcel.readInt();
                int n7 = parcel.readInt();
                int n8 = parcel.readInt();
                audioFormat = new AudioFormat.Builder().setChannelMask(n8).setEncoding(n7).setSampleRate(n6).build();
            }
            return new KeyphraseRecognitionEvent(n, n2, bl, n3, n4, n5, bl2, audioFormat, parcel.readBlob(), parcel.createTypedArray(KeyphraseRecognitionExtra.CREATOR));
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean equals(Object object) {
            block6: {
                block5: {
                    if (this == object) break block5;
                    if (!super.equals(object)) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    KeyphraseRecognitionEvent keyphraseRecognitionEvent = (KeyphraseRecognitionEvent)object;
                    if (!Arrays.equals(this.keyphraseExtras, keyphraseRecognitionEvent.keyphraseExtras)) break block6;
                }
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + Arrays.hashCode(this.keyphraseExtras);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder().append("KeyphraseRecognitionEvent [keyphraseExtras=").append(Arrays.toString(this.keyphraseExtras)).append(", status=").append(this.status).append(", soundModelHandle=").append(this.soundModelHandle).append(", captureAvailable=").append(this.captureAvailable).append(", captureSession=").append(this.captureSession).append(", captureDelayMs=").append(this.captureDelayMs).append(", capturePreambleMs=").append(this.capturePreambleMs).append(", triggerInData=").append(this.triggerInData);
            String string2 = this.captureFormat == null ? "" : ", sampleRate=" + this.captureFormat.getSampleRate();
            StringBuilder stringBuilder2 = stringBuilder.append(string2);
            String string3 = this.captureFormat == null ? "" : ", encoding=" + this.captureFormat.getEncoding();
            StringBuilder stringBuilder3 = stringBuilder2.append(string3);
            String string4 = this.captureFormat == null ? "" : ", channelMask=" + this.captureFormat.getChannelMask();
            StringBuilder stringBuilder4 = stringBuilder3.append(string4).append(", data=");
            if (this.data == null) {
                n = 0;
                return stringBuilder4.append(n).append("]").toString();
            }
            n = this.data.length;
            return stringBuilder4.append(n).append("]").toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.status);
            parcel.writeInt(this.soundModelHandle);
            boolean bl = this.captureAvailable;
            parcel.writeByte(bl ? 1 : 0);
            parcel.writeInt(this.captureSession);
            parcel.writeInt(this.captureDelayMs);
            parcel.writeInt(this.capturePreambleMs);
            boolean bl2 = this.triggerInData;
            parcel.writeByte(bl2 ? 1 : 0);
            if (this.captureFormat != null) {
                parcel.writeByte((byte)1);
                parcel.writeInt(this.captureFormat.getSampleRate());
                parcel.writeInt(this.captureFormat.getEncoding());
                parcel.writeInt(this.captureFormat.getChannelMask());
            } else {
                parcel.writeByte((byte)0);
            }
            parcel.writeBlob(this.data);
            parcel.writeTypedArray(this.keyphraseExtras, n);
        }
    }

    public static class KeyphraseRecognitionExtra
    implements Parcelable {
        public static final Parcelable.Creator<KeyphraseRecognitionExtra> CREATOR = new Parcelable.Creator<KeyphraseRecognitionExtra>(){

            @Override
            public KeyphraseRecognitionExtra createFromParcel(Parcel parcel) {
                return KeyphraseRecognitionExtra.fromParcel(parcel);
            }

            public KeyphraseRecognitionExtra[] newArray(int n) {
                return new KeyphraseRecognitionExtra[n];
            }
        };
        public final int coarseConfidenceLevel;
        public final ConfidenceLevel[] confidenceLevels;
        public final int id;
        public final int recognitionModes;

        public KeyphraseRecognitionExtra(int n, int n2, int n3, ConfidenceLevel[] confidenceLevelArray) {
            this.id = n;
            this.recognitionModes = n2;
            this.coarseConfidenceLevel = n3;
            this.confidenceLevels = confidenceLevelArray;
        }

        private static KeyphraseRecognitionExtra fromParcel(Parcel parcel) {
            return new KeyphraseRecognitionExtra(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.createTypedArray(ConfidenceLevel.CREATOR));
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block9: {
                block8: {
                    if (this == object) break block8;
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    KeyphraseRecognitionExtra keyphraseRecognitionExtra = (KeyphraseRecognitionExtra)object;
                    if (!Arrays.equals(this.confidenceLevels, keyphraseRecognitionExtra.confidenceLevels)) {
                        return false;
                    }
                    if (this.id != keyphraseRecognitionExtra.id) {
                        return false;
                    }
                    if (this.recognitionModes != keyphraseRecognitionExtra.recognitionModes) {
                        return false;
                    }
                    if (this.coarseConfidenceLevel != keyphraseRecognitionExtra.coarseConfidenceLevel) break block9;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return 31 * (31 * (31 * (31 + Arrays.hashCode(this.confidenceLevels)) + this.id) + this.recognitionModes) + this.coarseConfidenceLevel;
        }

        public String toString() {
            return "KeyphraseRecognitionExtra [id=" + this.id + ", recognitionModes=" + this.recognitionModes + ", coarseConfidenceLevel=" + this.coarseConfidenceLevel + ", confidenceLevels=" + Arrays.toString(this.confidenceLevels) + "]";
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.id);
            parcel.writeInt(this.recognitionModes);
            parcel.writeInt(this.coarseConfidenceLevel);
            parcel.writeTypedArray(this.confidenceLevels, n);
        }
    }

    public static class KeyphraseSoundModel
    extends SoundModel
    implements Parcelable {
        public static final Parcelable.Creator<KeyphraseSoundModel> CREATOR = new Parcelable.Creator<KeyphraseSoundModel>(){

            @Override
            public KeyphraseSoundModel createFromParcel(Parcel parcel) {
                return KeyphraseSoundModel.fromParcel(parcel);
            }

            public KeyphraseSoundModel[] newArray(int n) {
                return new KeyphraseSoundModel[n];
            }
        };
        public final Keyphrase[] keyphrases;

        public KeyphraseSoundModel(UUID uUID, UUID uUID2, byte[] byArray, Keyphrase[] keyphraseArray) {
            super(uUID, uUID2, 0, byArray);
            this.keyphrases = keyphraseArray;
        }

        private static KeyphraseSoundModel fromParcel(Parcel parcel) {
            UUID uUID = UUID.fromString(parcel.readString());
            int n = parcel.readInt();
            UUID uUID2 = null;
            if (n >= 0) {
                uUID2 = UUID.fromString(parcel.readString());
            }
            return new KeyphraseSoundModel(uUID, uUID2, parcel.readBlob(), parcel.createTypedArray(Keyphrase.CREATOR));
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder().append("KeyphraseSoundModel [keyphrases=").append(Arrays.toString(this.keyphrases)).append(", uuid=").append(this.uuid).append(", vendorUuid=").append(this.vendorUuid).append(", type=").append(this.type).append(", data=");
            if (this.data == null) {
                n = 0;
                return stringBuilder.append(n).append("]").toString();
            }
            n = this.data.length;
            return stringBuilder.append(n).append("]").toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.uuid.toString());
            if (this.vendorUuid == null) {
                parcel.writeInt(-1);
            } else {
                parcel.writeInt(this.vendorUuid.toString().length());
                parcel.writeString(this.vendorUuid.toString());
            }
            parcel.writeBlob(this.data);
            parcel.writeTypedArray(this.keyphrases, n);
        }
    }

    public static class ModuleProperties
    implements Parcelable {
        public static final Parcelable.Creator<ModuleProperties> CREATOR = new Parcelable.Creator<ModuleProperties>(){

            @Override
            public ModuleProperties createFromParcel(Parcel parcel) {
                return ModuleProperties.fromParcel(parcel);
            }

            public ModuleProperties[] newArray(int n) {
                return new ModuleProperties[n];
            }
        };
        public final String description;
        public final int id;
        public final String implementor;
        public final int maxBufferMs;
        public final int maxKeyphrases;
        public final int maxSoundModels;
        public final int maxUsers;
        public final int powerConsumptionMw;
        public final int recognitionModes;
        public final boolean returnsTriggerInEvent;
        public final boolean supportsCaptureTransition;
        public final boolean supportsConcurrentCapture;
        public final UUID uuid;
        public final int version;

        ModuleProperties(int n, String string2, String string3, String string4, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, boolean bl2, int n8, boolean bl3) {
            this.id = n;
            this.implementor = string2;
            this.description = string3;
            this.uuid = UUID.fromString(string4);
            this.version = n2;
            this.maxSoundModels = n3;
            this.maxKeyphrases = n4;
            this.maxUsers = n5;
            this.recognitionModes = n6;
            this.supportsCaptureTransition = bl;
            this.maxBufferMs = n7;
            this.supportsConcurrentCapture = bl2;
            this.powerConsumptionMw = n8;
            this.returnsTriggerInEvent = bl3;
        }

        /*
         * Enabled aggressive block sorting
         */
        private static ModuleProperties fromParcel(Parcel parcel) {
            boolean bl;
            int n = parcel.readInt();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            int n5 = parcel.readInt();
            int n6 = parcel.readInt();
            boolean bl2 = parcel.readByte() == 1;
            int n7 = parcel.readInt();
            boolean bl3 = parcel.readByte() == 1;
            int n8 = parcel.readInt();
            if (parcel.readByte() == 1) {
                bl = true;
                return new ModuleProperties(n, string2, string3, string4, n2, n3, n4, n5, n6, bl2, n7, bl3, n8, bl);
            }
            bl = false;
            return new ModuleProperties(n, string2, string3, string4, n2, n3, n4, n5, n6, bl2, n7, bl3, n8, bl);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "ModuleProperties [id=" + this.id + ", implementor=" + this.implementor + ", description=" + this.description + ", uuid=" + this.uuid + ", version=" + this.version + ", maxSoundModels=" + this.maxSoundModels + ", maxKeyphrases=" + this.maxKeyphrases + ", maxUsers=" + this.maxUsers + ", recognitionModes=" + this.recognitionModes + ", supportsCaptureTransition=" + this.supportsCaptureTransition + ", maxBufferMs=" + this.maxBufferMs + ", supportsConcurrentCapture=" + this.supportsConcurrentCapture + ", powerConsumptionMw=" + this.powerConsumptionMw + ", returnsTriggerInEvent=" + this.returnsTriggerInEvent + "]";
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            boolean bl = true;
            parcel.writeInt(this.id);
            parcel.writeString(this.implementor);
            parcel.writeString(this.description);
            parcel.writeString(this.uuid.toString());
            parcel.writeInt(this.version);
            parcel.writeInt(this.maxSoundModels);
            parcel.writeInt(this.maxKeyphrases);
            parcel.writeInt(this.maxUsers);
            parcel.writeInt(this.recognitionModes);
            boolean bl2 = this.supportsCaptureTransition ? bl : false;
            parcel.writeByte(bl2 ? 1 : 0);
            parcel.writeInt(this.maxBufferMs);
            boolean bl3 = this.supportsConcurrentCapture ? bl : false;
            parcel.writeByte(bl3 ? 1 : 0);
            parcel.writeInt(this.powerConsumptionMw);
            if (!this.returnsTriggerInEvent) {
                bl = false;
            }
            parcel.writeByte(bl ? 1 : 0);
        }
    }

    public static class RecognitionConfig
    implements Parcelable {
        public static final Parcelable.Creator<RecognitionConfig> CREATOR = new Parcelable.Creator<RecognitionConfig>(){

            @Override
            public RecognitionConfig createFromParcel(Parcel parcel) {
                return RecognitionConfig.fromParcel(parcel);
            }

            public RecognitionConfig[] newArray(int n) {
                return new RecognitionConfig[n];
            }
        };
        public final boolean allowMultipleTriggers;
        public final boolean captureRequested;
        public final byte[] data;
        public final KeyphraseRecognitionExtra[] keyphrases;

        public RecognitionConfig(boolean bl, boolean bl2, KeyphraseRecognitionExtra[] keyphraseRecognitionExtraArray, byte[] byArray) {
            this.captureRequested = bl;
            this.allowMultipleTriggers = bl2;
            this.keyphrases = keyphraseRecognitionExtraArray;
            this.data = byArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        private static RecognitionConfig fromParcel(Parcel parcel) {
            boolean bl;
            boolean bl2 = parcel.readByte() == 1;
            if (parcel.readByte() == 1) {
                bl = true;
                return new RecognitionConfig(bl2, bl, parcel.createTypedArray(KeyphraseRecognitionExtra.CREATOR), parcel.readBlob());
            }
            bl = false;
            return new RecognitionConfig(bl2, bl, parcel.createTypedArray(KeyphraseRecognitionExtra.CREATOR), parcel.readBlob());
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "RecognitionConfig [captureRequested=" + this.captureRequested + ", allowMultipleTriggers=" + this.allowMultipleTriggers + ", keyphrases=" + Arrays.toString(this.keyphrases) + ", data=" + Arrays.toString(this.data) + "]";
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            boolean bl = true;
            boolean bl2 = this.captureRequested ? bl : false;
            parcel.writeByte(bl2 ? 1 : 0);
            if (!this.allowMultipleTriggers) {
                bl = false;
            }
            parcel.writeByte(bl ? 1 : 0);
            parcel.writeTypedArray(this.keyphrases, n);
            parcel.writeBlob(this.data);
        }
    }

    public static class RecognitionEvent
    implements Parcelable {
        public static final Parcelable.Creator<RecognitionEvent> CREATOR = new Parcelable.Creator<RecognitionEvent>(){

            @Override
            public RecognitionEvent createFromParcel(Parcel parcel) {
                return RecognitionEvent.fromParcel(parcel);
            }

            public RecognitionEvent[] newArray(int n) {
                return new RecognitionEvent[n];
            }
        };
        public final boolean captureAvailable;
        public final int captureDelayMs;
        public AudioFormat captureFormat;
        public final int capturePreambleMs;
        public final int captureSession;
        public final byte[] data;
        public final int soundModelHandle;
        public final int status;
        public final boolean triggerInData;

        public RecognitionEvent(int n, int n2, boolean bl, int n3, int n4, int n5, boolean bl2, AudioFormat audioFormat, byte[] byArray) {
            this.status = n;
            this.soundModelHandle = n2;
            this.captureAvailable = bl;
            this.captureSession = n3;
            this.captureDelayMs = n4;
            this.capturePreambleMs = n5;
            this.triggerInData = bl2;
            this.captureFormat = audioFormat;
            this.data = byArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        private static RecognitionEvent fromParcel(Parcel parcel) {
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            boolean bl = parcel.readByte() == 1;
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            int n5 = parcel.readInt();
            boolean bl2 = parcel.readByte() == 1;
            byte by = parcel.readByte();
            AudioFormat audioFormat = null;
            if (by == 1) {
                int n6 = parcel.readInt();
                int n7 = parcel.readInt();
                int n8 = parcel.readInt();
                audioFormat = new AudioFormat.Builder().setChannelMask(n8).setEncoding(n7).setSampleRate(n6).build();
            }
            return new RecognitionEvent(n, n2, bl, n3, n4, n5, bl2, audioFormat, parcel.readBlob());
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block16: {
                block15: {
                    if (this == object) break block15;
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    RecognitionEvent recognitionEvent = (RecognitionEvent)object;
                    if (this.captureAvailable != recognitionEvent.captureAvailable) {
                        return false;
                    }
                    if (this.captureDelayMs != recognitionEvent.captureDelayMs) {
                        return false;
                    }
                    if (this.capturePreambleMs != recognitionEvent.capturePreambleMs) {
                        return false;
                    }
                    if (this.captureSession != recognitionEvent.captureSession) {
                        return false;
                    }
                    if (!Arrays.equals(this.data, recognitionEvent.data)) {
                        return false;
                    }
                    if (this.soundModelHandle != recognitionEvent.soundModelHandle) {
                        return false;
                    }
                    if (this.status != recognitionEvent.status) {
                        return false;
                    }
                    if (this.triggerInData != recognitionEvent.triggerInData) {
                        return false;
                    }
                    if (this.captureFormat.getSampleRate() != recognitionEvent.captureFormat.getSampleRate()) {
                        return false;
                    }
                    if (this.captureFormat.getEncoding() != recognitionEvent.captureFormat.getEncoding()) {
                        return false;
                    }
                    if (this.captureFormat.getChannelMask() != recognitionEvent.captureFormat.getChannelMask()) break block16;
                }
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public int hashCode() {
            int n = 1231;
            int n2 = this.captureAvailable ? n : 1237;
            int n3 = 31 * (31 * (31 * (31 * (n2 + 31) + this.captureDelayMs) + this.capturePreambleMs) + this.captureSession);
            if (!this.triggerInData) {
                n = 1237;
            }
            int n4 = n3 + n;
            if (this.captureFormat != null) {
                n4 = 31 * (31 * (n4 * 31 + this.captureFormat.getSampleRate()) + this.captureFormat.getEncoding()) + this.captureFormat.getChannelMask();
            }
            return 31 * (31 * (n4 * 31 + Arrays.hashCode(this.data)) + this.soundModelHandle) + this.status;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder().append("RecognitionEvent [status=").append(this.status).append(", soundModelHandle=").append(this.soundModelHandle).append(", captureAvailable=").append(this.captureAvailable).append(", captureSession=").append(this.captureSession).append(", captureDelayMs=").append(this.captureDelayMs).append(", capturePreambleMs=").append(this.capturePreambleMs).append(", triggerInData=").append(this.triggerInData);
            String string2 = this.captureFormat == null ? "" : ", sampleRate=" + this.captureFormat.getSampleRate();
            StringBuilder stringBuilder2 = stringBuilder.append(string2);
            String string3 = this.captureFormat == null ? "" : ", encoding=" + this.captureFormat.getEncoding();
            StringBuilder stringBuilder3 = stringBuilder2.append(string3);
            String string4 = this.captureFormat == null ? "" : ", channelMask=" + this.captureFormat.getChannelMask();
            StringBuilder stringBuilder4 = stringBuilder3.append(string4).append(", data=");
            if (this.data == null) {
                n = 0;
                return stringBuilder4.append(n).append("]").toString();
            }
            n = this.data.length;
            return stringBuilder4.append(n).append("]").toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.status);
            parcel.writeInt(this.soundModelHandle);
            boolean bl = this.captureAvailable;
            parcel.writeByte(bl ? 1 : 0);
            parcel.writeInt(this.captureSession);
            parcel.writeInt(this.captureDelayMs);
            parcel.writeInt(this.capturePreambleMs);
            boolean bl2 = this.triggerInData;
            parcel.writeByte(bl2 ? 1 : 0);
            if (this.captureFormat != null) {
                parcel.writeByte((byte)1);
                parcel.writeInt(this.captureFormat.getSampleRate());
                parcel.writeInt(this.captureFormat.getEncoding());
                parcel.writeInt(this.captureFormat.getChannelMask());
            } else {
                parcel.writeByte((byte)0);
            }
            parcel.writeBlob(this.data);
        }
    }

    public static class SoundModel {
        public static final int TYPE_KEYPHRASE = 0;
        public static final int TYPE_UNKNOWN = -1;
        public final byte[] data;
        public final int type;
        public final UUID uuid;
        public final UUID vendorUuid;

        public SoundModel(UUID uUID, UUID uUID2, int n, byte[] byArray) {
            this.uuid = uUID;
            this.vendorUuid = uUID2;
            this.type = n;
            this.data = byArray;
        }
    }

    public static class SoundModelEvent
    implements Parcelable {
        public static final Parcelable.Creator<SoundModelEvent> CREATOR = new Parcelable.Creator<SoundModelEvent>(){

            @Override
            public SoundModelEvent createFromParcel(Parcel parcel) {
                return SoundModelEvent.fromParcel(parcel);
            }

            public SoundModelEvent[] newArray(int n) {
                return new SoundModelEvent[n];
            }
        };
        public final byte[] data;
        public final int soundModelHandle;
        public final int status;

        SoundModelEvent(int n, int n2, byte[] byArray) {
            this.status = n;
            this.soundModelHandle = n2;
            this.data = byArray;
        }

        private static SoundModelEvent fromParcel(Parcel parcel) {
            return new SoundModelEvent(parcel.readInt(), parcel.readInt(), parcel.readBlob());
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block8: {
                block7: {
                    if (this == object) break block7;
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    SoundModelEvent soundModelEvent = (SoundModelEvent)object;
                    if (!Arrays.equals(this.data, soundModelEvent.data)) {
                        return false;
                    }
                    if (this.soundModelHandle != soundModelEvent.soundModelHandle) {
                        return false;
                    }
                    if (this.status != soundModelEvent.status) break block8;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return 31 * (31 * (31 + Arrays.hashCode(this.data)) + this.soundModelHandle) + this.status;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder().append("SoundModelEvent [status=").append(this.status).append(", soundModelHandle=").append(this.soundModelHandle).append(", data=");
            if (this.data == null) {
                n = 0;
                return stringBuilder.append(n).append("]").toString();
            }
            n = this.data.length;
            return stringBuilder.append(n).append("]").toString();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.status);
            parcel.writeInt(this.soundModelHandle);
            parcel.writeBlob(this.data);
        }
    }

    public static interface StatusListener {
        public void onRecognition(RecognitionEvent var1);

        public void onServiceDied();

        public void onServiceStateChange(int var1);

        public void onSoundModelUpdate(SoundModelEvent var1);
    }
}

