/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.soundtrigger;

import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.hardware.soundtrigger.KeyphraseMetadata;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Slog;
import java.util.Arrays;
import java.util.Locale;

public class KeyphraseEnrollmentInfo {
    public static final String ACTION_MANAGE_VOICE_KEYPHRASES = "com.android.intent.action.MANAGE_VOICE_KEYPHRASES";
    public static final String EXTRA_VOICE_KEYPHRASE_ACTION = "com.android.intent.extra.VOICE_KEYPHRASE_ACTION";
    public static final String EXTRA_VOICE_KEYPHRASE_HINT_TEXT = "com.android.intent.extra.VOICE_KEYPHRASE_HINT_TEXT";
    public static final String EXTRA_VOICE_KEYPHRASE_LOCALE = "com.android.intent.extra.VOICE_KEYPHRASE_LOCALE";
    private static final String TAG = "KeyphraseEnrollmentInfo";
    private static final String VOICE_KEYPHRASE_META_DATA = "android.voice_enrollment";
    private String mEnrollmentPackage;
    private KeyphraseMetadata[] mKeyphrases;
    private String mParseError;

    /*
     * Exception decompiling
     */
    public KeyphraseEnrollmentInfo(PackageManager var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 151->202)] android.content.pm.PackageManager$NameNotFoundException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initializeKeyphrasesFromTypedArray(TypedArray typedArray) {
        int n;
        int n2 = typedArray.getInt(0, -1);
        if (n2 <= 0) {
            this.mParseError = "No valid searchKeyphraseId specified in meta-data";
            Slog.w(TAG, this.mParseError);
            return;
        }
        String string2 = typedArray.getString(1);
        if (string2 == null) {
            this.mParseError = "No valid searchKeyphrase specified in meta-data";
            Slog.w(TAG, this.mParseError);
            return;
        }
        String string3 = typedArray.getString(2);
        if (string3 == null) {
            this.mParseError = "No valid searchKeyphraseSupportedLocales specified in meta-data";
            Slog.w(TAG, this.mParseError);
            return;
        }
        ArraySet<Locale> arraySet = new ArraySet<Locale>();
        if (!TextUtils.isEmpty(string3)) {
            int n3;
            String[] stringArray;
            try {
                stringArray = string3.split(",");
                n3 = 0;
            }
            catch (Exception exception) {
                this.mParseError = "Error reading searchKeyphraseSupportedLocales from meta-data";
                Slog.w(TAG, this.mParseError, exception);
                return;
            }
            while (true) {
                if (n3 < stringArray.length) {
                    arraySet.add(Locale.forLanguageTag(stringArray[n3]));
                    ++n3;
                    continue;
                }
                break;
            }
        }
        if ((n = typedArray.getInt(3, -1)) < 0) {
            this.mParseError = "No valid searchKeyphraseRecognitionFlags specified in meta-data";
            Slog.w(TAG, this.mParseError);
            return;
        }
        this.mKeyphrases = new KeyphraseMetadata[1];
        this.mKeyphrases[0] = new KeyphraseMetadata(n2, string2, arraySet, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KeyphraseMetadata getKeyphraseMetadata(String string2, Locale locale) {
        if (this.mKeyphrases == null || this.mKeyphrases.length == 0) {
            Slog.w(TAG, "Enrollment application doesn't support keyphrases");
            return null;
        }
        for (KeyphraseMetadata keyphraseMetadata : this.mKeyphrases) {
            if (!keyphraseMetadata.supportsPhrase(string2)) continue;
            if (keyphraseMetadata.supportsLocale(locale)) return keyphraseMetadata;
        }
        Slog.w(TAG, "Enrollment application doesn't support the given keyphrase/locale");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Intent getManageKeyphraseIntent(int n, String string2, Locale locale) {
        if (this.mEnrollmentPackage == null || this.mEnrollmentPackage.isEmpty()) {
            Slog.w(TAG, "No enrollment application exists");
            return null;
        } else {
            if (this.getKeyphraseMetadata(string2, locale) == null) return null;
            return new Intent(ACTION_MANAGE_VOICE_KEYPHRASES).setPackage(this.mEnrollmentPackage).putExtra(EXTRA_VOICE_KEYPHRASE_HINT_TEXT, string2).putExtra(EXTRA_VOICE_KEYPHRASE_LOCALE, locale.toLanguageTag()).putExtra(EXTRA_VOICE_KEYPHRASE_ACTION, n);
        }
    }

    public String getParseError() {
        return this.mParseError;
    }

    public KeyphraseMetadata[] listKeyphraseMetadata() {
        return this.mKeyphrases;
    }

    public String toString() {
        return "KeyphraseEnrollmentInfo [Keyphrases=" + Arrays.toString(this.mKeyphrases) + ", EnrollmentPackage=" + this.mEnrollmentPackage + ", ParseError=" + this.mParseError + "]";
    }
}

