/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.os.Parcel;
import android.os.Parcelable;

public final class KeyboardLayout
implements Parcelable,
Comparable<KeyboardLayout> {
    public static final Parcelable.Creator<KeyboardLayout> CREATOR = new Parcelable.Creator<KeyboardLayout>(){

        @Override
        public KeyboardLayout createFromParcel(Parcel parcel) {
            return new KeyboardLayout(parcel);
        }

        public KeyboardLayout[] newArray(int n) {
            return new KeyboardLayout[n];
        }
    };
    private final String mCollection;
    private final String mDescriptor;
    private final String mLabel;
    private final int mPriority;

    private KeyboardLayout(Parcel parcel) {
        this.mDescriptor = parcel.readString();
        this.mLabel = parcel.readString();
        this.mCollection = parcel.readString();
        this.mPriority = parcel.readInt();
    }

    public KeyboardLayout(String string2, String string3, String string4, int n) {
        this.mDescriptor = string2;
        this.mLabel = string3;
        this.mCollection = string4;
        this.mPriority = n;
    }

    @Override
    public int compareTo(KeyboardLayout keyboardLayout) {
        int n = Integer.compare(keyboardLayout.mPriority, this.mPriority);
        if (n == 0) {
            n = this.mLabel.compareToIgnoreCase(keyboardLayout.mLabel);
        }
        if (n == 0) {
            n = this.mCollection.compareToIgnoreCase(keyboardLayout.mCollection);
        }
        return n;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getCollection() {
        return this.mCollection;
    }

    public String getDescriptor() {
        return this.mDescriptor;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public String toString() {
        if (this.mCollection.isEmpty()) {
            return this.mLabel;
        }
        return this.mLabel + " - " + this.mCollection;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mDescriptor);
        parcel.writeString(this.mLabel);
        parcel.writeString(this.mCollection);
        parcel.writeInt(this.mPriority);
    }
}

